/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.status;

import javax.baja.sys.*;

/**
 * BIStatusValue which can return themselves as a BStatusValue.
 *
 * @author    Brian Frank
 * @creation  28 Sept 00
 * @version   $Revision: 2$ $Date: 3/28/05 9:23:05 AM EST$
 * @since     Baja 1.0
 */
public interface BIStatusValue
  extends BIStatus
{ 

  /**
   * Get the object as a BStatusValue.
   */
  public BStatusValue getStatusValue();

  /**
   * Get facets for the status value or BFacets.NULL 
   * if not applicable.
   */
  public BFacets getStatusValueFacets();

  public static final Type TYPE = Sys.loadType(BIStatusValue.class);
  
}
