/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.spy;

/**
 * ISpyDir is implemented by Spy pages which contain
 * child Spy pages.
 *
 * @author    Brian Frank on 5 Mar 03
 * @version   $Revision: 2$ $Date: 3/28/05 9:23:04 AM EST$
 * @since     Baja 1.0
 */
public interface ISpyDir
{

  /**
   * List the child spy names.
   */
  String[] list();

  /**
   * Get the specified child by name or return null.
   */
  Spy find(String name);

  /**
   * <p>
   * Some spy children names contain an appended CSRF token.
   * In the case of a CSRF validation failure, the error spy page
   * attempts to provide a 'retry' name containing a proper CSRF
   * token for the current session.  This method is given the
   * invalid name that failed the CSRF validation and should return
   * a new name containing a proper CSRF token for the current session.
   * </p>
   * <p>
   * The default implementation replaces the CSRF token at the end
   * of the given invalid name with a new token.
   * </p>
   *
   * @param invalidName A child name that failed during CSRF token validation.
   * @return A new child name containing a properly formed CSRF token for the
   * current session.
   *
   * @since Niagara 4.3
   * @deprecated in 4.10u11 and 4.14u2
   */
  @Deprecated
  default String regenerateNameWithCsrfToken(String invalidName)
  {
    throw new UnsupportedOperationException("regenerateNameWithCsrfToken deprecated");
  }
  
}
