/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.space;

import javax.baja.sys.*;
import javax.baja.naming.*;

/**
 * The BHandleScheme is identified via scheme id of "h".  It
 * is used to identify a BComponent within a BComponentSpace
 * via its unique handle.
 *
 * @author    Brian Frank
 * @creation  30 Mar 03
 * @version   $Revision: 3$ $Date: 3/28/05 9:23:03 AM EST$
 * @since     Baja 1.0
 */
public class BHandleScheme
  extends BOrdScheme
{

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public static final BHandleScheme INSTANCE = new BHandleScheme();

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHandleScheme.class);

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////  

  /**
   * Constructor with scheme id.
   */
  private BHandleScheme()
  {
    super("h");
  }

////////////////////////////////////////////////////////////////
// BOrdScheme
////////////////////////////////////////////////////////////////

  /**
   * See documentation in class header for how resolve works.
   */
  @Override
  public OrdTarget resolve(OrdTarget base, OrdQuery query)
    throws SyntaxException, UnresolvedException
  {
    // need to enhance SpaceScheme
    BObject baseObject = base.get();
    BComponentSpace space = null;
    String handle = query.getBody();
    
    if (baseObject instanceof BComponentSpace)
    {
      space = (BComponentSpace)baseObject;
    }
    else if (baseObject instanceof BComponent)
    {                                     
      space = baseObject.asComponent().getComponentSpace();
    }
    
    if (space == null)
      throw new InvalidOrdBaseException("Not based via ComponentSpace");
    
    return new OrdTarget(base, space.resolveByHandle(handle));
  }
  
}

