/*
 * Copyright 2011 - Tridium Inc, All Rights Reserved.
 */

package javax.baja.security.crypto;

import java.security.Key;
import java.security.cert.X509Certificate;

/**
 * IKeyStore is the type of object returned from 
 * a call to getTrustStore or getUserTrustStore from an
 * ICryptoManager.
 * 
 * @see java.security.KeyStore
 *
 * @author    $Author$
 * @creation  29 June 2011
 * @version   $Revision$ $Date$
 * @since     Niagara 3.7
 */

public interface IKeyStore extends ITrustStore
{
  Key getKey(String alias, char[] password) throws Exception;
  void setKeyEntry(String alias, byte[] key, X509Certificate[] chain) throws Exception;
  void setKeyEntry(String alias, Key key, char[] password, X509Certificate[] chain) throws Exception;
}
