/*
 * Copyright 2011 - Tridium Inc, All Rights Reserved.
 */

package javax.baja.security.crypto;

import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.baja.nre.security.ClientTlsParameters;
import javax.baja.nre.security.ServerTlsParameters;

/**
 * ICrytptoManager is the type of object returned from 
 * CryptoManagerFactory. The implementing instance is
 * matched with the calling environment: wbapplet, wb, station
 *
 * @author    $Author$
 * @creation  29 June 2011
 * @version   $Revision$ $Date$
 * @since     Niagara 3.7
 */

public interface ICryptoManager
{
  /**
   * @return an reference to the user trust store
   * @throws Exception
   */
  ITrustStore getUserTrustStore() throws Exception;

  /**
   * @return a reference to the user untrusted store
   * @throws Exception
   */
  ITrustStore getUserUntrustedStore() throws Exception;

  /**
   * @return an reference to the system trust store
   * @throws Exception
   */
  ITrustStore getSystemTrustStore() throws Exception;

  /**
   * @return a reference to the system key store
   * @throws Exception
   */  
  IKeyStore getKeyStore() throws Exception;
  
  /**
   * @deprecated replaced by {@link #getServerSocketFactory(ServerTlsParameters)}
   * @param type supported tls versions (tlsv1, tlsv1.1, tlsv1.2)
   * @param clientAuth currently unsupported
   * @param serverAlias the alias of the certificate to use for this socket factory
   * @return in instance of a server socket factory using the specified ssl type and certificate
   * @throws Exception
   */
  @Deprecated
  ServerSocketFactory getServerSocketFactory(BSslTlsEnum type, boolean clientAuth, String serverAlias) throws Exception;

  /**
   * @param tlsParams parameters for establishing the tls connection
   * @return in instance of a server socket factory using the specified tls parameters
   * @throws Exception
   * @since Niagara 4.4u1
   */
  default ServerSocketFactory getServerSocketFactory(ServerTlsParameters tlsParams) throws Exception
  {
    throw new UnsupportedOperationException();
  }

  /**
   * @deprecated replaced by {@link #getClientSocketFactory(ClientTlsParameters)}
   * @param type supported tls versions (tlsv1, tlsv1.1, tlsv1.2)
   * @return an instance of a client socket factory using the specified ssl protocol type
   * @throws Exception
   */
  @Deprecated
  SocketFactory getClientSocketFactory(BSslTlsEnum type) throws Exception;

  /**
   * @param tlsParams parameters for establishing the tls connection
   * @return an instance of a client socket factory using the specified ssl protocol type
   * @throws Exception
   * @since Niagara 4.4u1
   */

  default SocketFactory getClientSocketFactory(ClientTlsParameters tlsParams) throws Exception
  {
    throw new UnsupportedOperationException();
  }
}
