/**
 * Copyright 2011 - Tridium Inc, All Rights Reserved.
 */

package javax.baja.security.crypto;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BSslTlsEnum is a list of the supported ssl protocols
 * 
 * @author    $Author$
 * @creation  29 June 2011
 * @version   $Revision$ $Date$
 * @since     Niagara 3.7
 */

public final class BSslTlsEnum
    extends BFrozenEnum
{
  /*-
   enum BSslTlsEnum
   {
     range
     {
       tlsv1 = 1,
       tlsv1_1 = 2,
       tlsv1_2 = 4
     }
     
     default {[ tlsv1 ]}
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.security.crypto.BSslTlsEnum(119158967)1.0$ @*/
/* Generated Thu Nov 20 11:37:02 EST 2014 by Slot-o-Matic (c) Tridium, Inc. 2012 */
  
  /** Ordinal value for tlsv1. */
  public static final int TLSV_1 = 1;
  /** Ordinal value for tlsv1_1. */
  public static final int TLSV_1_1 = 2;
  /** Ordinal value for tlsv1_2. */
  public static final int TLSV_1_2 = 4;
  
  /** BSslTlsEnum constant for tlsv1. */
  public static final BSslTlsEnum tlsv1 = new BSslTlsEnum(TLSV_1);
  /** BSslTlsEnum constant for tlsv1_1. */
  public static final BSslTlsEnum tlsv1_1 = new BSslTlsEnum(TLSV_1_1);
  /** BSslTlsEnum constant for tlsv1_2. */
  public static final BSslTlsEnum tlsv1_2 = new BSslTlsEnum(TLSV_1_2);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSslTlsEnum.class);
  
  /** Factory method with ordinal. */
  public static BSslTlsEnum make(int ordinal)
  {
    return (BSslTlsEnum)tlsv1.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BSslTlsEnum make(String tag)
  {
    return (BSslTlsEnum)tlsv1.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BSslTlsEnum(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BSslTlsEnum DEFAULT = tlsv1;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
