/*
 * Copyright (c) 2017 Tridium, Inc. All Rights Reserved.
 */

package javax.baja.security;

import com.tridium.crypto.core.cert.NX509Certificate;

import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;

/**
 * BX509CertificateCredential is a simple implementation of a BIUserCredential
 * for storing an x509 certificate with the username being defined as the first
 * CN field found in the dname or null.
 *
 * @author Bill Smith on 1/13/2017
 * @since Niagara 4.5
 */
@NiagaraType(agent = @AgentOn(types = {"baja:ClientCredentials"}))
@NiagaraProperty(name="x509Certificate", type="BX509Certificate", flags= Flags.READONLY, defaultValue = "BX509Certificate.DEFAULT")
public class BX509CertificateCredential
    extends BStruct
    implements BIUserCredentials, BIAgent
{
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.security.BX509CertificateCredential(1496866639)1.0$ @*/
/* Generated Fri Jan 13 16:26:01 EST 2017 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Property "x509Certificate"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code x509Certificate} property.
   *
   * @see #getX509Certificate
   * @see #setX509Certificate
   */
  public static final Property x509Certificate = newProperty(Flags.READONLY, BX509Certificate.DEFAULT, null);

  /**
   * Get the {@code x509Certificate} property.
   *
   * @see #x509Certificate
   */
  public BX509Certificate getX509Certificate()
  {
    return (BX509Certificate) get(x509Certificate);
  }

  /**
   * Set the {@code x509Certificate} property.
   *
   * @see #x509Certificate
   */
  public void setX509Certificate(BX509Certificate v)
  {
    set(x509Certificate, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BX509CertificateCredential.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Default constructor.
   *
   * @since Niagara 4.5
   */
  public BX509CertificateCredential()
  {
  }

  /**
   * Constructor with a BX509Certificate.
   *
   * @since Niagara 4.5
   */
  public BX509CertificateCredential(BX509Certificate bcert)
  {
    setX509Certificate(bcert);
  }

  /**
   * Constructor with an X509Certificate.
   *
   * @since Niagara 4.5
   */
  public BX509CertificateCredential(X509Certificate cert)
  {
    setX509Certificate(BX509Certificate.make(cert));
  }

  /**
   * Constructor with a string encoded X509Certificate.
   *
   * @since Niagara 4.5
   */
  public BX509CertificateCredential(String encoded)
  {
    setX509Certificate(BX509Certificate.make(encoded));
  }

  /**
   * Returns the "username" from the certificate which is the first CN entry in the dname.
   *
   * @since Niagara 4.5
   */
  @Override
  public String getUsername()
  {
    BX509Certificate cert = getX509Certificate();
    if (cert == null)
    {
      return null;
    }
    return cert.getUsername();
  }

  /**
   * Returns a boolean indicating whether the credential represents a new
   * user with no stored credentials.
   *
   * @since Niagara 4.5
   */
  @Override
  public boolean isNewUser()
  {
    return isNewUser;
  }

  /**
   * Sets an indicator that this is a new user or not.
   *
   * @since Niagara 4.5
   */
  public void setNewUser(boolean newUser)
  {
    isNewUser = newUser;
  }

  /**
   * Encode the credentials into a byte array which
   * may stored in a credential database.
   *
   * @since Niagara 4.5
   */
  @Override
  public byte[] encodeCredentials(Context context)
      throws IOException
  {
    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    DataOutputStream out = new DataOutputStream(bout);
    getX509Certificate().encode(out);
    out.flush();
    return bout.toByteArray();
  }

  /**
   * Decode the credentials from a byte array generated
   * using encode().
   *
   * @since Niagara 4.5
   */
  @Override
  public BICredentials decodeCredentials(byte[] encoding, Context context)
      throws IOException
  {
    ByteArrayInputStream bin = new ByteArrayInputStream(encoding);
    DataInputStream in = new DataInputStream(bin);
    BX509CertificateCredential x = (BX509CertificateCredential)newCopy();
    x.set(x509Certificate, (BValue)BX509Certificate.DEFAULT.decode(in));
    return x;
  }

  public static final BX509CertificateCredential DEFAULT = new BX509CertificateCredential();

  private boolean isNewUser = false;
}
