/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security;

import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import javax.baja.nre.util.SecurityUtil;
import com.tridium.nre.security.SecretChars;

@NiagaraType(agent = @AgentOn(types = {"baja:Password"}))
public final class BPlainPasswordEncoder
    extends BAbstractPasswordEncoder
    implements BIAgent
{
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.security.BPlainPasswordEncoder(119196451)1.0$ @*/
/* Generated Fri Apr 10 14:04:24 EDT 2015 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BPlainPasswordEncoder.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BPlainPasswordEncoder(){}
  
////////////////////////////////////////////////////////////////
// BAbstractPasswordEncoder
////////////////////////////////////////////////////////////////

  @Override
  public void encode(SecretChars password)
  {
    value = password.newCopy();
  }

  @Override
  public void parse(String key) throws IllegalArgumentException
  {
    value = SecretChars.fromString(key);
  }

  @Override
  public boolean isReversible()
  {
    return true;
  }

  @Override
  public String getValue()
  {
    return new String(value.get());
  }

  @Override
  public String getEncodingType()
  {
    return ENCODING_TYPE;
  }

  @Override
  public boolean validate(SecretChars password)
  {
    return SecurityUtil.equals(password.get(), value.get());
  }

  @Override
  public String getEncodedValue()
  {
    return new String(value.get());
  }
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  private SecretChars value = null;
  public static final String ENCODING_TYPE = "plain.1";

}
