/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BIUserCredentials is a type of {@link BICredentials} object that enforces
 * the association of a Username with the credentials.
 *
 * @author 		J. Spangler
 * @creation 	Jul 21, 2010
 * @version		1
 * @since			Niagara 3.6
 */
public interface BIUserCredentials
    extends BICredentials
{

  public static final Type TYPE = Sys.loadType(BIUserCredentials.class);
  
  /** 
   * Return the user name associated with the credentials. It is assumed
   * that all credentials are associated with some user.
   * 
   * @return String
   * @since Niagara 3.6
   */
  public String getUsername();

  /**
   * Returns a boolean indicating whether the credential represents a new
   * user with no stored credentials.
   *
   * @return
   */
  public default boolean isNewUser()  { return false; }
  
}
