/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security;

import java.util.Objects;
import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridium.nre.security.Aes256PasswordManager;
import com.tridium.nre.security.AesAlgorithmBundle;
import com.tridium.nre.security.EncryptionAlgorithmBundle;

@NiagaraType(agent = @AgentOn(types = {"baja:Password"}))
public class BAes256PasswordEncoder
  extends BAbstractAes256PasswordEncoder
  implements BIAgent
{
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.security.BAes256PasswordEncoder(119196451)1.0$ @*/
/* Generated Fri Apr 10 14:04:24 EDT 2015 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAes256PasswordEncoder.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////
  public BAes256PasswordEncoder()
  {
    keyAlias = Aes256PasswordManager.DEFAULT_AES_KEY_ALIAS;
  }

////////////////////////////////////////////////////////////////
// BAbstractPasswordEncoder
////////////////////////////////////////////////////////////////

  @Override
  public void parse(String key) throws Exception
  {
    try
    {
      String[] data = getAlgorithmBundle().decode(key);
      Objects.requireNonNull(data);
      iv = data[AesAlgorithmBundle.IV_INDEX];
      cipher = data[AesAlgorithmBundle.CIPHER_INDEX];
    }
    catch (IllegalArgumentException iae)
    {
      // Couldn't parse it, maybe it's not actually encoded
      encode(key);
    }
  }

  @Override
  public String getEncodingType()
  {
    return ENCODING_TYPE;
  }

  @Override
  public String getEncodedValue()
  {
    String[] data = new String[getAlgorithmBundle().getDataElementCount()];
    data[AesAlgorithmBundle.CIPHER_INDEX] = cipher;
    data[AesAlgorithmBundle.IV_INDEX] = iv;
    return getAlgorithmBundle().encode(data);
  }

  @Override
  protected EncryptionAlgorithmBundle getAlgorithmBundle()
  {
    return ALGORITHM_BUNDLE;
  }

  ////////////////////////////////////////////////////////////////
// Constants
////////////////////////////////////////////////////////////////
  public static final AesAlgorithmBundle ALGORITHM_BUNDLE = AesAlgorithmBundle.make(256);
  public static final String ENCODING_TYPE = ALGORITHM_BUNDLE.getAlgorithmName();
}
