/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.role;

import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * A BIRoleListener will receive notifications when 
 * a peer BIRoleSource service removes or adds a role. 
 * 
 * @author    Joseph Chandler
 * @creation  30 Aug 2014
 * @version   4.0
 * @since     Baja 4.0
 */

public interface BIRoleListener
  extends BIPropertyContainer
{
	
  Type TYPE = Sys.loadType(BIRoleListener.class);

	/**
	 * Receive notification that a role source has removed
	 * a role and that any principals currently using the 
	 * role should have that role removed. 
	 * 
	 * @param source the BIRoleService
	 * @param roleIdentifier that was removed
	 */
  public void removeRole(BIRoleService source, String roleIdentifier);
	
  /**
   * Receives notifications when a role's identifier has been changed
   * 
   * @param source the BIRoleService
   * @param oldIdentifier The previous role identifier 
   * @param newIdentifier The new role identifier
   */
  public void renameRole(BIRoleService source, String oldIdentifier, String newIdentifier);

  /**
   * Receives notifications when a role's identifier has been changed
   *
   * @param source the identifier of the BIRoleService
   * @param identifier The previous role identifier
   */
  public void changedRole(BIRoleService source, String identifier);
  
}
