/*
 * Copyright 2014 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.role;

import javax.baja.security.BPermissionsMap;
import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BIRole represents a group of permissions in the Baja framework.
 *
 * @author    Joseph Chandler
 * @creation  30 Aug 2014
 * @version   4.0
 * @since     Baja 4.0
 */
public interface BIRole
  extends BInterface, Comparable<BIRole>
{ 
  Type TYPE = Sys.loadType(BIRole.class);
  
  public String getRoleIdentifier();
  
  public BPermissionsMap getPermissions();

  public boolean getEnabled();

}