/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.role;

import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BAbstractRole is role base class.
 *
 * @author    Joseph Chandler
 * @creation  30 Aug 2014
 * @version   4
 * @since     Baja 4.0
 */
public abstract class BAbstractRole
  extends BComponent
  implements BIRole, Comparable<BIRole>
{ 

  /*-
  
  class BAbstractRole
  {
    
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.role.BAbstractRole(1639289973)1.0$ @*/
/* Generated Fri Nov 14 10:44:00 EST 2014 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAbstractRole.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
////////////////////////////////////////////////////////////////
//Comparable
////////////////////////////////////////////////////////////////

  @Override
  public int compareTo(BIRole other)
  {
    if(other!=null)
    {
      String roleId = getRoleIdentifier();
      if(roleId != null)
      {
        String otherRoleId = other.getRoleIdentifier();
        if(otherRoleId != null)
          return roleId.compareTo(otherRoleId);
      }
    }
    return -1;
  }
}
