/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.nav;

import javax.baja.sys.*;
import javax.baja.naming.*;

/**
 * BNavFileNode is a BINavNode loaded from a nav file using NavFileDecoder.
 *
 * @author    Brian Frank
 * @creation  1 Sept 04
 * @version   $Revision: 4$ $Date: 3/28/05 9:23:01 AM EST$
 * @since     Baja 1.0
 */
public class BNavFileNode
  extends BNavContainer
{

////////////////////////////////////////////////////////////////
// Constructor 
////////////////////////////////////////////////////////////////

  public BNavFileNode(String name, BOrd navOrd, BIcon icon)
  {
    super(name);
    
    if (icon == null || icon.isNull()) icon = defaultIcon;
    
    this.navOrd = navOrd;
    this.icon = icon;
  }

////////////////////////////////////////////////////////////////
// BINavNode
////////////////////////////////////////////////////////////////
  
  /**
   * Get the normalized absolute ord for this node.
   */
  @Override
  public BOrd getNavOrd()
  {
    return navOrd;
  }
  
  /**
   * Get the nav ord relativized to the session which is
   * typically how it is used within the station VM.
   */
  public BOrd getOrdInSession()
  {                          
    if (ordInSession == null)
      ordInSession = navOrd.relativizeToSession();
    return ordInSession;
  }

  @Override
  protected void fireNavEvent(NavEvent event)
  {
    // don't fire any events - nav file are always
    // loaded in one batch inside a NavFileSpace
  }
  
////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////

  @Override
  public BIcon getIcon()
  { 
    return icon; 
  }
  
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////  

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNavFileNode.class);
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////  

  static final BIcon defaultIcon = BIcon.std("folder.png");

  BIcon icon;
  BOrd navOrd, ordInSession;

}

