package javax.baja.naming;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;

/**
 * An ORD scheme that resolves a type spec (moduleName:typeName)
 * to a {@link javax.baja.util.BTypeSpec}.
 *
 * @author Gareth Johnson on 17/09/2015.
 * @since Niagara 4.1
 */
public final class BTypeScheme extends BOrdScheme
{
  private BTypeScheme()
  {
    super("type");
  }

  @Override
  public OrdTarget resolve(OrdTarget base, OrdQuery query)
    throws SyntaxException, UnresolvedException
  {
    String typeSpec = query.getBody();
    try
    {
      return new OrdTarget(base, Sys.getRegistry().getType(typeSpec).getTypeSpec());
    }
    catch(TypeNotFoundException e)
    {
      throw new UnresolvedException("Could not resolve type: " + typeSpec, e);
    }
  }

  public static final BTypeScheme INSTANCE = new BTypeScheme();

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BTypeScheme.class);
}
