/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.naming;

import javax.baja.nav.BNavContainer;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

import com.tridium.util.BSessionInfo;

/**
 * BSession
 *
 * @author    Brian Frank
 * @creation  15 May 03
 * @version   $Revision: 4$ $Date: 3/28/05 9:23:01 AM EST$
 * @since     Baja 1.0
 */
public abstract class BSession
  extends BNavContainer
  implements BISession
{

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  protected BSession(String name, LexiconText lexText)
  {
    super(name, lexText);
  }

  protected BSession(String name)
  {
    super(name);
  }

////////////////////////////////////////////////////////////////
// Context
////////////////////////////////////////////////////////////////
  
  /**
   * Get the Context to use for this session.  Default 
   * implementation returns null.
   */
  @Override
  public Context getSessionContext()
  {
    return null;
  }
  
  public BSessionInfo getSessionInfo()
  {
    return null;
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////  

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSession.class);

}

