/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.naming;

import javax.baja.sys.*;

/**
 * BLocalScheme is the ord scheme represented as "local:".
 * It is a shortcut for for "host: localhost" which always
 * maps to BLocalHost.INSTANCE.
 *
 * @author    Brian Frank
 * @creation  14 Jan 03
 * @version   $Revision: 8$ $Date: 5/19/03 11:14:35 AM EDT$
 * @since     Baja 1.0
 */
public class BLocalScheme
  extends BOrdScheme
{

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  /**
   * Private constructor.
   */
  private BLocalScheme()
  {
    super("local");
  }

////////////////////////////////////////////////////////////////
// BOrdScheme
////////////////////////////////////////////////////////////////

  @Override
  public OrdQuery parse(String queryBody)
  {
    return QUERY;
  }

  /**
   * Always return BLocalHost.INSTANCE
   */
  @Override
  public OrdTarget resolve(OrdTarget base, OrdQuery query)
    throws SyntaxException, UnresolvedException
  {
    return new OrdTarget(base, BLocalHost.INSTANCE);
  }

////////////////////////////////////////////////////////////////
// LocalQuery
////////////////////////////////////////////////////////////////  

  static class LocalQuery implements OrdQuery
  {

    @Override
    public boolean isHost() { return true; }

    @Override
    public boolean isSession() { return true; }
  
    @Override
    public void normalize(OrdQueryList list, int index) { list.trim(index); }

    @Override
    public String getScheme() { return "local"; }
    
    @Override
    public String getBody() { return ""; }
    
    public String toString() { return "local:"; }
  
  }

  static final LocalQuery QUERY = new LocalQuery();

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////  

  /** This the "local:" ord. */
  public static final BOrd ORD = BOrd.make("local:");

  public static final BLocalScheme INSTANCE = new BLocalScheme();

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLocalScheme.class);

}

