/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.job;

import javax.baja.sys.*;

/**
 * BRunnableJob provides a simple job implementations 
 * for executing runnable tasks in the job framework.
 *
 * @author    Lee Adcock    
 * @creation  12 April 2010
 * @version   $Revision: 1$ $Date: 4/12/10 10:53:18 AM EDT$
 * @since     Baja 1.0
 */
public class BRunnableJob 
  extends BSimpleJob
{
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BRunnableJob.class);
  
  public BRunnableJob(Runnable runnable)
  {
    this.runnable = runnable;
  }
  
  public BRunnableJob()
  {
  }

  public final void run(Context cx)
    throws Exception
  {
    if (runnable!=null)
    {
      runnable.run();
    }
  }

  private Runnable runnable = null;
}
