/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.job;

import javax.baja.sys.*;
import javax.baja.naming.*;

/**
 * IJobService provides a common interface used for managing jobs
 * consistently in both a station and workbench environment.
 *
 * @author    Brian Frank       
 * @creation  30 Apr 03
 * @version   $Revision: 3$ $Date: 3/28/05 9:22:58 AM EST$
 * @since     Baja 1.0
 */
public interface BIJobService
  extends BInterface  
{ 
  /**
   * Get all the child jobs under this service.
   */
  public BJob[] getJobs();

  /**
   * Submit a job and run it!
   */
  public BOrd submit(BJob job, Context cx);
  
  /**
   * Type.
   */  
  public static final Type TYPE = Sys.loadType(BIJobService.class);
}
