/*
 * Copyright 2006 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.file;

import com.tridium.sys.module.NModule;

import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

/**
 * BITemplate is implemented by template files.
 *
 * @author Robert Adams
 * @version $Revision: 4$ $Date: 6/11/07 12:41:23 PM EDT$
 * @creation 23 Jan 2014
 * @since Niagara 3.2
 */
public interface BITemplate
        extends BInterface {

    public static final Type TYPE = Sys.loadType(BITemplate.class);

    /**
     * Get the vendor name for this BITemplate
     *
     * @return vendor name
     */
    public String getVendor();

    /**
     * Get the version name for this BITemplate
     *
     * @return version
     */
    public String getVersion();

    /**
     * Get the description string this BITemplate
     *
     * @return version
     */
    public String getDescription();

    /**
     * Get the uID string this BITemplate
     *
     * @return uID
     */
    public BUuid getUID();

    /**
     * Get BObject tree encapsulate in this template file;
     *
     * @return the root BComponent
     * @throws UnresolvedException
     */
    public BComponent getBaseComponent() throws UnresolvedException;

}
