/*
 * Copyright 2006 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.file;

import javax.baja.sys.*;
import javax.baja.space.*;

/**
 * BIComponentFile should be implemented by file type objects that
 * may be move/copied to a BComponent space but first require conversion
 * to a BComponent.
 *
 * @author    Robert Adams
 * @creation  12 Dec 06
 * @version   $Revision: 4$ $Date: 6/11/07 12:41:23 PM EDT$
 * @since     Niagara 3.2
 */
public interface BIComponentFile
  extends BIFile
{

  public static final Type TYPE = Sys.loadType(BIComponentFile.class);

  public Mark readComponents() throws Exception;

}
