/*
 * Copyright 2008, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.category;

import javax.baja.sys.*;

/**
 * BCategoryMode defines how a category is mapped into permissions
 * for an object.  Union indicates that permissions for the category
 * are added to the to the user's permissions for the object.
 * Intersection indicates that missing permissions for the category
 * are removed from the user's permissions for the object.
 * 
 * @author    John Sublett
 * @creation  11 Mar 2008
 * @version   $Revision: 1$ $Date: 3/12/08 5:40:56 PM EDT$
 * @since     Baja 1.0
 */
public final class BCategoryMode
  extends BFrozenEnum
{
  /*-
  
  enum BCategoryMode
  {
    range
    {
      union,
      intersection
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.category.BCategoryMode(934072582)1.0$ @*/
/* Generated Sat Dec 17 22:42:35 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for union. */
  public static final int UNION = 0;
  /** Ordinal value for intersection. */
  public static final int INTERSECTION = 1;
  
  /** BCategoryMode constant for union. */
  public static final BCategoryMode union = new BCategoryMode(UNION);
  /** BCategoryMode constant for intersection. */
  public static final BCategoryMode intersection = new BCategoryMode(INTERSECTION);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BCategoryMode.class);
  
  /** Factory method with ordinal. */
  public static BCategoryMode make(int ordinal)
  {
    return (BCategoryMode)union.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BCategoryMode make(String tag)
  {
    return (BCategoryMode)union.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BCategoryMode(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BCategoryMode DEFAULT = union;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}