/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.agent;

import javax.baja.sys.*;
import javax.baja.naming.*;
import javax.baja.security.*;
import javax.baja.util.*;

/**
 * BPxView is a BAbstractPxView which stores 
 * the view contents in an XML file with a px extension.  The 
 * view itself is defined as a tree of bajaui:Widgets.
 *
 * @author    Brian Frank
 * @creation  8 May 04
 * @version   $Revision: 9$ $Date: 6/11/07 12:41:23 PM EDT$
 * @since     Baja 1.0
 */
public class BPxView
  extends BAbstractPxView
{
  /*-
  
  class BPxView
  {
    properties
    {
      pxFile: BOrd
        -- Defaults the px file which contains the view
        default {[ BOrd.NULL ]}
        slotfacets {[ BFacets.make(BFacets.TARGET_TYPE, "file:PxFile") ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.agent.BPxView(3842259894)1.0$ @*/
/* Generated Sat Dec 17 22:42:34 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "pxFile"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code pxFile} property.
   * Defaults the px file which contains the view
   * @see javax.baja.agent.BPxView#getPxFile
   * @see javax.baja.agent.BPxView#setPxFile
   */
  public static final Property pxFile = newProperty(0, BOrd.NULL,BFacets.make(BFacets.TARGET_TYPE, "file:PxFile"));
  
  /**
   * Get the {@code pxFile} property.
   * Defaults the px file which contains the view
   * @see javax.baja.agent.BPxView#pxFile
   */
  public BOrd getPxFile() { return (BOrd)get(pxFile); }
  
  /**
   * Set the {@code pxFile} property.
   * Defaults the px file which contains the view
   * @see javax.baja.agent.BPxView#pxFile
   */
  public void setPxFile(BOrd v) { set(pxFile,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BPxView.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  /**
   * Constructor with all fields.
   */
  public BPxView(BIcon icon, BOrd ord, BPermissions permissions, BTypeSpec media)
  {                
    super(icon, permissions, media);
    setPxFile(ord);
  }

  /**
   * Constructor with PxFile ord.
   */
  public BPxView(BOrd ord)
  {                      
    setPxFile(ord);
  }
  
  /**
   * No argument constructor.
   */
  public BPxView()
  {
  }
}

