/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.point;

import javax.baja.sys.*;
import javax.baja.units.*;

import javax.baja.driver.point.*;
import javax.baja.driver.util.*;

import javax.baja.bacnet.*;
import javax.baja.sys.BFacets;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBacnetTuningPolicy.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 08 Jul 2004
 * @since Niagara 3 Bacnet 1.0
 */
public class BBacnetTuningPolicy
  extends BTuningPolicy
{
  /*-
  class BBacnetTuningPolicy
  {
    properties
    {
      pollFrequency: BPollFrequency
        default {[ BPollFrequency.normal ]}
      useCov: boolean
        -- flag indicating if Niagara will use COV notification services to
        -- receive data about points in this device for which COV is supported.
        default {[ false ]}
      useConfirmedCov: boolean
        -- flag indicating if Niagara will request confirmed (true)
        -- or unconfirmed (false) COV notifications.
        default {[ true ]}
      covSubscriptionLifetime: int
        -- the lifetime, in minutes, for which Niagara will subscribe for COV
        -- notifications.  A value of zero means an indefinite lifetime,
        -- although this is not guaranteed to persist across resets of the
        -- server device.
        default {[ 15 ]}
        slotfacets {[ BFacets.makeInt(UnitDatabase.getUnit("minute")) ]}
      useCovProperty: boolean
        -- flag indicating if Niagara will use COV Property notification services to
        -- receive data about points in this device for which COV Property is supported.
        default {[ false ]}
      useConfirmedCovProperty: boolean
        -- flag indicating if Niagara will request confirmed (true)
        -- or unconfirmed (false) COV notifications on COV Property request.
        default {[ true ]}
      covPropertyIncrement: double
        -- COV notifications to send Cov Increment
        -- this property is be applicable for a COV Property of type numeric
        default {[ 1.0 ]}
      covPropertySubscriptionLifetime: int
        -- the lifetime, in minutes, for which Niagara will subscribe COV Property for COV
        -- notifications.  A value of zero means an indefinite lifetime,
        -- although this is not guaranteed to persist across resets of the
        -- server device.
        default {[ 15 ]}
        slotfacets {[ BFacets.makeInt(UnitDatabase.getUnit("minute")) ]}
      acceptUnsolicitedCov: boolean
        -- if true, will allow cov notifications for a polled point to update the point
        default {[ false ]}
    }
  }
  -*/


//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.point.BBacnetTuningPolicy(4233597201)1.0$ @*/
/* Generated Fri Nov 13 11:38:09 EST 2020 by Slot-o-Matic (c) Tridium, Inc. 2012-2020 */

////////////////////////////////////////////////////////////////
// Property "pollFrequency"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code pollFrequency} property.
   * @see #getPollFrequency
   * @see #setPollFrequency
   */
  public static final Property pollFrequency = newProperty(0, BPollFrequency.normal, null);
  
  /**
   * Get the {@code pollFrequency} property.
   * @see #pollFrequency
   */
  public BPollFrequency getPollFrequency() { return (BPollFrequency)get(pollFrequency); }
  
  /**
   * Set the {@code pollFrequency} property.
   * @see #pollFrequency
   */
  public void setPollFrequency(BPollFrequency v) { set(pollFrequency, v, null); }

////////////////////////////////////////////////////////////////
// Property "useCov"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code useCov} property.
   * flag indicating if Niagara will use COV notification services to
   * receive data about points in this device for which COV is supported.
   * @see #getUseCov
   * @see #setUseCov
   */
  public static final Property useCov = newProperty(0, false, null);
  
  /**
   * Get the {@code useCov} property.
   * flag indicating if Niagara will use COV notification services to
   * receive data about points in this device for which COV is supported.
   * @see #useCov
   */
  public boolean getUseCov() { return getBoolean(useCov); }
  
  /**
   * Set the {@code useCov} property.
   * flag indicating if Niagara will use COV notification services to
   * receive data about points in this device for which COV is supported.
   * @see #useCov
   */
  public void setUseCov(boolean v) { setBoolean(useCov, v, null); }

////////////////////////////////////////////////////////////////
// Property "useConfirmedCov"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code useConfirmedCov} property.
   * flag indicating if Niagara will request confirmed (true)
   * or unconfirmed (false) COV notifications.
   * @see #getUseConfirmedCov
   * @see #setUseConfirmedCov
   */
  public static final Property useConfirmedCov = newProperty(0, true, null);
  
  /**
   * Get the {@code useConfirmedCov} property.
   * flag indicating if Niagara will request confirmed (true)
   * or unconfirmed (false) COV notifications.
   * @see #useConfirmedCov
   */
  public boolean getUseConfirmedCov() { return getBoolean(useConfirmedCov); }
  
  /**
   * Set the {@code useConfirmedCov} property.
   * flag indicating if Niagara will request confirmed (true)
   * or unconfirmed (false) COV notifications.
   * @see #useConfirmedCov
   */
  public void setUseConfirmedCov(boolean v) { setBoolean(useConfirmedCov, v, null); }

////////////////////////////////////////////////////////////////
// Property "covSubscriptionLifetime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code covSubscriptionLifetime} property.
   * the lifetime, in minutes, for which Niagara will subscribe for COV
   * notifications.  A value of zero means an indefinite lifetime,
   * although this is not guaranteed to persist across resets of the
   * server device.
   * @see #getCovSubscriptionLifetime
   * @see #setCovSubscriptionLifetime
   */
  public static final Property covSubscriptionLifetime = newProperty(0, 15, BFacets.makeInt(UnitDatabase.getUnit("minute")));
  
  /**
   * Get the {@code covSubscriptionLifetime} property.
   * the lifetime, in minutes, for which Niagara will subscribe for COV
   * notifications.  A value of zero means an indefinite lifetime,
   * although this is not guaranteed to persist across resets of the
   * server device.
   * @see #covSubscriptionLifetime
   */
  public int getCovSubscriptionLifetime() { return getInt(covSubscriptionLifetime); }
  
  /**
   * Set the {@code covSubscriptionLifetime} property.
   * the lifetime, in minutes, for which Niagara will subscribe for COV
   * notifications.  A value of zero means an indefinite lifetime,
   * although this is not guaranteed to persist across resets of the
   * server device.
   * @see #covSubscriptionLifetime
   */
  public void setCovSubscriptionLifetime(int v) { setInt(covSubscriptionLifetime, v, null); }

////////////////////////////////////////////////////////////////
// Property "useCovProperty"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code useCovProperty} property.
   * flag indicating if Niagara will use COV Property notification services to
   * receive data about points in this device for which COV Property is supported.
   * @see #getUseCovProperty
   * @see #setUseCovProperty
   */
  public static final Property useCovProperty = newProperty(0, false, null);
  
  /**
   * Get the {@code useCovProperty} property.
   * flag indicating if Niagara will use COV Property notification services to
   * receive data about points in this device for which COV Property is supported.
   * @see #useCovProperty
   */
  public boolean getUseCovProperty() { return getBoolean(useCovProperty); }
  
  /**
   * Set the {@code useCovProperty} property.
   * flag indicating if Niagara will use COV Property notification services to
   * receive data about points in this device for which COV Property is supported.
   * @see #useCovProperty
   */
  public void setUseCovProperty(boolean v) { setBoolean(useCovProperty, v, null); }

////////////////////////////////////////////////////////////////
// Property "useConfirmedCovProperty"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code useConfirmedCovProperty} property.
   * flag indicating if Niagara will request confirmed (true)
   * or unconfirmed (false) COV notifications on COV Property request.
   * @see #getUseConfirmedCovProperty
   * @see #setUseConfirmedCovProperty
   */
  public static final Property useConfirmedCovProperty = newProperty(0, true, null);
  
  /**
   * Get the {@code useConfirmedCovProperty} property.
   * flag indicating if Niagara will request confirmed (true)
   * or unconfirmed (false) COV notifications on COV Property request.
   * @see #useConfirmedCovProperty
   */
  public boolean getUseConfirmedCovProperty() { return getBoolean(useConfirmedCovProperty); }
  
  /**
   * Set the {@code useConfirmedCovProperty} property.
   * flag indicating if Niagara will request confirmed (true)
   * or unconfirmed (false) COV notifications on COV Property request.
   * @see #useConfirmedCovProperty
   */
  public void setUseConfirmedCovProperty(boolean v) { setBoolean(useConfirmedCovProperty, v, null); }

////////////////////////////////////////////////////////////////
// Property "covPropertyIncrement"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code covPropertyIncrement} property.
   * COV notifications to send Cov Increment
   * this property is be applicable for a COV Property of type numeric
   * @see #getCovPropertyIncrement
   * @see #setCovPropertyIncrement
   */
  public static final Property covPropertyIncrement = newProperty(0, 1.0, null);
  
  /**
   * Get the {@code covPropertyIncrement} property.
   * COV notifications to send Cov Increment
   * this property is be applicable for a COV Property of type numeric
   * @see #covPropertyIncrement
   */
  public double getCovPropertyIncrement() { return getDouble(covPropertyIncrement); }
  
  /**
   * Set the {@code covPropertyIncrement} property.
   * COV notifications to send Cov Increment
   * this property is be applicable for a COV Property of type numeric
   * @see #covPropertyIncrement
   */
  public void setCovPropertyIncrement(double v) { setDouble(covPropertyIncrement, v, null); }

////////////////////////////////////////////////////////////////
// Property "covPropertySubscriptionLifetime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code covPropertySubscriptionLifetime} property.
   * the lifetime, in minutes, for which Niagara will subscribe COV Property for COV
   * notifications.  A value of zero means an indefinite lifetime,
   * although this is not guaranteed to persist across resets of the
   * server device.
   * @see #getCovPropertySubscriptionLifetime
   * @see #setCovPropertySubscriptionLifetime
   */
  public static final Property covPropertySubscriptionLifetime = newProperty(0, 15, BFacets.makeInt(UnitDatabase.getUnit("minute")));
  
  /**
   * Get the {@code covPropertySubscriptionLifetime} property.
   * the lifetime, in minutes, for which Niagara will subscribe COV Property for COV
   * notifications.  A value of zero means an indefinite lifetime,
   * although this is not guaranteed to persist across resets of the
   * server device.
   * @see #covPropertySubscriptionLifetime
   */
  public int getCovPropertySubscriptionLifetime() { return getInt(covPropertySubscriptionLifetime); }
  
  /**
   * Set the {@code covPropertySubscriptionLifetime} property.
   * the lifetime, in minutes, for which Niagara will subscribe COV Property for COV
   * notifications.  A value of zero means an indefinite lifetime,
   * although this is not guaranteed to persist across resets of the
   * server device.
   * @see #covPropertySubscriptionLifetime
   */
  public void setCovPropertySubscriptionLifetime(int v) { setInt(covPropertySubscriptionLifetime, v, null); }

////////////////////////////////////////////////////////////////
// Property "acceptUnsolicitedCov"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code acceptUnsolicitedCov} property.
   * if true, will allow cov notifications for a polled point to update the point
   * @see #getAcceptUnsolicitedCov
   * @see #setAcceptUnsolicitedCov
   */
  public static final Property acceptUnsolicitedCov = newProperty(0, false, null);
  
  /**
   * Get the {@code acceptUnsolicitedCov} property.
   * if true, will allow cov notifications for a polled point to update the point
   * @see #acceptUnsolicitedCov
   */
  public boolean getAcceptUnsolicitedCov() { return getBoolean(acceptUnsolicitedCov); }
  
  /**
   * Set the {@code acceptUnsolicitedCov} property.
   * if true, will allow cov notifications for a polled point to update the point
   * @see #acceptUnsolicitedCov
   */
  public void setAcceptUnsolicitedCov(boolean v) { setBoolean(acceptUnsolicitedCov, v, null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBacnetTuningPolicy.class);

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  /**
   * Default constructor.
   */
  public BBacnetTuningPolicy()
  {
  }


////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////

  /**
   * Can only go in a BacnetTuningPolicyMap.
   */
  public boolean isParentLegal(BComponent parent)
  {
    return parent instanceof BBacnetTuningPolicyMap;
  }

  public void changed(Property p, Context cx)
  {
    super.changed(p, cx);
    if (!isRunning()) return;
    if (p.equals(useCov) || p.equals(useCovProperty))
    {
      ((BBacnetNetwork)((BBacnetTuningPolicyMap)getParent()).getNetwork())
        .tuningChanged(this, cx);
    }
  }
}