/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.export;

import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.bacnet.alarm.BBacnetStatusAlgorithm;
import javax.baja.control.BControlPoint;
import javax.baja.control.BPointExtension;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.point.BProxyExt;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridium.sys.schema.NProperty;

public class BOutOfServiceExt
  extends BPointExtension
{
  /*-
   class BOutOfServiceExt
   {
     properties
     {
       outOfService:boolean
         default {[ false ]}
       presentValue:BValue
         default {[ BBoolean.FALSE ]}
     }
     actions
     {
     }
     topics
     {
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.export.BOutOfServiceExt(2736910071)1.0$ @*/
/* Generated Tue Dec 13 09:57:00 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "outOfService"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>outOfService</code> property.
   *
   * @see javax.baja.bacnet.export.BOutOfServiceExt#getOutOfService
   * @see javax.baja.bacnet.export.BOutOfServiceExt#setOutOfService
   */
  public static final Property outOfService = newProperty(0, false, null);

  /**
   * Get the <code>outOfService</code> property.
   *
   * @see javax.baja.bacnet.export.BOutOfServiceExt#outOfService
   */
  public boolean getOutOfService()
  {
    return getBoolean(outOfService);
  }

  /**
   * Set the <code>outOfService</code> property.
   *
   * @see javax.baja.bacnet.export.BOutOfServiceExt#outOfService
   */
  public void setOutOfService(boolean v)
  {
    setBoolean(outOfService, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "presentValue"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>presentValue</code> property.
   *
   * @see javax.baja.bacnet.export.BOutOfServiceExt#getPresentValue
   * @see javax.baja.bacnet.export.BOutOfServiceExt#setPresentValue
   */
  public static final Property presentValue = newProperty(0, BBoolean.FALSE, null);

  /**
   * Get the <code>presentValue</code> property.
   *
   * @see javax.baja.bacnet.export.BOutOfServiceExt#presentValue
   */
  public BValue getPresentValue()
  {
    return get(presentValue);
  }

  /**
   * Set the <code>presentValue</code> property.
   *
   * @see javax.baja.bacnet.export.BOutOfServiceExt#presentValue
   */
  public void setPresentValue(BValue v)
  {
    set(presentValue, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BOutOfServiceExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  public BOutOfServiceExt()
  {
  }


////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////

  public void started()
    throws Exception
  {
    super.started();

    // Set bacnetValue with the right type and value.
    setPresentValue(getParentPoint().getOutStatusValue().getValueValue());
  }

  public void changed(Property p, Context cx)
  {
    super.changed(p, cx);
    if (!isRunning()) return;
    if (p.equals(outOfService))
    {
      BComponent c = (BComponent)export;
      setPresentValue(getParentPoint().getOutStatusValue().getValueValue());
      int flags = c.getFlags(c.getSlot("reliability"));
      if (getOutOfService())
        flags &= ~Flags.READONLY;
      else
        flags |= Flags.READONLY;
      c.setFlags(c.getSlot("reliability"), flags);
    }
    executePoint();
    if (export != null)
    {
      if (export instanceof BIBacnetCovSource)
        ((BIBacnetCovSource)export).checkCov();
    }
  }
////////////////////////////////////////////////////////////////
// BPointExtension
////////////////////////////////////////////////////////////////

  public void onExecute(BStatusValue working, Context cx)
  {
    // If the extension is "out of service", drive the working value
    // to the BACnet-written value.
    if (getOutOfService())
    {
      if (isCommandable)
      {
        BAbstractProxyExt apx = getParentPoint().getProxyExt();
        if (apx instanceof BProxyExt)
        {
          BProxyExt px = (BProxyExt)apx;
          px.writeReset();
        }
      }

      working.setValueValue(getPresentValue());
    }
  }


////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////

  public BIBacnetExportObject getExport()
  {
    return export;
  }

  public void setExport(BIBacnetExportObject exp)
  {
    export = exp;
  }

  public void setCommandable(boolean commandable)
  {
    isCommandable = commandable;
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  BIBacnetExportObject export;
  boolean isCommandable;
}
