/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;

import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.*;

import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;

/**
 * BBacnetAnalogValuePrioritizedDescriptor exposes a ControlPoint as a writable (non-commandable) Bacnet
 * Analog Value Object.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 19 Feb 02
 * @since Niagara 3 Bacnet 1.0
 */

public class BBacnetAnalogValuePrioritizedDescriptor
  extends BBacnetAnalogWritableDescriptor
{

////////////////////////////////////////////////////////////////
// Slot overrides
////////////////////////////////////////////////////////////////

  public static final Property objectId = newProperty(Flags.DEFAULT_ON_CLONE,
    BBacnetObjectIdentifier.make(BBacnetObjectType.ANALOG_VALUE));

  /*-
  class BBacnetAnalogValuePrioritizedDescriptor
  {
    properties
    {
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.export.BBacnetAnalogValuePrioritizedDescriptor(2189988612)1.0$ @*/
/* Generated Wed Oct 13 12:45:22 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetAnalogValuePrioritizedDescriptor.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Overrides
////////////////////////////////////////////////////////////////

  /**
   * The priority array and relinquish default properties
   * are optional for analog values.
   *
   * @return true if the priority array and relinquish default properties
   * should be setup as required properties
   */
  protected boolean commandabilityRequired()
  {
    return false;
  }


  /**
   * Get slot facets.
   *
   * @param slot
   * @returns the appropriate slot facets.
   */
  public final BFacets getSlotFacets(Slot s)
  {
    if (s == objectId)
      return BBacnetObjectType.getObjectIdFacets(BBacnetObjectType.ANALOG_VALUE);
    return super.getSlotFacets(s);
  }

    /**
     * Set the value of an optional property.
     * Subclasses with additional properties override this to check for
     * their properties.  If no match is found, call this superclass
     * method to check these properties.
     *
     * @param pId the requested property-identifier.
     * @param ndx the property array index (-1 if not specified).
     * @param val the Asn-encoded value for the property.
     * @param pri the priority level (only used for commandable properties).
     * @returns null if everything goes OK, or
     * an ErrorType describing the error if not.
     */
    protected ErrorType writeOptionalProperty(int pId,
                                              int ndx,
                                              byte[] val,
                                              int pri)
            throws BacnetException
    {
        switch (pId)
        {
            case BBacnetPropertyIdentifier.EVENT_ENABLE:
                BAlarmSourceExt almExt = getAlarmExt();
                if (almExt != null)
                {
                    almExt.set(BAlarmSourceExt.alarmEnable,
                            BacnetBitStringUtil.getBAlarmTransitionBits(AsnUtil.fromAsnBitString(val)),
                            BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
        }
        return super.writeOptionalProperty(pId, ndx, val, pri);
    }

}