/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.export;

import java.util.Vector;

import javax.baja.bacnet.datatypes.BBacnetDestination;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.*;

import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.alarm.ext.BAlarmSourceExt;

import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.*;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;

/**
 * BBacnetAnalogOutputDescriptor exposes a ControlPoint as a Bacnet
 * Analog Output Object.
 *
 * @author Craig Gemmill
 * @version $Revision: 1$ $Date: 11/6/01 1:59:13 PM$
 * @creation 07 Aug 01
 * @since Niagara 3 Bacnet 1.0
 */

public class BBacnetAnalogOutputDescriptor
  extends BBacnetAnalogWritableDescriptor
{

////////////////////////////////////////////////////////////////
// Slot overrides
////////////////////////////////////////////////////////////////

  public static final Property objectId = newProperty(Flags.DEFAULT_ON_CLONE,
    BBacnetObjectIdentifier.make(BBacnetObjectType.ANALOG_OUTPUT));

  /*-
  class BBacnetAnalogOutputDescriptor
  {
    properties
    {
      deviceType: String
        default {[ "" ]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.export.BBacnetAnalogOutputDescriptor(675546967)1.0$ @*/
/* Generated Mon Sep 06 13:07:35 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "deviceType"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>deviceType</code> property.
   *
   * @see javax.baja.bacnet.export.BBacnetAnalogOutputDescriptor#getDeviceType
   * @see javax.baja.bacnet.export.BBacnetAnalogOutputDescriptor#setDeviceType
   */
  public static final Property deviceType = newProperty(0, "", null);

  /**
   * Get the <code>deviceType</code> property.
   *
   * @see javax.baja.bacnet.export.BBacnetAnalogOutputDescriptor#deviceType
   */
  public String getDeviceType()
  {
    return getString(deviceType);
  }

  /**
   * Set the <code>deviceType</code> property.
   *
   * @see javax.baja.bacnet.export.BBacnetAnalogOutputDescriptor#deviceType
   */
  public void setDeviceType(String v)
  {
    setString(deviceType, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetAnalogOutputDescriptor.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Overrides
////////////////////////////////////////////////////////////////

  /**
   * Get slot facets.
   *
   * @param slot
   * @returns the appropriate slot facets.
   */
  public final BFacets getSlotFacets(Slot s)
  {
    if (s == objectId)
      return BBacnetObjectType.getObjectIdFacets(BBacnetObjectType.ANALOG_OUTPUT);
    return super.getSlotFacets(s);
  }

  /**
   * Subclass override method to add optional properties.
   * NOTE: You MUST call super.addOptionalProps(v) first!
   *
   * @param v Vector containing optional propertyIds.
   */
  @SuppressWarnings({"rawtypes", "unchecked"})
  protected void addOptionalProps(Vector v)
  {
    super.addOptionalProps(v);
    v.add(BBacnetPropertyIdentifier.deviceType);
  }

  /**
   * Read the value of an optional property.
   * Subclasses with additional properties override this to check for
   * their properties.  If no match is found, call this superclass
   * method to check these properties.
   *
   * @param pId the requested property-identifier.
   * @param ndx the property array index (-1 if not specified).
   * @returns a PropertyValue containing either the encoded value or the error.
   */
  protected PropertyValue readOptionalProperty(int pId, int ndx)
  {
    BNumericPoint pt = (BNumericPoint)getPoint();
    if (pt == null)
      return new NReadPropertyResult(pId, ndx, new NErrorType(BBacnetErrorClass.OBJECT,
        BBacnetErrorCode.TARGET_NOT_CONFIGURED));
    switch (pId)
    {
      case BBacnetPropertyIdentifier.DEVICE_TYPE:
        return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(getDeviceType()));
    }
    return super.readOptionalProperty(pId, ndx);
  }

  /**
   * Set the value of an optional property.
   * Subclasses with additional properties override this to check for
   * their properties.  If no match is found, call this superclass
   * method to check these properties.
   *
   * @param pId the requested property-identifier.
   * @param ndx the property array index (-1 if not specified).
   * @param val the Asn-encoded value for the property.
   * @param pri the priority level (only used for commandable properties).
   * @returns null if everything goes OK, or
   * an ErrorType describing the error if not.
   */
  protected ErrorType writeOptionalProperty(int pId,
                                            int ndx,
                                            byte[] val,
                                            int pri)
    throws BacnetException
  {
    switch (pId)
    {
      case BBacnetPropertyIdentifier.DEVICE_TYPE:
        return new NErrorType(BBacnetErrorClass.PROPERTY,
          BBacnetErrorCode.WRITE_ACCESS_DENIED);
    }
    return super.writeOptionalProperty(pId, ndx, val, pri);
  }

}