/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.sys.*;

/**
 * BBacnetSegmentation represents the Bacnet Segmentation
 * enumeration.
 *
 * @author Craig Gemmill
 * @version $Revision: 8$ $Date: 12/19/01 4:36:01 PM$
 * @creation 10 Aug 00
 * @since Niagara 3 Bacnet 1.0
 */
public final class BBacnetSegmentation
  extends BFrozenEnum
{
  /*-
  enum BBacnetSegmentation
  {
    range
    {
      segmentedBoth,
      segmentedTransmit,
      segmentedReceive,
      noSegmentation
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.enums.BBacnetSegmentation(690870276)1.0$ @*/
/* Generated Thu Apr 01 15:19:44 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

  /**
   * Ordinal value for segmentedBoth.
   */
  public static final int SEGMENTED_BOTH = 0;
  /**
   * Ordinal value for segmentedTransmit.
   */
  public static final int SEGMENTED_TRANSMIT = 1;
  /**
   * Ordinal value for segmentedReceive.
   */
  public static final int SEGMENTED_RECEIVE = 2;
  /**
   * Ordinal value for noSegmentation.
   */
  public static final int NO_SEGMENTATION = 3;

  /**
   * BBacnetSegmentation constant for segmentedBoth.
   */
  public static final BBacnetSegmentation segmentedBoth = new BBacnetSegmentation(SEGMENTED_BOTH);
  /**
   * BBacnetSegmentation constant for segmentedTransmit.
   */
  public static final BBacnetSegmentation segmentedTransmit = new BBacnetSegmentation(SEGMENTED_TRANSMIT);
  /**
   * BBacnetSegmentation constant for segmentedReceive.
   */
  public static final BBacnetSegmentation segmentedReceive = new BBacnetSegmentation(SEGMENTED_RECEIVE);
  /**
   * BBacnetSegmentation constant for noSegmentation.
   */
  public static final BBacnetSegmentation noSegmentation = new BBacnetSegmentation(NO_SEGMENTATION);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetSegmentation.class);

  /**
   * Factory method with ordinal.
   */
  public static BBacnetSegmentation make(int ordinal)
  {
    return (BBacnetSegmentation)segmentedBoth.getRange().get(ordinal);
  }

  /**
   * Factory method with tag.
   */
  public static BBacnetSegmentation make(String tag)
  {
    return (BBacnetSegmentation)segmentedBoth.getRange().get(tag);
  }

  /**
   * Private constructor.
   */
  private BBacnetSegmentation(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Utility
////////////////////////////////////////////////////////////////

  /**
   * Is segmented transmit supported?
   *
   * @returns true for segmentedBoth and segmentedTransmit.
   */
  public boolean isSegmentedTransmit()
  {
    return getOrdinal() < SEGMENTED_RECEIVE;
  }

  /**
   * Is segmented receive supported?
   *
   * @returns true for segmentedBoth and segmentedReceive.
   */
  public boolean isSegmentedReceive()
  {
    return (getOrdinal() & SEGMENTED_TRANSMIT) == 0;
  }


////////////////////////////////////////////////////////////////
// Static methods
////////////////////////////////////////////////////////////////

  /**
   * Create a string tag for the given ordinal.
   *
   * @return the tag for the ordinal, if it is known,
   * or construct one using standard prefixes.
   */
  public static String tag(int id)
  {
    return DEFAULT.getRange().getTag(id);
  }


////////////////////////////////////////////////////////////////
// Constants
////////////////////////////////////////////////////////////////

  public static final BBacnetSegmentation DEFAULT = noSegmentation;
}
