/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.sys.*;

import javax.baja.bacnet.BacnetConst;

/**
 * BBacnetPropertyIdentifier represents the BACnetPropertyIdentifier
 * enumeration.
 * <p>
 * BBacnetPropertyIdentifier is an "extensible" enumeration.
 * Values 0-511 are reserved for use by ASHRAE.
 * Values from 512-4194303 (0x3FFFFF)
 * can be used for proprietary extensions.
 * <p>
 * Note that for proprietary extensions, a given ordinal is not
 * globally mapped to the same enumeration.  Type X from vendor
 * A will be different than type X from vendor B.  Extensions are
 * also not guaranteed unique within a vendor's own products, so
 * type Y in device A from vendor A will in general be different
 * than type Y in device B from vendor A.
 *
 * @author Craig Gemmill
 * @version $Revision: 7$ $Date: 12/19/01 4:36:00 PM$
 * @creation 21 Jul 00
 * @since Niagara 3 Bacnet 1.0
 */

public final class BBacnetPropertyIdentifier
  extends BFrozenEnum
  implements BacnetConst
{
  /*-
  enum BBacnetPropertyIdentifier
  {
    range
    {
      ackedTransitions,
      ackRequired,
      action,
      actionText,
      activeText,
      activeVtSessions,
      alarmValue,
      alarmValues,
      all,
      allWritesSuccessful,
      apduSegmentTimeout,
      apduTimeout,
      applicationSoftwareVersion,
      archive,
      bias,
      changeOfStateCount,
      changeOfStateTime,
      notificationClass,
      removed1,
      controlledVariableReference,
      controlledVariableUnits,
      controlledVariableValue,
      covIncrement,
      dateList,
      daylightSavingsStatus,
      deadband,
      derivativeConstant,
      derivativeConstantUnits,
      description,
      descriptionOfHalt,
      deviceAddressBinding,
      deviceType,
      effectivePeriod,
      elapsedActiveTime,
      errorLimit,
      eventEnable,
      eventState,
      eventType,
      exceptionSchedule,
      faultValues,
      feedbackValue,
      fileAccessMethod,
      fileSize,
      fileType,
      firmwareRevision,
      highLimit,
      inactiveText,
      inProcess,
      instanceOf,
      integralConstant,
      integralConstantUnits,
      issueConfirmedNotifications,
      limitEnable,
      listOfGroupMembers,
      listOfObjectPropertyReferences,
      listOfSessionKeys,
      localDate,
      localTime,
      location,
      lowLimit,
      manipulatedVariableReference,
      maximumOutput,
      maxApduLengthAccepted,
      maxInfoFrames,
      maxMaster,
      maxPresValue,
      minimumOffTime,
      minimumOnTime,
      minimumOutput,
      minPresValue,
      modelName,
      modificationDate,
      notifyType,
      numberOfApduRetries,
      numberOfStates,
      objectIdentifier,
      objectList,
      objectName,
      objectPropertyReference,
      objectType,
      optional,
      outOfService,
      outputUnits,
      eventParameters,
      polarity,
      presentValue,
      priority,
      priorityArray,
      priorityForWriting,
      processIdentifier,
      programChange,
      programLocation,
      programState,
      proportionalConstant,
      proportionalConstantUnits,
      protocolConformanceClass,
      protocolObjectTypesSupported,
      protocolServicesSupported,
      protocolVersion,
      readOnly,
      reasonForHalt,
      recipient,
      recipientList,
      reliability,
      relinquishDefault,
      required,
      resolution,
      segmentationSupported,
      setpoint,
      setpointReference,
      stateText,
      statusFlags,
      systemStatus,
      timeDelay,
      timeOfActiveTimeReset,
      timeOfStateCountReset,
      timeSynchronizationRecipients,
      units,
      updateInterval,
      utcOffset,
      vendorIdentifier,
      vendorName,
      vtClassesSupported,
      weeklySchedule,
      attemptedSamples,
      averageValue,
      bufferSize,
      clientCovIncrement,
      covResubscriptionInterval,
      currentNotifyTime,
      eventTimeStamps,
      logBuffer,
      logDeviceObjectProperty,
      enable,
      logInterval,
      maximumValue,
      minimumValue,
      notificationThreshold,
      previousNotifyTime,
      protocolRevision,
      recordsSinceNotification,
      recordCount,
      startTime,
      stopTime,
      stopWhenFull,
      totalRecordCount,
      validSamples,
      windowInterval,
      windowSamples,
      maximumValueTimestamp,
      minimumValueTimestamp,
      varianceValue,
      activeCovSubscriptions,
      backupFailureTimeout,
      configurationFiles,
      databaseRevision,
      directReading,
      lastRestoreTime,
      maintenanceRequired,
      memberOf,
      mode,
      operationExpected,
      setting,
      silenced,
      trackingValue,
      zoneMembers,
      lifeSafetyAlarmValues,
      maxSegmentsAccepted,
      profileName,
      autoSlaveDiscovery,
      manualSlaveAddressBinding,
      slaveAddressBinding,
      slaveProxyEnable,
      lastNotifyRecord,
      scheduleDefault,
      acceptedModes,
      adjustValue,
      count,
      countBeforeChange,
      countChangeTime,
      covPeriod,
      inputReference,
      limitMonitoringInterval,
      loggingObject,
      loggingRecord,
      prescale,
      pulseRate,
      scale,
      scaleFactor,
      updateTime,
      valueBeforeChange,
      valueSet,
      valueChangeTime,
      alignIntervals,
      intervalOffset=195,
      lastRestartReason=196,
      loggingType=197,
      restartNotificationRecipients=202,
      timeOfDeviceRestart=203,
      timeSynchronizationInterval=204,
      trigger=205,
      utcTimeSynchronizationRecipients=206,
      nodeSubtype=207,
      nodeType=208,
      structuredObjectList=209,
      subordinateAnnotations=210,
      subordinateList=211,
      actualShedLevel=212,
      dutyWindow=213,
      expectedShedLevel=214,
      fullDutyBaseline=215,
      requestedShedLevel=218,
      shedDuration=219,
      shedLevelDescriptions=220,
      shedLevels=221,
      stateDescription=222,
      doorAlarmState=226,
      doorExtendedPulseTime=227,
      doorMembers=228,
      doorOpenTooLongTime=229,
      doorPulseTime=230,
      doorStatus=231,
      doorUnlockDelayTime=232,
      lockStatus=233,
      maskedAlarmValues=234,
      securedStatus=235,
      absenteeLimit=244,
      accessAlarmEvents=245,
      accessDoors=246,
      accessEvent=247,
      accessEventAuthenticationFactor=248,
      accessEventCredential=249,
      accessEventTime=250,
      accessTransactionEvents=251,
      accompaniment=252,
      accompanimentTime=253,
      activationTime=254,
      activeAuthenticationPolicy=255,
      assignedAccessRights=256,
      authenticationFactors=257,
      authenticationPolicyList=258,
      authenticationPolicyNames=259,
      authenticationStatus=260,
      authorizationMode=261,
      belongsTo=262,
      credentialDisable=263,
      credentialStatus=264,
      credentials=265,
      credentialsInZone=266,
      daysRemaining=267,
      entryPoints=268,
      exitPoints=269,
      expiryTime=270,
      extendedTimeEnable=271,
      failedAttemptEvents=272,
      failedAttempts=273,
      failedAttemptsTime=274,
      lastAccessEvent=275,
      lastAccessPoint=276,
      lastCredentialAdded=277,
      lastCredentialAddedTime=278,
      lastCredentialRemoved=279,
      lastCredentialRemovedTime=280,
      lastUseTime=281,
      lockout=282,
      lockoutRelinquishTime=283,
      masterExemption=284,
      maxFailedAttempts=285,
      members=286,
      musterPoint=287,
      negativeAccessRules=288,
      numberOfAuthenticationPolicies=289,
      occupancyCount=290,
      occupancyCountAdjust=291, 
      occupancyCountEnable=292,
      occupancyExemption=293,
      occupancyLowerLimit=294,
      occupancyLowerLimitEnforced=295,
      occupancyState=296,
      occupancyUpperLimit=297,
      occupancyUpperLimitEnforced=298,
      passbackExemption=299,
      passbackMode=300,
      passbackTimeout=301,
      positiveAccessRules=302,
      reasonForDisable=303,
      supportedFormats=304,
      supportedFormatClasses=305,
      threatAuthority=306,
      threatLevel=307,
      traceFlag=308,
      transactionNotificationClass=309,
      userExternalIdentifier=310,
      userInformationReference=311,
      userName=317,
      userType=318,
      usesRemaining=319,
      zoneFrom=320,
      zoneTo=321,
      accessEventTag=322,
      globalIdentifier=323,
      verificationTime=326,
      backupAndRestoreState=338,
      backupPreparationTime=339,
      restoreCompletionTime=340,
      restorePreparationTime=341,
      groupMembers=345,
      groupMemberNames=346,
      memberStatusDlags=347,
      requestedUpdateInterval=348,
      covuPeriod=349,
      covuRecipients=350,
      eventMessageTexts=351,
      eventMessageTextsConfig=352,
      eventDetectionEnable=353,
      eventAlgorithmInhibit=354,
      eventAlgorithmInhibitRef=355,
      timeDelayNormal=356,
      reliabilityEvaluationInhibit=357,
      faultParameters=358,
      faultType=359,
      localForwardingOnly=360,
      processIdentifierFilter=361,
      subscribedRecipients=362,
      authorizationExemptions=364,
      allowGroupDelayInhibit=365,
      channelNumber=366,
      controlGroups=367,
      executionDelay=368,
      lastPriority=369,
      writeStatus=370,
      propertyList=371,
      serialNumber=372,
      blinkWarnEnable=373,
      defaultFadetime=374,
      defaultRamprate=375,
      defaultStepIncrement=376,
      egressTimer=377,
      inProgress=378,
      instantaneousPower=379,
      lightingCommand=380,
      lightingCommandDefaultPriority=381,
      maxActualValue=382,
      minActualValue=383,
      power=384,
      transition=385, 
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.enums.BBacnetPropertyIdentifier(150125175)1.0$ @*/
/* Generated Wed May 13 20:08:38 EDT 2015 by Slot-o-Matic (c) Tridium, Inc. 2012 */

  /**
   * Ordinal value for ackedTransitions.
   */
  public static final int ACKED_TRANSITIONS = 0;
  /**
   * Ordinal value for ackRequired.
   */
  public static final int ACK_REQUIRED = 1;
  /**
   * Ordinal value for action.
   */
  public static final int ACTION = 2;
  /**
   * Ordinal value for actionText.
   */
  public static final int ACTION_TEXT = 3;
  /**
   * Ordinal value for activeText.
   */
  public static final int ACTIVE_TEXT = 4;
  /**
   * Ordinal value for activeVtSessions.
   */
  public static final int ACTIVE_VT_SESSIONS = 5;
  /**
   * Ordinal value for alarmValue.
   */
  public static final int ALARM_VALUE = 6;
  /**
   * Ordinal value for alarmValues.
   */
  public static final int ALARM_VALUES = 7;
  /**
   * Ordinal value for all.
   */
  public static final int ALL = 8;
  /**
   * Ordinal value for allWritesSuccessful.
   */
  public static final int ALL_WRITES_SUCCESSFUL = 9;
  /**
   * Ordinal value for apduSegmentTimeout.
   */
  public static final int APDU_SEGMENT_TIMEOUT = 10;
  /**
   * Ordinal value for apduTimeout.
   */
  public static final int APDU_TIMEOUT = 11;
  /**
   * Ordinal value for applicationSoftwareVersion.
   */
  public static final int APPLICATION_SOFTWARE_VERSION = 12;
  /**
   * Ordinal value for archive.
   */
  public static final int ARCHIVE = 13;
  /**
   * Ordinal value for bias.
   */
  public static final int BIAS = 14;
  /**
   * Ordinal value for changeOfStateCount.
   */
  public static final int CHANGE_OF_STATE_COUNT = 15;
  /**
   * Ordinal value for changeOfStateTime.
   */
  public static final int CHANGE_OF_STATE_TIME = 16;
  /**
   * Ordinal value for notificationClass.
   */
  public static final int NOTIFICATION_CLASS = 17;
  /**
   * Ordinal value for removed1.
   */
  public static final int REMOVED_1 = 18;
  /**
   * Ordinal value for controlledVariableReference.
   */
  public static final int CONTROLLED_VARIABLE_REFERENCE = 19;
  /**
   * Ordinal value for controlledVariableUnits.
   */
  public static final int CONTROLLED_VARIABLE_UNITS = 20;
  /**
   * Ordinal value for controlledVariableValue.
   */
  public static final int CONTROLLED_VARIABLE_VALUE = 21;
  /**
   * Ordinal value for covIncrement.
   */
  public static final int COV_INCREMENT = 22;
  /**
   * Ordinal value for dateList.
   */
  public static final int DATE_LIST = 23;
  /**
   * Ordinal value for daylightSavingsStatus.
   */
  public static final int DAYLIGHT_SAVINGS_STATUS = 24;
  /**
   * Ordinal value for deadband.
   */
  public static final int DEADBAND = 25;
  /**
   * Ordinal value for derivativeConstant.
   */
  public static final int DERIVATIVE_CONSTANT = 26;
  /**
   * Ordinal value for derivativeConstantUnits.
   */
  public static final int DERIVATIVE_CONSTANT_UNITS = 27;
  /**
   * Ordinal value for description.
   */
  public static final int DESCRIPTION = 28;
  /**
   * Ordinal value for descriptionOfHalt.
   */
  public static final int DESCRIPTION_OF_HALT = 29;
  /**
   * Ordinal value for deviceAddressBinding.
   */
  public static final int DEVICE_ADDRESS_BINDING = 30;
  /**
   * Ordinal value for deviceType.
   */
  public static final int DEVICE_TYPE = 31;
  /**
   * Ordinal value for effectivePeriod.
   */
  public static final int EFFECTIVE_PERIOD = 32;
  /**
   * Ordinal value for elapsedActiveTime.
   */
  public static final int ELAPSED_ACTIVE_TIME = 33;
  /**
   * Ordinal value for errorLimit.
   */
  public static final int ERROR_LIMIT = 34;
  /**
   * Ordinal value for eventEnable.
   */
  public static final int EVENT_ENABLE = 35;
  /**
   * Ordinal value for eventState.
   */
  public static final int EVENT_STATE = 36;
  /**
   * Ordinal value for eventType.
   */
  public static final int EVENT_TYPE = 37;
  /**
   * Ordinal value for exceptionSchedule.
   */
  public static final int EXCEPTION_SCHEDULE = 38;
  /**
   * Ordinal value for faultValues.
   */
  public static final int FAULT_VALUES = 39;
  /**
   * Ordinal value for feedbackValue.
   */
  public static final int FEEDBACK_VALUE = 40;
  /**
   * Ordinal value for fileAccessMethod.
   */
  public static final int FILE_ACCESS_METHOD = 41;
  /**
   * Ordinal value for fileSize.
   */
  public static final int FILE_SIZE = 42;
  /**
   * Ordinal value for fileType.
   */
  public static final int FILE_TYPE = 43;
  /**
   * Ordinal value for firmwareRevision.
   */
  public static final int FIRMWARE_REVISION = 44;
  /**
   * Ordinal value for highLimit.
   */
  public static final int HIGH_LIMIT = 45;
  /**
   * Ordinal value for inactiveText.
   */
  public static final int INACTIVE_TEXT = 46;
  /**
   * Ordinal value for inProcess.
   */
  public static final int IN_PROCESS = 47;
  /**
   * Ordinal value for instanceOf.
   */
  public static final int INSTANCE_OF = 48;
  /**
   * Ordinal value for integralConstant.
   */
  public static final int INTEGRAL_CONSTANT = 49;
  /**
   * Ordinal value for integralConstantUnits.
   */
  public static final int INTEGRAL_CONSTANT_UNITS = 50;
  /**
   * Ordinal value for issueConfirmedNotifications.
   */
  public static final int ISSUE_CONFIRMED_NOTIFICATIONS = 51;
  /**
   * Ordinal value for limitEnable.
   */
  public static final int LIMIT_ENABLE = 52;
  /**
   * Ordinal value for listOfGroupMembers.
   */
  public static final int LIST_OF_GROUP_MEMBERS = 53;
  /**
   * Ordinal value for listOfObjectPropertyReferences.
   */
  public static final int LIST_OF_OBJECT_PROPERTY_REFERENCES = 54;
  /**
   * Ordinal value for listOfSessionKeys.
   */
  public static final int LIST_OF_SESSION_KEYS = 55;
  /**
   * Ordinal value for localDate.
   */
  public static final int LOCAL_DATE = 56;
  /**
   * Ordinal value for localTime.
   */
  public static final int LOCAL_TIME = 57;
  /**
   * Ordinal value for location.
   */
  public static final int LOCATION = 58;
  /**
   * Ordinal value for lowLimit.
   */
  public static final int LOW_LIMIT = 59;
  /**
   * Ordinal value for manipulatedVariableReference.
   */
  public static final int MANIPULATED_VARIABLE_REFERENCE = 60;
  /**
   * Ordinal value for maximumOutput.
   */
  public static final int MAXIMUM_OUTPUT = 61;
  /**
   * Ordinal value for maxApduLengthAccepted.
   */
  public static final int MAX_APDU_LENGTH_ACCEPTED = 62;
  /**
   * Ordinal value for maxInfoFrames.
   */
  public static final int MAX_INFO_FRAMES = 63;
  /**
   * Ordinal value for maxMaster.
   */
  public static final int MAX_MASTER = 64;
  /**
   * Ordinal value for maxPresValue.
   */
  public static final int MAX_PRES_VALUE = 65;
  /**
   * Ordinal value for minimumOffTime.
   */
  public static final int MINIMUM_OFF_TIME = 66;
  /**
   * Ordinal value for minimumOnTime.
   */
  public static final int MINIMUM_ON_TIME = 67;
  /**
   * Ordinal value for minimumOutput.
   */
  public static final int MINIMUM_OUTPUT = 68;
  /**
   * Ordinal value for minPresValue.
   */
  public static final int MIN_PRES_VALUE = 69;
  /**
   * Ordinal value for modelName.
   */
  public static final int MODEL_NAME = 70;
  /**
   * Ordinal value for modificationDate.
   */
  public static final int MODIFICATION_DATE = 71;
  /**
   * Ordinal value for notifyType.
   */
  public static final int NOTIFY_TYPE = 72;
  /**
   * Ordinal value for numberOfApduRetries.
   */
  public static final int NUMBER_OF_APDU_RETRIES = 73;
  /**
   * Ordinal value for numberOfStates.
   */
  public static final int NUMBER_OF_STATES = 74;
  /**
   * Ordinal value for objectIdentifier.
   */
  public static final int OBJECT_IDENTIFIER = 75;
  /**
   * Ordinal value for objectList.
   */
  public static final int OBJECT_LIST = 76;
  /**
   * Ordinal value for objectName.
   */
  public static final int OBJECT_NAME = 77;
  /**
   * Ordinal value for objectPropertyReference.
   */
  public static final int OBJECT_PROPERTY_REFERENCE = 78;
  /**
   * Ordinal value for objectType.
   */
  public static final int OBJECT_TYPE = 79;
  /**
   * Ordinal value for optional.
   */
  public static final int OPTIONAL = 80;
  /**
   * Ordinal value for outOfService.
   */
  public static final int OUT_OF_SERVICE = 81;
  /**
   * Ordinal value for outputUnits.
   */
  public static final int OUTPUT_UNITS = 82;
  /**
   * Ordinal value for eventParameters.
   */
  public static final int EVENT_PARAMETERS = 83;
  /**
   * Ordinal value for polarity.
   */
  public static final int POLARITY = 84;
  /**
   * Ordinal value for presentValue.
   */
  public static final int PRESENT_VALUE = 85;
  /**
   * Ordinal value for priority.
   */
  public static final int PRIORITY = 86;
  /**
   * Ordinal value for priorityArray.
   */
  public static final int PRIORITY_ARRAY = 87;
  /**
   * Ordinal value for priorityForWriting.
   */
  public static final int PRIORITY_FOR_WRITING = 88;
  /**
   * Ordinal value for processIdentifier.
   */
  public static final int PROCESS_IDENTIFIER = 89;
  /**
   * Ordinal value for programChange.
   */
  public static final int PROGRAM_CHANGE = 90;
  /**
   * Ordinal value for programLocation.
   */
  public static final int PROGRAM_LOCATION = 91;
  /**
   * Ordinal value for programState.
   */
  public static final int PROGRAM_STATE = 92;
  /**
   * Ordinal value for proportionalConstant.
   */
  public static final int PROPORTIONAL_CONSTANT = 93;
  /**
   * Ordinal value for proportionalConstantUnits.
   */
  public static final int PROPORTIONAL_CONSTANT_UNITS = 94;
  /**
   * Ordinal value for protocolConformanceClass.
   */
  public static final int PROTOCOL_CONFORMANCE_CLASS = 95;
  /**
   * Ordinal value for protocolObjectTypesSupported.
   */
  public static final int PROTOCOL_OBJECT_TYPES_SUPPORTED = 96;
  /**
   * Ordinal value for protocolServicesSupported.
   */
  public static final int PROTOCOL_SERVICES_SUPPORTED = 97;
  /**
   * Ordinal value for protocolVersion.
   */
  public static final int PROTOCOL_VERSION = 98;
  /**
   * Ordinal value for readOnly.
   */
  public static final int READ_ONLY = 99;
  /**
   * Ordinal value for reasonForHalt.
   */
  public static final int REASON_FOR_HALT = 100;
  /**
   * Ordinal value for recipient.
   */
  public static final int RECIPIENT = 101;
  /**
   * Ordinal value for recipientList.
   */
  public static final int RECIPIENT_LIST = 102;
  /**
   * Ordinal value for reliability.
   */
  public static final int RELIABILITY = 103;
  /**
   * Ordinal value for relinquishDefault.
   */
  public static final int RELINQUISH_DEFAULT = 104;
  /**
   * Ordinal value for required.
   */
  public static final int REQUIRED = 105;
  /**
   * Ordinal value for resolution.
   */
  public static final int RESOLUTION = 106;
  /**
   * Ordinal value for segmentationSupported.
   */
  public static final int SEGMENTATION_SUPPORTED = 107;
  /**
   * Ordinal value for setpoint.
   */
  public static final int SETPOINT = 108;
  /**
   * Ordinal value for setpointReference.
   */
  public static final int SETPOINT_REFERENCE = 109;
  /**
   * Ordinal value for stateText.
   */
  public static final int STATE_TEXT = 110;
  /**
   * Ordinal value for statusFlags.
   */
  public static final int STATUS_FLAGS = 111;
  /**
   * Ordinal value for systemStatus.
   */
  public static final int SYSTEM_STATUS = 112;
  /**
   * Ordinal value for timeDelay.
   */
  public static final int TIME_DELAY = 113;
  /**
   * Ordinal value for timeOfActiveTimeReset.
   */
  public static final int TIME_OF_ACTIVE_TIME_RESET = 114;
  /**
   * Ordinal value for timeOfStateCountReset.
   */
  public static final int TIME_OF_STATE_COUNT_RESET = 115;
  /**
   * Ordinal value for timeSynchronizationRecipients.
   */
  public static final int TIME_SYNCHRONIZATION_RECIPIENTS = 116;
  /**
   * Ordinal value for units.
   */
  public static final int UNITS = 117;
  /**
   * Ordinal value for updateInterval.
   */
  public static final int UPDATE_INTERVAL = 118;
  /**
   * Ordinal value for utcOffset.
   */
  public static final int UTC_OFFSET = 119;
  /**
   * Ordinal value for vendorIdentifier.
   */
  public static final int VENDOR_IDENTIFIER = 120;
  /**
   * Ordinal value for vendorName.
   */
  public static final int VENDOR_NAME = 121;
  /**
   * Ordinal value for vtClassesSupported.
   */
  public static final int VT_CLASSES_SUPPORTED = 122;
  /**
   * Ordinal value for weeklySchedule.
   */
  public static final int WEEKLY_SCHEDULE = 123;
  /**
   * Ordinal value for attemptedSamples.
   */
  public static final int ATTEMPTED_SAMPLES = 124;
  /**
   * Ordinal value for averageValue.
   */
  public static final int AVERAGE_VALUE = 125;
  /**
   * Ordinal value for bufferSize.
   */
  public static final int BUFFER_SIZE = 126;
  /**
   * Ordinal value for clientCovIncrement.
   */
  public static final int CLIENT_COV_INCREMENT = 127;
  /**
   * Ordinal value for covResubscriptionInterval.
   */
  public static final int COV_RESUBSCRIPTION_INTERVAL = 128;
  /**
   * Ordinal value for currentNotifyTime.
   */
  public static final int CURRENT_NOTIFY_TIME = 129;
  /**
   * Ordinal value for eventTimeStamps.
   */
  public static final int EVENT_TIME_STAMPS = 130;
  /**
   * Ordinal value for logBuffer.
   */
  public static final int LOG_BUFFER = 131;
  /**
   * Ordinal value for logDeviceObjectProperty.
   */
  public static final int LOG_DEVICE_OBJECT_PROPERTY = 132;
  /**
   * Ordinal value for enable.
   */
  public static final int ENABLE = 133;
  /**
   * Ordinal value for logInterval.
   */
  public static final int LOG_INTERVAL = 134;
  /**
   * Ordinal value for maximumValue.
   */
  public static final int MAXIMUM_VALUE = 135;
  /**
   * Ordinal value for minimumValue.
   */
  public static final int MINIMUM_VALUE = 136;
  /**
   * Ordinal value for notificationThreshold.
   */
  public static final int NOTIFICATION_THRESHOLD = 137;
  /**
   * Ordinal value for previousNotifyTime.
   */
  public static final int PREVIOUS_NOTIFY_TIME = 138;
  /**
   * Ordinal value for protocolRevision.
   */
  public static final int PROTOCOL_REVISION = 139;
  /**
   * Ordinal value for recordsSinceNotification.
   */
  public static final int RECORDS_SINCE_NOTIFICATION = 140;
  /**
   * Ordinal value for recordCount.
   */
  public static final int RECORD_COUNT = 141;
  /**
   * Ordinal value for startTime.
   */
  public static final int START_TIME = 142;
  /**
   * Ordinal value for stopTime.
   */
  public static final int STOP_TIME = 143;
  /**
   * Ordinal value for stopWhenFull.
   */
  public static final int STOP_WHEN_FULL = 144;
  /**
   * Ordinal value for totalRecordCount.
   */
  public static final int TOTAL_RECORD_COUNT = 145;
  /**
   * Ordinal value for validSamples.
   */
  public static final int VALID_SAMPLES = 146;
  /**
   * Ordinal value for windowInterval.
   */
  public static final int WINDOW_INTERVAL = 147;
  /**
   * Ordinal value for windowSamples.
   */
  public static final int WINDOW_SAMPLES = 148;
  /**
   * Ordinal value for maximumValueTimestamp.
   */
  public static final int MAXIMUM_VALUE_TIMESTAMP = 149;
  /**
   * Ordinal value for minimumValueTimestamp.
   */
  public static final int MINIMUM_VALUE_TIMESTAMP = 150;
  /**
   * Ordinal value for varianceValue.
   */
  public static final int VARIANCE_VALUE = 151;
  /**
   * Ordinal value for activeCovSubscriptions.
   */
  public static final int ACTIVE_COV_SUBSCRIPTIONS = 152;
  /**
   * Ordinal value for backupFailureTimeout.
   */
  public static final int BACKUP_FAILURE_TIMEOUT = 153;
  /**
   * Ordinal value for configurationFiles.
   */
  public static final int CONFIGURATION_FILES = 154;
  /**
   * Ordinal value for databaseRevision.
   */
  public static final int DATABASE_REVISION = 155;
  /**
   * Ordinal value for directReading.
   */
  public static final int DIRECT_READING = 156;
  /**
   * Ordinal value for lastRestoreTime.
   */
  public static final int LAST_RESTORE_TIME = 157;
  /**
   * Ordinal value for maintenanceRequired.
   */
  public static final int MAINTENANCE_REQUIRED = 158;
  /**
   * Ordinal value for memberOf.
   */
  public static final int MEMBER_OF = 159;
  /**
   * Ordinal value for mode.
   */
  public static final int MODE = 160;
  /**
   * Ordinal value for operationExpected.
   */
  public static final int OPERATION_EXPECTED = 161;
  /**
   * Ordinal value for setting.
   */
  public static final int SETTING = 162;
  /**
   * Ordinal value for silenced.
   */
  public static final int SILENCED = 163;
  /**
   * Ordinal value for trackingValue.
   */
  public static final int TRACKING_VALUE = 164;
  /**
   * Ordinal value for zoneMembers.
   */
  public static final int ZONE_MEMBERS = 165;
  /**
   * Ordinal value for lifeSafetyAlarmValues.
   */
  public static final int LIFE_SAFETY_ALARM_VALUES = 166;
  /**
   * Ordinal value for maxSegmentsAccepted.
   */
  public static final int MAX_SEGMENTS_ACCEPTED = 167;
  /**
   * Ordinal value for profileName.
   */
  public static final int PROFILE_NAME = 168;
  /**
   * Ordinal value for autoSlaveDiscovery.
   */
  public static final int AUTO_SLAVE_DISCOVERY = 169;
  /**
   * Ordinal value for manualSlaveAddressBinding.
   */
  public static final int MANUAL_SLAVE_ADDRESS_BINDING = 170;
  /**
   * Ordinal value for slaveAddressBinding.
   */
  public static final int SLAVE_ADDRESS_BINDING = 171;
  /**
   * Ordinal value for slaveProxyEnable.
   */
  public static final int SLAVE_PROXY_ENABLE = 172;
  /**
   * Ordinal value for lastNotifyRecord.
   */
  public static final int LAST_NOTIFY_RECORD = 173;
  /**
   * Ordinal value for scheduleDefault.
   */
  public static final int SCHEDULE_DEFAULT = 174;
  /**
   * Ordinal value for acceptedModes.
   */
  public static final int ACCEPTED_MODES = 175;
  /**
   * Ordinal value for adjustValue.
   */
  public static final int ADJUST_VALUE = 176;
  /**
   * Ordinal value for count.
   */
  public static final int COUNT = 177;
  /**
   * Ordinal value for countBeforeChange.
   */
  public static final int COUNT_BEFORE_CHANGE = 178;
  /**
   * Ordinal value for countChangeTime.
   */
  public static final int COUNT_CHANGE_TIME = 179;
  /**
   * Ordinal value for covPeriod.
   */
  public static final int COV_PERIOD = 180;
  /**
   * Ordinal value for inputReference.
   */
  public static final int INPUT_REFERENCE = 181;
  /**
   * Ordinal value for limitMonitoringInterval.
   */
  public static final int LIMIT_MONITORING_INTERVAL = 182;
  /**
   * Ordinal value for loggingObject.
   */
  public static final int LOGGING_OBJECT = 183;
  /**
   * Ordinal value for loggingRecord.
   */
  public static final int LOGGING_RECORD = 184;
  /**
   * Ordinal value for prescale.
   */
  public static final int PRESCALE = 185;
  /**
   * Ordinal value for pulseRate.
   */
  public static final int PULSE_RATE = 186;
  /**
   * Ordinal value for scale.
   */
  public static final int SCALE = 187;
  /**
   * Ordinal value for scaleFactor.
   */
  public static final int SCALE_FACTOR = 188;
  /**
   * Ordinal value for updateTime.
   */
  public static final int UPDATE_TIME = 189;
  /**
   * Ordinal value for valueBeforeChange.
   */
  public static final int VALUE_BEFORE_CHANGE = 190;
  /**
   * Ordinal value for valueSet.
   */
  public static final int VALUE_SET = 191;
  /**
   * Ordinal value for valueChangeTime.
   */
  public static final int VALUE_CHANGE_TIME = 192;
  /**
   * Ordinal value for alignIntervals.
   */
  public static final int ALIGN_INTERVALS = 193;
  /**
   * Ordinal value for intervalOffset.
   */
  public static final int INTERVAL_OFFSET = 195;
  /**
   * Ordinal value for lastRestartReason.
   */
  public static final int LAST_RESTART_REASON = 196;
  /**
   * Ordinal value for loggingType.
   */
  public static final int LOGGING_TYPE = 197;
  /**
   * Ordinal value for restartNotificationRecipients.
   */
  public static final int RESTART_NOTIFICATION_RECIPIENTS = 202;
  /**
   * Ordinal value for timeOfDeviceRestart.
   */
  public static final int TIME_OF_DEVICE_RESTART = 203;
  /**
   * Ordinal value for timeSynchronizationInterval.
   */
  public static final int TIME_SYNCHRONIZATION_INTERVAL = 204;
  /**
   * Ordinal value for trigger.
   */
  public static final int TRIGGER = 205;
  /**
   * Ordinal value for utcTimeSynchronizationRecipients.
   */
  public static final int UTC_TIME_SYNCHRONIZATION_RECIPIENTS = 206;
  /**
   * Ordinal value for nodeSubtype.
   */
  public static final int NODE_SUBTYPE = 207;
  /**
   * Ordinal value for nodeType.
   */
  public static final int NODE_TYPE = 208;
  /**
   * Ordinal value for structuredObjectList.
   */
  public static final int STRUCTURED_OBJECT_LIST = 209;
  /**
   * Ordinal value for subordinateAnnotations.
   */
  public static final int SUBORDINATE_ANNOTATIONS = 210;
  /**
   * Ordinal value for subordinateList.
   */
  public static final int SUBORDINATE_LIST = 211;
  /**
   * Ordinal value for actualShedLevel.
   */
  public static final int ACTUAL_SHED_LEVEL = 212;
  /**
   * Ordinal value for dutyWindow.
   */
  public static final int DUTY_WINDOW = 213;
  /**
   * Ordinal value for expectedShedLevel.
   */
  public static final int EXPECTED_SHED_LEVEL = 214;
  /**
   * Ordinal value for fullDutyBaseline.
   */
  public static final int FULL_DUTY_BASELINE = 215;
  /**
   * Ordinal value for requestedShedLevel.
   */
  public static final int REQUESTED_SHED_LEVEL = 218;
  /**
   * Ordinal value for shedDuration.
   */
  public static final int SHED_DURATION = 219;
  /**
   * Ordinal value for shedLevelDescriptions.
   */
  public static final int SHED_LEVEL_DESCRIPTIONS = 220;
  /**
   * Ordinal value for shedLevels.
   */
  public static final int SHED_LEVELS = 221;
  /**
   * Ordinal value for stateDescription.
   */
  public static final int STATE_DESCRIPTION = 222;
  /**
   * Ordinal value for doorAlarmState.
   */
  public static final int DOOR_ALARM_STATE = 226;
  /**
   * Ordinal value for doorExtendedPulseTime.
   */
  public static final int DOOR_EXTENDED_PULSE_TIME = 227;
  /**
   * Ordinal value for doorMembers.
   */
  public static final int DOOR_MEMBERS = 228;
  /**
   * Ordinal value for doorOpenTooLongTime.
   */
  public static final int DOOR_OPEN_TOO_LONG_TIME = 229;
  /**
   * Ordinal value for doorPulseTime.
   */
  public static final int DOOR_PULSE_TIME = 230;
  /**
   * Ordinal value for doorStatus.
   */
  public static final int DOOR_STATUS = 231;
  /**
   * Ordinal value for doorUnlockDelayTime.
   */
  public static final int DOOR_UNLOCK_DELAY_TIME = 232;
  /**
   * Ordinal value for lockStatus.
   */
  public static final int LOCK_STATUS = 233;
  /**
   * Ordinal value for maskedAlarmValues.
   */
  public static final int MASKED_ALARM_VALUES = 234;
  /**
   * Ordinal value for securedStatus.
   */
  public static final int SECURED_STATUS = 235;
  /**
   * Ordinal value for absenteeLimit.
   */
  public static final int ABSENTEE_LIMIT = 244;
  /**
   * Ordinal value for accessAlarmEvents.
   */
  public static final int ACCESS_ALARM_EVENTS = 245;
  /**
   * Ordinal value for accessDoors.
   */
  public static final int ACCESS_DOORS = 246;
  /**
   * Ordinal value for accessEvent.
   */
  public static final int ACCESS_EVENT = 247;
  /**
   * Ordinal value for accessEventAuthenticationFactor.
   */
  public static final int ACCESS_EVENT_AUTHENTICATION_FACTOR = 248;
  /**
   * Ordinal value for accessEventCredential.
   */
  public static final int ACCESS_EVENT_CREDENTIAL = 249;
  /**
   * Ordinal value for accessEventTime.
   */
  public static final int ACCESS_EVENT_TIME = 250;
  /**
   * Ordinal value for accessTransactionEvents.
   */
  public static final int ACCESS_TRANSACTION_EVENTS = 251;
  /**
   * Ordinal value for accompaniment.
   */
  public static final int ACCOMPANIMENT = 252;
  /**
   * Ordinal value for accompanimentTime.
   */
  public static final int ACCOMPANIMENT_TIME = 253;
  /**
   * Ordinal value for activationTime.
   */
  public static final int ACTIVATION_TIME = 254;
  /**
   * Ordinal value for activeAuthenticationPolicy.
   */
  public static final int ACTIVE_AUTHENTICATION_POLICY = 255;
  /**
   * Ordinal value for assignedAccessRights.
   */
  public static final int ASSIGNED_ACCESS_RIGHTS = 256;
  /**
   * Ordinal value for authenticationFactors.
   */
  public static final int AUTHENTICATION_FACTORS = 257;
  /**
   * Ordinal value for authenticationPolicyList.
   */
  public static final int AUTHENTICATION_POLICY_LIST = 258;
  /**
   * Ordinal value for authenticationPolicyNames.
   */
  public static final int AUTHENTICATION_POLICY_NAMES = 259;
  /**
   * Ordinal value for authenticationStatus.
   */
  public static final int AUTHENTICATION_STATUS = 260;
  /**
   * Ordinal value for authorizationMode.
   */
  public static final int AUTHORIZATION_MODE = 261;
  /**
   * Ordinal value for belongsTo.
   */
  public static final int BELONGS_TO = 262;
  /**
   * Ordinal value for credentialDisable.
   */
  public static final int CREDENTIAL_DISABLE = 263;
  /**
   * Ordinal value for credentialStatus.
   */
  public static final int CREDENTIAL_STATUS = 264;
  /**
   * Ordinal value for credentials.
   */
  public static final int CREDENTIALS = 265;
  /**
   * Ordinal value for credentialsInZone.
   */
  public static final int CREDENTIALS_IN_ZONE = 266;
  /**
   * Ordinal value for daysRemaining.
   */
  public static final int DAYS_REMAINING = 267;
  /**
   * Ordinal value for entryPoints.
   */
  public static final int ENTRY_POINTS = 268;
  /**
   * Ordinal value for exitPoints.
   */
  public static final int EXIT_POINTS = 269;
  /**
   * Ordinal value for expiryTime.
   */
  public static final int EXPIRY_TIME = 270;
  /**
   * Ordinal value for extendedTimeEnable.
   */
  public static final int EXTENDED_TIME_ENABLE = 271;
  /**
   * Ordinal value for failedAttemptEvents.
   */
  public static final int FAILED_ATTEMPT_EVENTS = 272;
  /**
   * Ordinal value for failedAttempts.
   */
  public static final int FAILED_ATTEMPTS = 273;
  /**
   * Ordinal value for failedAttemptsTime.
   */
  public static final int FAILED_ATTEMPTS_TIME = 274;
  /**
   * Ordinal value for lastAccessEvent.
   */
  public static final int LAST_ACCESS_EVENT = 275;
  /**
   * Ordinal value for lastAccessPoint.
   */
  public static final int LAST_ACCESS_POINT = 276;
  /**
   * Ordinal value for lastCredentialAdded.
   */
  public static final int LAST_CREDENTIAL_ADDED = 277;
  /**
   * Ordinal value for lastCredentialAddedTime.
   */
  public static final int LAST_CREDENTIAL_ADDED_TIME = 278;
  /**
   * Ordinal value for lastCredentialRemoved.
   */
  public static final int LAST_CREDENTIAL_REMOVED = 279;
  /**
   * Ordinal value for lastCredentialRemovedTime.
   */
  public static final int LAST_CREDENTIAL_REMOVED_TIME = 280;
  /**
   * Ordinal value for lastUseTime.
   */
  public static final int LAST_USE_TIME = 281;
  /**
   * Ordinal value for lockout.
   */
  public static final int LOCKOUT = 282;
  /**
   * Ordinal value for lockoutRelinquishTime.
   */
  public static final int LOCKOUT_RELINQUISH_TIME = 283;
  /**
   * Ordinal value for masterExemption.
   */
  public static final int MASTER_EXEMPTION = 284;
  /**
   * Ordinal value for maxFailedAttempts.
   */
  public static final int MAX_FAILED_ATTEMPTS = 285;
  /**
   * Ordinal value for members.
   */
  public static final int MEMBERS = 286;
  /**
   * Ordinal value for musterPoint.
   */
  public static final int MUSTER_POINT = 287;
  /**
   * Ordinal value for negativeAccessRules.
   */
  public static final int NEGATIVE_ACCESS_RULES = 288;
  /**
   * Ordinal value for numberOfAuthenticationPolicies.
   */
  public static final int NUMBER_OF_AUTHENTICATION_POLICIES = 289;
  /**
   * Ordinal value for occupancyCount.
   */
  public static final int OCCUPANCY_COUNT = 290;
  /**
   * Ordinal value for occupancyCountAdjust.
   */
  public static final int OCCUPANCY_COUNT_ADJUST = 291;
  /**
   * Ordinal value for occupancyCountEnable.
   */
  public static final int OCCUPANCY_COUNT_ENABLE = 292;
  /**
   * Ordinal value for occupancyExemption.
   */
  public static final int OCCUPANCY_EXEMPTION = 293;
  /**
   * Ordinal value for occupancyLowerLimit.
   */
  public static final int OCCUPANCY_LOWER_LIMIT = 294;
  /**
   * Ordinal value for occupancyLowerLimitEnforced.
   */
  public static final int OCCUPANCY_LOWER_LIMIT_ENFORCED = 295;
  /**
   * Ordinal value for occupancyState.
   */
  public static final int OCCUPANCY_STATE = 296;
  /**
   * Ordinal value for occupancyUpperLimit.
   */
  public static final int OCCUPANCY_UPPER_LIMIT = 297;
  /**
   * Ordinal value for occupancyUpperLimitEnforced.
   */
  public static final int OCCUPANCY_UPPER_LIMIT_ENFORCED = 298;
  /**
   * Ordinal value for passbackExemption.
   */
  public static final int PASSBACK_EXEMPTION = 299;
  /**
   * Ordinal value for passbackMode.
   */
  public static final int PASSBACK_MODE = 300;
  /**
   * Ordinal value for passbackTimeout.
   */
  public static final int PASSBACK_TIMEOUT = 301;
  /**
   * Ordinal value for positiveAccessRules.
   */
  public static final int POSITIVE_ACCESS_RULES = 302;
  /**
   * Ordinal value for reasonForDisable.
   */
  public static final int REASON_FOR_DISABLE = 303;
  /**
   * Ordinal value for supportedFormats.
   */
  public static final int SUPPORTED_FORMATS = 304;
  /**
   * Ordinal value for supportedFormatClasses.
   */
  public static final int SUPPORTED_FORMAT_CLASSES = 305;
  /**
   * Ordinal value for threatAuthority.
   */
  public static final int THREAT_AUTHORITY = 306;
  /**
   * Ordinal value for threatLevel.
   */
  public static final int THREAT_LEVEL = 307;
  /**
   * Ordinal value for traceFlag.
   */
  public static final int TRACE_FLAG = 308;
  /**
   * Ordinal value for transactionNotificationClass.
   */
  public static final int TRANSACTION_NOTIFICATION_CLASS = 309;
  /**
   * Ordinal value for userExternalIdentifier.
   */
  public static final int USER_EXTERNAL_IDENTIFIER = 310;
  /**
   * Ordinal value for userInformationReference.
   */
  public static final int USER_INFORMATION_REFERENCE = 311;
  /**
   * Ordinal value for userName.
   */
  public static final int USER_NAME = 317;
  /**
   * Ordinal value for userType.
   */
  public static final int USER_TYPE = 318;
  /**
   * Ordinal value for usesRemaining.
   */
  public static final int USES_REMAINING = 319;
  /**
   * Ordinal value for zoneFrom.
   */
  public static final int ZONE_FROM = 320;
  /**
   * Ordinal value for zoneTo.
   */
  public static final int ZONE_TO = 321;
  /**
   * Ordinal value for accessEventTag.
   */
  public static final int ACCESS_EVENT_TAG = 322;
  /**
   * Ordinal value for globalIdentifier.
   */
  public static final int GLOBAL_IDENTIFIER = 323;
  /**
   * Ordinal value for verificationTime.
   */
  public static final int VERIFICATION_TIME = 326;
  /**
   * Ordinal value for backupAndRestoreState.
   */
  public static final int BACKUP_AND_RESTORE_STATE = 338;
  /**
   * Ordinal value for backupPreparationTime.
   */
  public static final int BACKUP_PREPARATION_TIME = 339;
  /**
   * Ordinal value for restoreCompletionTime.
   */
  public static final int RESTORE_COMPLETION_TIME = 340;
  /**
   * Ordinal value for restorePreparationTime.
   */
  public static final int RESTORE_PREPARATION_TIME = 341;

  public static final int BIT_MASK = 342;
  public static final int BIT_TEXT = 343;
  public static final int IS_UTC = 344;
   /* Ordinal value for groupMembers.
   */
  public static final int GROUP_MEMBERS = 345;
  /**
   * Ordinal value for groupMemberNames.
   */
  public static final int GROUP_MEMBER_NAMES = 346;
  /**
   * Ordinal value for memberStatusDlags.
   */
  public static final int MEMBER_STATUS_DLAGS = 347;
  /**
   * Ordinal value for requestedUpdateInterval.
   */
  public static final int REQUESTED_UPDATE_INTERVAL = 348;
  /**
   * Ordinal value for covuPeriod.
   */
  public static final int COVU_PERIOD = 349;
  /**
   * Ordinal value for covuRecipients.
   */
  public static final int COVU_RECIPIENTS = 350;
  /**
   * Ordinal value for eventMessageTexts.
   */
  public static final int EVENT_MESSAGE_TEXTS = 351;
  /**
   * Ordinal value for eventMessageTextsConfig.
   */
  public static final int EVENT_MESSAGE_TEXTS_CONFIG = 352;
  /**
   * Ordinal value for eventDetectionEnable.
   */
  public static final int EVENT_DETECTION_ENABLE = 353;
  /**
   * Ordinal value for eventAlgorithmInhibit.
   */
  public static final int EVENT_ALGORITHM_INHIBIT = 354;
  /**
   * Ordinal value for eventAlgorithmInhibitRef.
   */
  public static final int EVENT_ALGORITHM_INHIBIT_REF = 355;
  /**
   * Ordinal value for timeDelayNormal.
   */
  public static final int TIME_DELAY_NORMAL = 356;
  /**
   * Ordinal value for reliabilityEvaluationInhibit.
   */
  public static final int RELIABILITY_EVALUATION_INHIBIT = 357;
  /**
   * Ordinal value for faultParameters.
   */
  public static final int FAULT_PARAMETERS = 358;
  /**
   * Ordinal value for faultType.
   */
  public static final int FAULT_TYPE = 359;
  /**
   * Ordinal value for localForwardingOnly.
   */
  public static final int LOCAL_FORWARDING_ONLY = 360;
  /**
   * Ordinal value for processIdentifierFilter.
   */
  public static final int PROCESS_IDENTIFIER_FILTER = 361;
  /**
   * Ordinal value for subscribedRecipients.
   */
  public static final int SUBSCRIBED_RECIPIENTS = 362;
  /**
   * Ordinal value for authorizationExemptions.
   */
  public static final int AUTHORIZATION_EXEMPTIONS = 364;
  /**
   * Ordinal value for allowGroupDelayInhibit.
   */
  public static final int ALLOW_GROUP_DELAY_INHIBIT = 365;
  /**
   * Ordinal value for channelNumber.
   */
  public static final int CHANNEL_NUMBER = 366;
  /**
   * Ordinal value for controlGroups.
   */
  public static final int CONTROL_GROUPS = 367;
  /**
   * Ordinal value for executionDelay.
   */
  public static final int EXECUTION_DELAY = 368;
  /**
   * Ordinal value for lastPriority.
   */
  public static final int LAST_PRIORITY = 369;
  /**
   * Ordinal value for writeStatus.
   */
  public static final int WRITE_STATUS = 370;
  /**
   * Ordinal value for propertyList.
   */
  public static final int PROPERTY_LIST = 371;
  /**
   * Ordinal value for serialNumber.
   */
  public static final int SERIAL_NUMBER = 372;
  /**
   * Ordinal value for blinkWarnEnable.
   */
  public static final int BLINK_WARN_ENABLE = 373;
  /**
   * Ordinal value for defaultFadetime.
   */
  public static final int DEFAULT_FADETIME = 374;
  /**
   * Ordinal value for defaultRamprate.
   */
  public static final int DEFAULT_RAMPRATE = 375;
  /**
   * Ordinal value for defaultStepIncrement.
   */
  public static final int DEFAULT_STEP_INCREMENT = 376;
  /**
   * Ordinal value for egressTimer.
   */
  public static final int EGRESS_TIME = 377;
  /**
   * Ordinal value for inProgress.
   */
  public static final int IN_PROGRESS = 378;
  /**
   * Ordinal value for instantaneousPower.
   */
  public static final int INSTANTANEOUS_POWER = 379;
  /**
   * Ordinal value for lightingCommand.
   */
  public static final int LIGHTING_COMMAND = 380;
  /**
   * Ordinal value for lightingCommandDefaultPriority.
   */
  public static final int LIGHTING_COMMAND_DEFAULT_PRIORITY = 381;
  /**
   * Ordinal value for maxActualValue.
   */
  public static final int MAX_ACTUAL_VALUE = 382;
  /**
   * Ordinal value for minActualValue.
   */
  public static final int MIN_ACTUAL_VALUE = 383;
  /**
   * Ordinal value for power.
   */
  public static final int POWER = 384;
  /**
   * Ordinal value for transition.
   */
  public static final int TRANSITION = 385;

  public static final int EGRESS_ACTIVE = 386;
  /**
   * BBacnetPropertyIdentifier constant for ackedTransitions.
   */
  public static final BBacnetPropertyIdentifier ackedTransitions = new BBacnetPropertyIdentifier(ACKED_TRANSITIONS);
  /**
   * BBacnetPropertyIdentifier constant for ackRequired.
   */
  public static final BBacnetPropertyIdentifier ackRequired = new BBacnetPropertyIdentifier(ACK_REQUIRED);
  /**
   * BBacnetPropertyIdentifier constant for action.
   */
  public static final BBacnetPropertyIdentifier action = new BBacnetPropertyIdentifier(ACTION);
  /**
   * BBacnetPropertyIdentifier constant for actionText.
   */
  public static final BBacnetPropertyIdentifier actionText = new BBacnetPropertyIdentifier(ACTION_TEXT);
  /**
   * BBacnetPropertyIdentifier constant for activeText.
   */
  public static final BBacnetPropertyIdentifier activeText = new BBacnetPropertyIdentifier(ACTIVE_TEXT);
  /**
   * BBacnetPropertyIdentifier constant for activeVtSessions.
   */
  public static final BBacnetPropertyIdentifier activeVtSessions = new BBacnetPropertyIdentifier(ACTIVE_VT_SESSIONS);
  /**
   * BBacnetPropertyIdentifier constant for alarmValue.
   */
  public static final BBacnetPropertyIdentifier alarmValue = new BBacnetPropertyIdentifier(ALARM_VALUE);
  /**
   * BBacnetPropertyIdentifier constant for alarmValues.
   */
  public static final BBacnetPropertyIdentifier alarmValues = new BBacnetPropertyIdentifier(ALARM_VALUES);
  /**
   * BBacnetPropertyIdentifier constant for all.
   */
  public static final BBacnetPropertyIdentifier all = new BBacnetPropertyIdentifier(ALL);
  /**
   * BBacnetPropertyIdentifier constant for allWritesSuccessful.
   */
  public static final BBacnetPropertyIdentifier allWritesSuccessful = new BBacnetPropertyIdentifier(ALL_WRITES_SUCCESSFUL);
  /**
   * BBacnetPropertyIdentifier constant for apduSegmentTimeout.
   */
  public static final BBacnetPropertyIdentifier apduSegmentTimeout = new BBacnetPropertyIdentifier(APDU_SEGMENT_TIMEOUT);
  /**
   * BBacnetPropertyIdentifier constant for apduTimeout.
   */
  public static final BBacnetPropertyIdentifier apduTimeout = new BBacnetPropertyIdentifier(APDU_TIMEOUT);
  /**
   * BBacnetPropertyIdentifier constant for applicationSoftwareVersion.
   */
  public static final BBacnetPropertyIdentifier applicationSoftwareVersion = new BBacnetPropertyIdentifier(APPLICATION_SOFTWARE_VERSION);
  /**
   * BBacnetPropertyIdentifier constant for archive.
   */
  public static final BBacnetPropertyIdentifier archive = new BBacnetPropertyIdentifier(ARCHIVE);
  /**
   * BBacnetPropertyIdentifier constant for bias.
   */
  public static final BBacnetPropertyIdentifier bias = new BBacnetPropertyIdentifier(BIAS);
  /**
   * BBacnetPropertyIdentifier constant for changeOfStateCount.
   */
  public static final BBacnetPropertyIdentifier changeOfStateCount = new BBacnetPropertyIdentifier(CHANGE_OF_STATE_COUNT);
  /**
   * BBacnetPropertyIdentifier constant for changeOfStateTime.
   */
  public static final BBacnetPropertyIdentifier changeOfStateTime = new BBacnetPropertyIdentifier(CHANGE_OF_STATE_TIME);
  /**
   * BBacnetPropertyIdentifier constant for notificationClass.
   */
  public static final BBacnetPropertyIdentifier notificationClass = new BBacnetPropertyIdentifier(NOTIFICATION_CLASS);
  /**
   * BBacnetPropertyIdentifier constant for removed1.
   */
  public static final BBacnetPropertyIdentifier removed1 = new BBacnetPropertyIdentifier(REMOVED_1);
  /**
   * BBacnetPropertyIdentifier constant for controlledVariableReference.
   */
  public static final BBacnetPropertyIdentifier controlledVariableReference = new BBacnetPropertyIdentifier(CONTROLLED_VARIABLE_REFERENCE);
  /**
   * BBacnetPropertyIdentifier constant for controlledVariableUnits.
   */
  public static final BBacnetPropertyIdentifier controlledVariableUnits = new BBacnetPropertyIdentifier(CONTROLLED_VARIABLE_UNITS);
  /**
   * BBacnetPropertyIdentifier constant for controlledVariableValue.
   */
  public static final BBacnetPropertyIdentifier controlledVariableValue = new BBacnetPropertyIdentifier(CONTROLLED_VARIABLE_VALUE);
  /**
   * BBacnetPropertyIdentifier constant for covIncrement.
   */
  public static final BBacnetPropertyIdentifier covIncrement = new BBacnetPropertyIdentifier(COV_INCREMENT);
  /**
   * BBacnetPropertyIdentifier constant for dateList.
   */
  public static final BBacnetPropertyIdentifier dateList = new BBacnetPropertyIdentifier(DATE_LIST);
  /**
   * BBacnetPropertyIdentifier constant for daylightSavingsStatus.
   */
  public static final BBacnetPropertyIdentifier daylightSavingsStatus = new BBacnetPropertyIdentifier(DAYLIGHT_SAVINGS_STATUS);
  /**
   * BBacnetPropertyIdentifier constant for deadband.
   */
  public static final BBacnetPropertyIdentifier deadband = new BBacnetPropertyIdentifier(DEADBAND);
  /**
   * BBacnetPropertyIdentifier constant for derivativeConstant.
   */
  public static final BBacnetPropertyIdentifier derivativeConstant = new BBacnetPropertyIdentifier(DERIVATIVE_CONSTANT);
  /**
   * BBacnetPropertyIdentifier constant for derivativeConstantUnits.
   */
  public static final BBacnetPropertyIdentifier derivativeConstantUnits = new BBacnetPropertyIdentifier(DERIVATIVE_CONSTANT_UNITS);
  /**
   * BBacnetPropertyIdentifier constant for description.
   */
  public static final BBacnetPropertyIdentifier description = new BBacnetPropertyIdentifier(DESCRIPTION);
  /**
   * BBacnetPropertyIdentifier constant for descriptionOfHalt.
   */
  public static final BBacnetPropertyIdentifier descriptionOfHalt = new BBacnetPropertyIdentifier(DESCRIPTION_OF_HALT);
  /**
   * BBacnetPropertyIdentifier constant for deviceAddressBinding.
   */
  public static final BBacnetPropertyIdentifier deviceAddressBinding = new BBacnetPropertyIdentifier(DEVICE_ADDRESS_BINDING);
  /**
   * BBacnetPropertyIdentifier constant for deviceType.
   */
  public static final BBacnetPropertyIdentifier deviceType = new BBacnetPropertyIdentifier(DEVICE_TYPE);
  /**
   * BBacnetPropertyIdentifier constant for effectivePeriod.
   */
  public static final BBacnetPropertyIdentifier effectivePeriod = new BBacnetPropertyIdentifier(EFFECTIVE_PERIOD);
  /**
   * BBacnetPropertyIdentifier constant for elapsedActiveTime.
   */
  public static final BBacnetPropertyIdentifier elapsedActiveTime = new BBacnetPropertyIdentifier(ELAPSED_ACTIVE_TIME);
  /**
   * BBacnetPropertyIdentifier constant for errorLimit.
   */
  public static final BBacnetPropertyIdentifier errorLimit = new BBacnetPropertyIdentifier(ERROR_LIMIT);
  /**
   * BBacnetPropertyIdentifier constant for eventEnable.
   */
  public static final BBacnetPropertyIdentifier eventEnable = new BBacnetPropertyIdentifier(EVENT_ENABLE);
  /**
   * BBacnetPropertyIdentifier constant for eventState.
   */
  public static final BBacnetPropertyIdentifier eventState = new BBacnetPropertyIdentifier(EVENT_STATE);
  /**
   * BBacnetPropertyIdentifier constant for eventType.
   */
  public static final BBacnetPropertyIdentifier eventType = new BBacnetPropertyIdentifier(EVENT_TYPE);
  /**
   * BBacnetPropertyIdentifier constant for exceptionSchedule.
   */
  public static final BBacnetPropertyIdentifier exceptionSchedule = new BBacnetPropertyIdentifier(EXCEPTION_SCHEDULE);
  /**
   * BBacnetPropertyIdentifier constant for faultValues.
   */
  public static final BBacnetPropertyIdentifier faultValues = new BBacnetPropertyIdentifier(FAULT_VALUES);
  /**
   * BBacnetPropertyIdentifier constant for feedbackValue.
   */
  public static final BBacnetPropertyIdentifier feedbackValue = new BBacnetPropertyIdentifier(FEEDBACK_VALUE);
  /**
   * BBacnetPropertyIdentifier constant for fileAccessMethod.
   */
  public static final BBacnetPropertyIdentifier fileAccessMethod = new BBacnetPropertyIdentifier(FILE_ACCESS_METHOD);
  /**
   * BBacnetPropertyIdentifier constant for fileSize.
   */
  public static final BBacnetPropertyIdentifier fileSize = new BBacnetPropertyIdentifier(FILE_SIZE);
  /**
   * BBacnetPropertyIdentifier constant for fileType.
   */
  public static final BBacnetPropertyIdentifier fileType = new BBacnetPropertyIdentifier(FILE_TYPE);
  /**
   * BBacnetPropertyIdentifier constant for firmwareRevision.
   */
  public static final BBacnetPropertyIdentifier firmwareRevision = new BBacnetPropertyIdentifier(FIRMWARE_REVISION);
  /**
   * BBacnetPropertyIdentifier constant for highLimit.
   */
  public static final BBacnetPropertyIdentifier highLimit = new BBacnetPropertyIdentifier(HIGH_LIMIT);
  /**
   * BBacnetPropertyIdentifier constant for inactiveText.
   */
  public static final BBacnetPropertyIdentifier inactiveText = new BBacnetPropertyIdentifier(INACTIVE_TEXT);
  /**
   * BBacnetPropertyIdentifier constant for inProcess.
   */
  public static final BBacnetPropertyIdentifier inProcess = new BBacnetPropertyIdentifier(IN_PROCESS);
  /**
   * BBacnetPropertyIdentifier constant for instanceOf.
   */
  public static final BBacnetPropertyIdentifier instanceOf = new BBacnetPropertyIdentifier(INSTANCE_OF);
  /**
   * BBacnetPropertyIdentifier constant for integralConstant.
   */
  public static final BBacnetPropertyIdentifier integralConstant = new BBacnetPropertyIdentifier(INTEGRAL_CONSTANT);
  /**
   * BBacnetPropertyIdentifier constant for integralConstantUnits.
   */
  public static final BBacnetPropertyIdentifier integralConstantUnits = new BBacnetPropertyIdentifier(INTEGRAL_CONSTANT_UNITS);
  /**
   * BBacnetPropertyIdentifier constant for issueConfirmedNotifications.
   */
  public static final BBacnetPropertyIdentifier issueConfirmedNotifications = new BBacnetPropertyIdentifier(ISSUE_CONFIRMED_NOTIFICATIONS);
  /**
   * BBacnetPropertyIdentifier constant for limitEnable.
   */
  public static final BBacnetPropertyIdentifier limitEnable = new BBacnetPropertyIdentifier(LIMIT_ENABLE);
  /**
   * BBacnetPropertyIdentifier constant for listOfGroupMembers.
   */
  public static final BBacnetPropertyIdentifier listOfGroupMembers = new BBacnetPropertyIdentifier(LIST_OF_GROUP_MEMBERS);
  /**
   * BBacnetPropertyIdentifier constant for listOfObjectPropertyReferences.
   */
  public static final BBacnetPropertyIdentifier listOfObjectPropertyReferences = new BBacnetPropertyIdentifier(LIST_OF_OBJECT_PROPERTY_REFERENCES);
  /**
   * BBacnetPropertyIdentifier constant for listOfSessionKeys.
   */
  public static final BBacnetPropertyIdentifier listOfSessionKeys = new BBacnetPropertyIdentifier(LIST_OF_SESSION_KEYS);
  /**
   * BBacnetPropertyIdentifier constant for localDate.
   */
  public static final BBacnetPropertyIdentifier localDate = new BBacnetPropertyIdentifier(LOCAL_DATE);
  /**
   * BBacnetPropertyIdentifier constant for localTime.
   */
  public static final BBacnetPropertyIdentifier localTime = new BBacnetPropertyIdentifier(LOCAL_TIME);
  /**
   * BBacnetPropertyIdentifier constant for location.
   */
  public static final BBacnetPropertyIdentifier location = new BBacnetPropertyIdentifier(LOCATION);
  /**
   * BBacnetPropertyIdentifier constant for lowLimit.
   */
  public static final BBacnetPropertyIdentifier lowLimit = new BBacnetPropertyIdentifier(LOW_LIMIT);
  /**
   * BBacnetPropertyIdentifier constant for manipulatedVariableReference.
   */
  public static final BBacnetPropertyIdentifier manipulatedVariableReference = new BBacnetPropertyIdentifier(MANIPULATED_VARIABLE_REFERENCE);
  /**
   * BBacnetPropertyIdentifier constant for maximumOutput.
   */
  public static final BBacnetPropertyIdentifier maximumOutput = new BBacnetPropertyIdentifier(MAXIMUM_OUTPUT);
  /**
   * BBacnetPropertyIdentifier constant for maxApduLengthAccepted.
   */
  public static final BBacnetPropertyIdentifier maxApduLengthAccepted = new BBacnetPropertyIdentifier(MAX_APDU_LENGTH_ACCEPTED);
  /**
   * BBacnetPropertyIdentifier constant for maxInfoFrames.
   */
  public static final BBacnetPropertyIdentifier maxInfoFrames = new BBacnetPropertyIdentifier(MAX_INFO_FRAMES);
  /**
   * BBacnetPropertyIdentifier constant for maxMaster.
   */
  public static final BBacnetPropertyIdentifier maxMaster = new BBacnetPropertyIdentifier(MAX_MASTER);
  /**
   * BBacnetPropertyIdentifier constant for maxPresValue.
   */
  public static final BBacnetPropertyIdentifier maxPresValue = new BBacnetPropertyIdentifier(MAX_PRES_VALUE);
  /**
   * BBacnetPropertyIdentifier constant for minimumOffTime.
   */
  public static final BBacnetPropertyIdentifier minimumOffTime = new BBacnetPropertyIdentifier(MINIMUM_OFF_TIME);
  /**
   * BBacnetPropertyIdentifier constant for minimumOnTime.
   */
  public static final BBacnetPropertyIdentifier minimumOnTime = new BBacnetPropertyIdentifier(MINIMUM_ON_TIME);
  /**
   * BBacnetPropertyIdentifier constant for minimumOutput.
   */
  public static final BBacnetPropertyIdentifier minimumOutput = new BBacnetPropertyIdentifier(MINIMUM_OUTPUT);
  /**
   * BBacnetPropertyIdentifier constant for minPresValue.
   */
  public static final BBacnetPropertyIdentifier minPresValue = new BBacnetPropertyIdentifier(MIN_PRES_VALUE);
  /**
   * BBacnetPropertyIdentifier constant for modelName.
   */
  public static final BBacnetPropertyIdentifier modelName = new BBacnetPropertyIdentifier(MODEL_NAME);
  /**
   * BBacnetPropertyIdentifier constant for modificationDate.
   */
  public static final BBacnetPropertyIdentifier modificationDate = new BBacnetPropertyIdentifier(MODIFICATION_DATE);
  /**
   * BBacnetPropertyIdentifier constant for notifyType.
   */
  public static final BBacnetPropertyIdentifier notifyType = new BBacnetPropertyIdentifier(NOTIFY_TYPE);
  /**
   * BBacnetPropertyIdentifier constant for numberOfApduRetries.
   */
  public static final BBacnetPropertyIdentifier numberOfApduRetries = new BBacnetPropertyIdentifier(NUMBER_OF_APDU_RETRIES);
  /**
   * BBacnetPropertyIdentifier constant for numberOfStates.
   */
  public static final BBacnetPropertyIdentifier numberOfStates = new BBacnetPropertyIdentifier(NUMBER_OF_STATES);
  /**
   * BBacnetPropertyIdentifier constant for objectIdentifier.
   */
  public static final BBacnetPropertyIdentifier objectIdentifier = new BBacnetPropertyIdentifier(OBJECT_IDENTIFIER);
  /**
   * BBacnetPropertyIdentifier constant for objectList.
   */
  public static final BBacnetPropertyIdentifier objectList = new BBacnetPropertyIdentifier(OBJECT_LIST);
  /**
   * BBacnetPropertyIdentifier constant for objectName.
   */
  public static final BBacnetPropertyIdentifier objectName = new BBacnetPropertyIdentifier(OBJECT_NAME);
  /**
   * BBacnetPropertyIdentifier constant for objectPropertyReference.
   */
  public static final BBacnetPropertyIdentifier objectPropertyReference = new BBacnetPropertyIdentifier(OBJECT_PROPERTY_REFERENCE);
  /**
   * BBacnetPropertyIdentifier constant for objectType.
   */
  public static final BBacnetPropertyIdentifier objectType = new BBacnetPropertyIdentifier(OBJECT_TYPE);
  /**
   * BBacnetPropertyIdentifier constant for optional.
   */
  public static final BBacnetPropertyIdentifier optional = new BBacnetPropertyIdentifier(OPTIONAL);
  /**
   * BBacnetPropertyIdentifier constant for outOfService.
   */
  public static final BBacnetPropertyIdentifier outOfService = new BBacnetPropertyIdentifier(OUT_OF_SERVICE);
  /**
   * BBacnetPropertyIdentifier constant for outputUnits.
   */
  public static final BBacnetPropertyIdentifier outputUnits = new BBacnetPropertyIdentifier(OUTPUT_UNITS);
  /**
   * BBacnetPropertyIdentifier constant for eventParameters.
   */
  public static final BBacnetPropertyIdentifier eventParameters = new BBacnetPropertyIdentifier(EVENT_PARAMETERS);
  /**
   * BBacnetPropertyIdentifier constant for polarity.
   */
  public static final BBacnetPropertyIdentifier polarity = new BBacnetPropertyIdentifier(POLARITY);
  /**
   * BBacnetPropertyIdentifier constant for presentValue.
   */
  public static final BBacnetPropertyIdentifier presentValue = new BBacnetPropertyIdentifier(PRESENT_VALUE);
  /**
   * BBacnetPropertyIdentifier constant for priority.
   */
  public static final BBacnetPropertyIdentifier priority = new BBacnetPropertyIdentifier(PRIORITY);
  /**
   * BBacnetPropertyIdentifier constant for priorityArray.
   */
  public static final BBacnetPropertyIdentifier priorityArray = new BBacnetPropertyIdentifier(PRIORITY_ARRAY);
  /**
   * BBacnetPropertyIdentifier constant for priorityForWriting.
   */
  public static final BBacnetPropertyIdentifier priorityForWriting = new BBacnetPropertyIdentifier(PRIORITY_FOR_WRITING);
  /**
   * BBacnetPropertyIdentifier constant for processIdentifier.
   */
  public static final BBacnetPropertyIdentifier processIdentifier = new BBacnetPropertyIdentifier(PROCESS_IDENTIFIER);
  /**
   * BBacnetPropertyIdentifier constant for programChange.
   */
  public static final BBacnetPropertyIdentifier programChange = new BBacnetPropertyIdentifier(PROGRAM_CHANGE);
  /**
   * BBacnetPropertyIdentifier constant for programLocation.
   */
  public static final BBacnetPropertyIdentifier programLocation = new BBacnetPropertyIdentifier(PROGRAM_LOCATION);
  /**
   * BBacnetPropertyIdentifier constant for programState.
   */
  public static final BBacnetPropertyIdentifier programState = new BBacnetPropertyIdentifier(PROGRAM_STATE);
  /**
   * BBacnetPropertyIdentifier constant for proportionalConstant.
   */
  public static final BBacnetPropertyIdentifier proportionalConstant = new BBacnetPropertyIdentifier(PROPORTIONAL_CONSTANT);
  /**
   * BBacnetPropertyIdentifier constant for proportionalConstantUnits.
   */
  public static final BBacnetPropertyIdentifier proportionalConstantUnits = new BBacnetPropertyIdentifier(PROPORTIONAL_CONSTANT_UNITS);
  /**
   * BBacnetPropertyIdentifier constant for protocolConformanceClass.
   */
  public static final BBacnetPropertyIdentifier protocolConformanceClass = new BBacnetPropertyIdentifier(PROTOCOL_CONFORMANCE_CLASS);
  /**
   * BBacnetPropertyIdentifier constant for protocolObjectTypesSupported.
   */
  public static final BBacnetPropertyIdentifier protocolObjectTypesSupported = new BBacnetPropertyIdentifier(PROTOCOL_OBJECT_TYPES_SUPPORTED);
  /**
   * BBacnetPropertyIdentifier constant for protocolServicesSupported.
   */
  public static final BBacnetPropertyIdentifier protocolServicesSupported = new BBacnetPropertyIdentifier(PROTOCOL_SERVICES_SUPPORTED);
  /**
   * BBacnetPropertyIdentifier constant for protocolVersion.
   */
  public static final BBacnetPropertyIdentifier protocolVersion = new BBacnetPropertyIdentifier(PROTOCOL_VERSION);
  /**
   * BBacnetPropertyIdentifier constant for readOnly.
   */
  public static final BBacnetPropertyIdentifier readOnly = new BBacnetPropertyIdentifier(READ_ONLY);
  /**
   * BBacnetPropertyIdentifier constant for reasonForHalt.
   */
  public static final BBacnetPropertyIdentifier reasonForHalt = new BBacnetPropertyIdentifier(REASON_FOR_HALT);
  /**
   * BBacnetPropertyIdentifier constant for recipient.
   */
  public static final BBacnetPropertyIdentifier recipient = new BBacnetPropertyIdentifier(RECIPIENT);
  /**
   * BBacnetPropertyIdentifier constant for recipientList.
   */
  public static final BBacnetPropertyIdentifier recipientList = new BBacnetPropertyIdentifier(RECIPIENT_LIST);
  /**
   * BBacnetPropertyIdentifier constant for reliability.
   */
  public static final BBacnetPropertyIdentifier reliability = new BBacnetPropertyIdentifier(RELIABILITY);
  /**
   * BBacnetPropertyIdentifier constant for relinquishDefault.
   */
  public static final BBacnetPropertyIdentifier relinquishDefault = new BBacnetPropertyIdentifier(RELINQUISH_DEFAULT);
  /**
   * BBacnetPropertyIdentifier constant for required.
   */
  public static final BBacnetPropertyIdentifier required = new BBacnetPropertyIdentifier(REQUIRED);
  /**
   * BBacnetPropertyIdentifier constant for resolution.
   */
  public static final BBacnetPropertyIdentifier resolution = new BBacnetPropertyIdentifier(RESOLUTION);
  /**
   * BBacnetPropertyIdentifier constant for segmentationSupported.
   */
  public static final BBacnetPropertyIdentifier segmentationSupported = new BBacnetPropertyIdentifier(SEGMENTATION_SUPPORTED);
  /**
   * BBacnetPropertyIdentifier constant for setpoint.
   */
  public static final BBacnetPropertyIdentifier setpoint = new BBacnetPropertyIdentifier(SETPOINT);
  /**
   * BBacnetPropertyIdentifier constant for setpointReference.
   */
  public static final BBacnetPropertyIdentifier setpointReference = new BBacnetPropertyIdentifier(SETPOINT_REFERENCE);
  /**
   * BBacnetPropertyIdentifier constant for stateText.
   */
  public static final BBacnetPropertyIdentifier stateText = new BBacnetPropertyIdentifier(STATE_TEXT);
  /**
   * BBacnetPropertyIdentifier constant for statusFlags.
   */
  public static final BBacnetPropertyIdentifier statusFlags = new BBacnetPropertyIdentifier(STATUS_FLAGS);
  /**
   * BBacnetPropertyIdentifier constant for systemStatus.
   */
  public static final BBacnetPropertyIdentifier systemStatus = new BBacnetPropertyIdentifier(SYSTEM_STATUS);
  /**
   * BBacnetPropertyIdentifier constant for timeDelay.
   */
  public static final BBacnetPropertyIdentifier timeDelay = new BBacnetPropertyIdentifier(TIME_DELAY);
  /**
   * BBacnetPropertyIdentifier constant for timeOfActiveTimeReset.
   */
  public static final BBacnetPropertyIdentifier timeOfActiveTimeReset = new BBacnetPropertyIdentifier(TIME_OF_ACTIVE_TIME_RESET);
  /**
   * BBacnetPropertyIdentifier constant for timeOfStateCountReset.
   */
  public static final BBacnetPropertyIdentifier timeOfStateCountReset = new BBacnetPropertyIdentifier(TIME_OF_STATE_COUNT_RESET);
  /**
   * BBacnetPropertyIdentifier constant for timeSynchronizationRecipients.
   */
  public static final BBacnetPropertyIdentifier timeSynchronizationRecipients = new BBacnetPropertyIdentifier(TIME_SYNCHRONIZATION_RECIPIENTS);
  /**
   * BBacnetPropertyIdentifier constant for units.
   */
  public static final BBacnetPropertyIdentifier units = new BBacnetPropertyIdentifier(UNITS);
  /**
   * BBacnetPropertyIdentifier constant for updateInterval.
   */
  public static final BBacnetPropertyIdentifier updateInterval = new BBacnetPropertyIdentifier(UPDATE_INTERVAL);
  /**
   * BBacnetPropertyIdentifier constant for utcOffset.
   */
  public static final BBacnetPropertyIdentifier utcOffset = new BBacnetPropertyIdentifier(UTC_OFFSET);
  /**
   * BBacnetPropertyIdentifier constant for vendorIdentifier.
   */
  public static final BBacnetPropertyIdentifier vendorIdentifier = new BBacnetPropertyIdentifier(VENDOR_IDENTIFIER);
  /**
   * BBacnetPropertyIdentifier constant for vendorName.
   */
  public static final BBacnetPropertyIdentifier vendorName = new BBacnetPropertyIdentifier(VENDOR_NAME);
  /**
   * BBacnetPropertyIdentifier constant for vtClassesSupported.
   */
  public static final BBacnetPropertyIdentifier vtClassesSupported = new BBacnetPropertyIdentifier(VT_CLASSES_SUPPORTED);
  /**
   * BBacnetPropertyIdentifier constant for weeklySchedule.
   */
  public static final BBacnetPropertyIdentifier weeklySchedule = new BBacnetPropertyIdentifier(WEEKLY_SCHEDULE);
  /**
   * BBacnetPropertyIdentifier constant for attemptedSamples.
   */
  public static final BBacnetPropertyIdentifier attemptedSamples = new BBacnetPropertyIdentifier(ATTEMPTED_SAMPLES);
  /**
   * BBacnetPropertyIdentifier constant for averageValue.
   */
  public static final BBacnetPropertyIdentifier averageValue = new BBacnetPropertyIdentifier(AVERAGE_VALUE);
  /**
   * BBacnetPropertyIdentifier constant for bufferSize.
   */
  public static final BBacnetPropertyIdentifier bufferSize = new BBacnetPropertyIdentifier(BUFFER_SIZE);
  /**
   * BBacnetPropertyIdentifier constant for clientCovIncrement.
   */
  public static final BBacnetPropertyIdentifier clientCovIncrement = new BBacnetPropertyIdentifier(CLIENT_COV_INCREMENT);
  /**
   * BBacnetPropertyIdentifier constant for covResubscriptionInterval.
   */
  public static final BBacnetPropertyIdentifier covResubscriptionInterval = new BBacnetPropertyIdentifier(COV_RESUBSCRIPTION_INTERVAL);
  /**
   * BBacnetPropertyIdentifier constant for currentNotifyTime.
   */
  public static final BBacnetPropertyIdentifier currentNotifyTime = new BBacnetPropertyIdentifier(CURRENT_NOTIFY_TIME);
  /**
   * BBacnetPropertyIdentifier constant for eventTimeStamps.
   */
  public static final BBacnetPropertyIdentifier eventTimeStamps = new BBacnetPropertyIdentifier(EVENT_TIME_STAMPS);
  /**
   * BBacnetPropertyIdentifier constant for logBuffer.
   */
  public static final BBacnetPropertyIdentifier logBuffer = new BBacnetPropertyIdentifier(LOG_BUFFER);
  /**
   * BBacnetPropertyIdentifier constant for logDeviceObjectProperty.
   */
  public static final BBacnetPropertyIdentifier logDeviceObjectProperty = new BBacnetPropertyIdentifier(LOG_DEVICE_OBJECT_PROPERTY);
  /**
   * BBacnetPropertyIdentifier constant for enable.
   */
  public static final BBacnetPropertyIdentifier enable = new BBacnetPropertyIdentifier(ENABLE);
  /**
   * BBacnetPropertyIdentifier constant for logInterval.
   */
  public static final BBacnetPropertyIdentifier logInterval = new BBacnetPropertyIdentifier(LOG_INTERVAL);
  /**
   * BBacnetPropertyIdentifier constant for maximumValue.
   */
  public static final BBacnetPropertyIdentifier maximumValue = new BBacnetPropertyIdentifier(MAXIMUM_VALUE);
  /**
   * BBacnetPropertyIdentifier constant for minimumValue.
   */
  public static final BBacnetPropertyIdentifier minimumValue = new BBacnetPropertyIdentifier(MINIMUM_VALUE);
  /**
   * BBacnetPropertyIdentifier constant for notificationThreshold.
   */
  public static final BBacnetPropertyIdentifier notificationThreshold = new BBacnetPropertyIdentifier(NOTIFICATION_THRESHOLD);
  /**
   * BBacnetPropertyIdentifier constant for previousNotifyTime.
   */
  public static final BBacnetPropertyIdentifier previousNotifyTime = new BBacnetPropertyIdentifier(PREVIOUS_NOTIFY_TIME);
  /**
   * BBacnetPropertyIdentifier constant for protocolRevision.
   */
  public static final BBacnetPropertyIdentifier protocolRevision = new BBacnetPropertyIdentifier(PROTOCOL_REVISION);
  /**
   * BBacnetPropertyIdentifier constant for recordsSinceNotification.
   */
  public static final BBacnetPropertyIdentifier recordsSinceNotification = new BBacnetPropertyIdentifier(RECORDS_SINCE_NOTIFICATION);
  /**
   * BBacnetPropertyIdentifier constant for recordCount.
   */
  public static final BBacnetPropertyIdentifier recordCount = new BBacnetPropertyIdentifier(RECORD_COUNT);
  /**
   * BBacnetPropertyIdentifier constant for startTime.
   */
  public static final BBacnetPropertyIdentifier startTime = new BBacnetPropertyIdentifier(START_TIME);
  /**
   * BBacnetPropertyIdentifier constant for stopTime.
   */
  public static final BBacnetPropertyIdentifier stopTime = new BBacnetPropertyIdentifier(STOP_TIME);
  /**
   * BBacnetPropertyIdentifier constant for stopWhenFull.
   */
  public static final BBacnetPropertyIdentifier stopWhenFull = new BBacnetPropertyIdentifier(STOP_WHEN_FULL);
  /**
   * BBacnetPropertyIdentifier constant for totalRecordCount.
   */
  public static final BBacnetPropertyIdentifier totalRecordCount = new BBacnetPropertyIdentifier(TOTAL_RECORD_COUNT);
  /**
   * BBacnetPropertyIdentifier constant for validSamples.
   */
  public static final BBacnetPropertyIdentifier validSamples = new BBacnetPropertyIdentifier(VALID_SAMPLES);
  /**
   * BBacnetPropertyIdentifier constant for windowInterval.
   */
  public static final BBacnetPropertyIdentifier windowInterval = new BBacnetPropertyIdentifier(WINDOW_INTERVAL);
  /**
   * BBacnetPropertyIdentifier constant for windowSamples.
   */
  public static final BBacnetPropertyIdentifier windowSamples = new BBacnetPropertyIdentifier(WINDOW_SAMPLES);
  /**
   * BBacnetPropertyIdentifier constant for maximumValueTimestamp.
   */
  public static final BBacnetPropertyIdentifier maximumValueTimestamp = new BBacnetPropertyIdentifier(MAXIMUM_VALUE_TIMESTAMP);
  /**
   * BBacnetPropertyIdentifier constant for minimumValueTimestamp.
   */
  public static final BBacnetPropertyIdentifier minimumValueTimestamp = new BBacnetPropertyIdentifier(MINIMUM_VALUE_TIMESTAMP);
  /**
   * BBacnetPropertyIdentifier constant for varianceValue.
   */
  public static final BBacnetPropertyIdentifier varianceValue = new BBacnetPropertyIdentifier(VARIANCE_VALUE);
  /**
   * BBacnetPropertyIdentifier constant for activeCovSubscriptions.
   */
  public static final BBacnetPropertyIdentifier activeCovSubscriptions = new BBacnetPropertyIdentifier(ACTIVE_COV_SUBSCRIPTIONS);
  /**
   * BBacnetPropertyIdentifier constant for backupFailureTimeout.
   */
  public static final BBacnetPropertyIdentifier backupFailureTimeout = new BBacnetPropertyIdentifier(BACKUP_FAILURE_TIMEOUT);
  /**
   * BBacnetPropertyIdentifier constant for configurationFiles.
   */
  public static final BBacnetPropertyIdentifier configurationFiles = new BBacnetPropertyIdentifier(CONFIGURATION_FILES);
  /**
   * BBacnetPropertyIdentifier constant for databaseRevision.
   */
  public static final BBacnetPropertyIdentifier databaseRevision = new BBacnetPropertyIdentifier(DATABASE_REVISION);
  /**
   * BBacnetPropertyIdentifier constant for directReading.
   */
  public static final BBacnetPropertyIdentifier directReading = new BBacnetPropertyIdentifier(DIRECT_READING);
  /**
   * BBacnetPropertyIdentifier constant for lastRestoreTime.
   */
  public static final BBacnetPropertyIdentifier lastRestoreTime = new BBacnetPropertyIdentifier(LAST_RESTORE_TIME);
  /**
   * BBacnetPropertyIdentifier constant for maintenanceRequired.
   */
  public static final BBacnetPropertyIdentifier maintenanceRequired = new BBacnetPropertyIdentifier(MAINTENANCE_REQUIRED);
  /**
   * BBacnetPropertyIdentifier constant for memberOf.
   */
  public static final BBacnetPropertyIdentifier memberOf = new BBacnetPropertyIdentifier(MEMBER_OF);
  /**
   * BBacnetPropertyIdentifier constant for mode.
   */
  public static final BBacnetPropertyIdentifier mode = new BBacnetPropertyIdentifier(MODE);
  /**
   * BBacnetPropertyIdentifier constant for operationExpected.
   */
  public static final BBacnetPropertyIdentifier operationExpected = new BBacnetPropertyIdentifier(OPERATION_EXPECTED);
  /**
   * BBacnetPropertyIdentifier constant for setting.
   */
  public static final BBacnetPropertyIdentifier setting = new BBacnetPropertyIdentifier(SETTING);
  /**
   * BBacnetPropertyIdentifier constant for silenced.
   */
  public static final BBacnetPropertyIdentifier silenced = new BBacnetPropertyIdentifier(SILENCED);
  /**
   * BBacnetPropertyIdentifier constant for trackingValue.
   */
  public static final BBacnetPropertyIdentifier trackingValue = new BBacnetPropertyIdentifier(TRACKING_VALUE);
  /**
   * BBacnetPropertyIdentifier constant for zoneMembers.
   */
  public static final BBacnetPropertyIdentifier zoneMembers = new BBacnetPropertyIdentifier(ZONE_MEMBERS);
  /**
   * BBacnetPropertyIdentifier constant for lifeSafetyAlarmValues.
   */
  public static final BBacnetPropertyIdentifier lifeSafetyAlarmValues = new BBacnetPropertyIdentifier(LIFE_SAFETY_ALARM_VALUES);
  /**
   * BBacnetPropertyIdentifier constant for maxSegmentsAccepted.
   */
  public static final BBacnetPropertyIdentifier maxSegmentsAccepted = new BBacnetPropertyIdentifier(MAX_SEGMENTS_ACCEPTED);
  /**
   * BBacnetPropertyIdentifier constant for profileName.
   */
  public static final BBacnetPropertyIdentifier profileName = new BBacnetPropertyIdentifier(PROFILE_NAME);
  /**
   * BBacnetPropertyIdentifier constant for autoSlaveDiscovery.
   */
  public static final BBacnetPropertyIdentifier autoSlaveDiscovery = new BBacnetPropertyIdentifier(AUTO_SLAVE_DISCOVERY);
  /**
   * BBacnetPropertyIdentifier constant for manualSlaveAddressBinding.
   */
  public static final BBacnetPropertyIdentifier manualSlaveAddressBinding = new BBacnetPropertyIdentifier(MANUAL_SLAVE_ADDRESS_BINDING);
  /**
   * BBacnetPropertyIdentifier constant for slaveAddressBinding.
   */
  public static final BBacnetPropertyIdentifier slaveAddressBinding = new BBacnetPropertyIdentifier(SLAVE_ADDRESS_BINDING);
  /**
   * BBacnetPropertyIdentifier constant for slaveProxyEnable.
   */
  public static final BBacnetPropertyIdentifier slaveProxyEnable = new BBacnetPropertyIdentifier(SLAVE_PROXY_ENABLE);
  /**
   * BBacnetPropertyIdentifier constant for lastNotifyRecord.
   */
  public static final BBacnetPropertyIdentifier lastNotifyRecord = new BBacnetPropertyIdentifier(LAST_NOTIFY_RECORD);
  /**
   * BBacnetPropertyIdentifier constant for scheduleDefault.
   */
  public static final BBacnetPropertyIdentifier scheduleDefault = new BBacnetPropertyIdentifier(SCHEDULE_DEFAULT);
  /**
   * BBacnetPropertyIdentifier constant for acceptedModes.
   */
  public static final BBacnetPropertyIdentifier acceptedModes = new BBacnetPropertyIdentifier(ACCEPTED_MODES);
  /**
   * BBacnetPropertyIdentifier constant for adjustValue.
   */
  public static final BBacnetPropertyIdentifier adjustValue = new BBacnetPropertyIdentifier(ADJUST_VALUE);
  /**
   * BBacnetPropertyIdentifier constant for count.
   */
  public static final BBacnetPropertyIdentifier count = new BBacnetPropertyIdentifier(COUNT);
  /**
   * BBacnetPropertyIdentifier constant for countBeforeChange.
   */
  public static final BBacnetPropertyIdentifier countBeforeChange = new BBacnetPropertyIdentifier(COUNT_BEFORE_CHANGE);
  /**
   * BBacnetPropertyIdentifier constant for countChangeTime.
   */
  public static final BBacnetPropertyIdentifier countChangeTime = new BBacnetPropertyIdentifier(COUNT_CHANGE_TIME);
  /**
   * BBacnetPropertyIdentifier constant for covPeriod.
   */
  public static final BBacnetPropertyIdentifier covPeriod = new BBacnetPropertyIdentifier(COV_PERIOD);
  /**
   * BBacnetPropertyIdentifier constant for inputReference.
   */
  public static final BBacnetPropertyIdentifier inputReference = new BBacnetPropertyIdentifier(INPUT_REFERENCE);
  /**
   * BBacnetPropertyIdentifier constant for limitMonitoringInterval.
   */
  public static final BBacnetPropertyIdentifier limitMonitoringInterval = new BBacnetPropertyIdentifier(LIMIT_MONITORING_INTERVAL);
  /**
   * BBacnetPropertyIdentifier constant for loggingObject.
   */
  public static final BBacnetPropertyIdentifier loggingObject = new BBacnetPropertyIdentifier(LOGGING_OBJECT);
  /**
   * BBacnetPropertyIdentifier constant for loggingRecord.
   */
  public static final BBacnetPropertyIdentifier loggingRecord = new BBacnetPropertyIdentifier(LOGGING_RECORD);
  /**
   * BBacnetPropertyIdentifier constant for prescale.
   */
  public static final BBacnetPropertyIdentifier prescale = new BBacnetPropertyIdentifier(PRESCALE);
  /**
   * BBacnetPropertyIdentifier constant for pulseRate.
   */
  public static final BBacnetPropertyIdentifier pulseRate = new BBacnetPropertyIdentifier(PULSE_RATE);
  /**
   * BBacnetPropertyIdentifier constant for scale.
   */
  public static final BBacnetPropertyIdentifier scale = new BBacnetPropertyIdentifier(SCALE);
  /**
   * BBacnetPropertyIdentifier constant for scaleFactor.
   */
  public static final BBacnetPropertyIdentifier scaleFactor = new BBacnetPropertyIdentifier(SCALE_FACTOR);
  /**
   * BBacnetPropertyIdentifier constant for updateTime.
   */
  public static final BBacnetPropertyIdentifier updateTime = new BBacnetPropertyIdentifier(UPDATE_TIME);
  /**
   * BBacnetPropertyIdentifier constant for valueBeforeChange.
   */
  public static final BBacnetPropertyIdentifier valueBeforeChange = new BBacnetPropertyIdentifier(VALUE_BEFORE_CHANGE);
  /**
   * BBacnetPropertyIdentifier constant for valueSet.
   */
  public static final BBacnetPropertyIdentifier valueSet = new BBacnetPropertyIdentifier(VALUE_SET);
  /**
   * BBacnetPropertyIdentifier constant for valueChangeTime.
   */
  public static final BBacnetPropertyIdentifier valueChangeTime = new BBacnetPropertyIdentifier(VALUE_CHANGE_TIME);
  /**
   * BBacnetPropertyIdentifier constant for alignIntervals.
   */
  public static final BBacnetPropertyIdentifier alignIntervals = new BBacnetPropertyIdentifier(ALIGN_INTERVALS);
  /**
   * BBacnetPropertyIdentifier constant for intervalOffset.
   */
  public static final BBacnetPropertyIdentifier intervalOffset = new BBacnetPropertyIdentifier(INTERVAL_OFFSET);
  /**
   * BBacnetPropertyIdentifier constant for lastRestartReason.
   */
  public static final BBacnetPropertyIdentifier lastRestartReason = new BBacnetPropertyIdentifier(LAST_RESTART_REASON);
  /**
   * BBacnetPropertyIdentifier constant for loggingType.
   */
  public static final BBacnetPropertyIdentifier loggingType = new BBacnetPropertyIdentifier(LOGGING_TYPE);
  /**
   * BBacnetPropertyIdentifier constant for restartNotificationRecipients.
   */
  public static final BBacnetPropertyIdentifier restartNotificationRecipients = new BBacnetPropertyIdentifier(RESTART_NOTIFICATION_RECIPIENTS);
  /**
   * BBacnetPropertyIdentifier constant for timeOfDeviceRestart.
   */
  public static final BBacnetPropertyIdentifier timeOfDeviceRestart = new BBacnetPropertyIdentifier(TIME_OF_DEVICE_RESTART);
  /**
   * BBacnetPropertyIdentifier constant for timeSynchronizationInterval.
   */
  public static final BBacnetPropertyIdentifier timeSynchronizationInterval = new BBacnetPropertyIdentifier(TIME_SYNCHRONIZATION_INTERVAL);
  /**
   * BBacnetPropertyIdentifier constant for trigger.
   */
  public static final BBacnetPropertyIdentifier trigger = new BBacnetPropertyIdentifier(TRIGGER);
  /**
   * BBacnetPropertyIdentifier constant for utcTimeSynchronizationRecipients.
   */
  public static final BBacnetPropertyIdentifier utcTimeSynchronizationRecipients = new BBacnetPropertyIdentifier(UTC_TIME_SYNCHRONIZATION_RECIPIENTS);
  /**
   * BBacnetPropertyIdentifier constant for nodeSubtype.
   */
  public static final BBacnetPropertyIdentifier nodeSubtype = new BBacnetPropertyIdentifier(NODE_SUBTYPE);
  /**
   * BBacnetPropertyIdentifier constant for nodeType.
   */
  public static final BBacnetPropertyIdentifier nodeType = new BBacnetPropertyIdentifier(NODE_TYPE);
  /**
   * BBacnetPropertyIdentifier constant for structuredObjectList.
   */
  public static final BBacnetPropertyIdentifier structuredObjectList = new BBacnetPropertyIdentifier(STRUCTURED_OBJECT_LIST);
  /**
   * BBacnetPropertyIdentifier constant for subordinateAnnotations.
   */
  public static final BBacnetPropertyIdentifier subordinateAnnotations = new BBacnetPropertyIdentifier(SUBORDINATE_ANNOTATIONS);
  /**
   * BBacnetPropertyIdentifier constant for subordinateList.
   */
  public static final BBacnetPropertyIdentifier subordinateList = new BBacnetPropertyIdentifier(SUBORDINATE_LIST);
  /**
   * BBacnetPropertyIdentifier constant for actualShedLevel.
   */
  public static final BBacnetPropertyIdentifier actualShedLevel = new BBacnetPropertyIdentifier(ACTUAL_SHED_LEVEL);
  /**
   * BBacnetPropertyIdentifier constant for dutyWindow.
   */
  public static final BBacnetPropertyIdentifier dutyWindow = new BBacnetPropertyIdentifier(DUTY_WINDOW);
  /**
   * BBacnetPropertyIdentifier constant for expectedShedLevel.
   */
  public static final BBacnetPropertyIdentifier expectedShedLevel = new BBacnetPropertyIdentifier(EXPECTED_SHED_LEVEL);
  /**
   * BBacnetPropertyIdentifier constant for fullDutyBaseline.
   */
  public static final BBacnetPropertyIdentifier fullDutyBaseline = new BBacnetPropertyIdentifier(FULL_DUTY_BASELINE);
  /**
   * BBacnetPropertyIdentifier constant for requestedShedLevel.
   */
  public static final BBacnetPropertyIdentifier requestedShedLevel = new BBacnetPropertyIdentifier(REQUESTED_SHED_LEVEL);
  /**
   * BBacnetPropertyIdentifier constant for shedDuration.
   */
  public static final BBacnetPropertyIdentifier shedDuration = new BBacnetPropertyIdentifier(SHED_DURATION);
  /**
   * BBacnetPropertyIdentifier constant for shedLevelDescriptions.
   */
  public static final BBacnetPropertyIdentifier shedLevelDescriptions = new BBacnetPropertyIdentifier(SHED_LEVEL_DESCRIPTIONS);
  /**
   * BBacnetPropertyIdentifier constant for shedLevels.
   */
  public static final BBacnetPropertyIdentifier shedLevels = new BBacnetPropertyIdentifier(SHED_LEVELS);
  /**
   * BBacnetPropertyIdentifier constant for stateDescription.
   */
  public static final BBacnetPropertyIdentifier stateDescription = new BBacnetPropertyIdentifier(STATE_DESCRIPTION);
  /**
   * BBacnetPropertyIdentifier constant for doorAlarmState.
   */
  public static final BBacnetPropertyIdentifier doorAlarmState = new BBacnetPropertyIdentifier(DOOR_ALARM_STATE);
  /**
   * BBacnetPropertyIdentifier constant for doorExtendedPulseTime.
   */
  public static final BBacnetPropertyIdentifier doorExtendedPulseTime = new BBacnetPropertyIdentifier(DOOR_EXTENDED_PULSE_TIME);
  /**
   * BBacnetPropertyIdentifier constant for doorMembers.
   */
  public static final BBacnetPropertyIdentifier doorMembers = new BBacnetPropertyIdentifier(DOOR_MEMBERS);
  /**
   * BBacnetPropertyIdentifier constant for doorOpenTooLongTime.
   */
  public static final BBacnetPropertyIdentifier doorOpenTooLongTime = new BBacnetPropertyIdentifier(DOOR_OPEN_TOO_LONG_TIME);
  /**
   * BBacnetPropertyIdentifier constant for doorPulseTime.
   */
  public static final BBacnetPropertyIdentifier doorPulseTime = new BBacnetPropertyIdentifier(DOOR_PULSE_TIME);
  /**
   * BBacnetPropertyIdentifier constant for doorStatus.
   */
  public static final BBacnetPropertyIdentifier doorStatus = new BBacnetPropertyIdentifier(DOOR_STATUS);
  /**
   * BBacnetPropertyIdentifier constant for doorUnlockDelayTime.
   */
  public static final BBacnetPropertyIdentifier doorUnlockDelayTime = new BBacnetPropertyIdentifier(DOOR_UNLOCK_DELAY_TIME);
  /**
   * BBacnetPropertyIdentifier constant for lockStatus.
   */
  public static final BBacnetPropertyIdentifier lockStatus = new BBacnetPropertyIdentifier(LOCK_STATUS);
  /**
   * BBacnetPropertyIdentifier constant for maskedAlarmValues.
   */
  public static final BBacnetPropertyIdentifier maskedAlarmValues = new BBacnetPropertyIdentifier(MASKED_ALARM_VALUES);
  /**
   * BBacnetPropertyIdentifier constant for securedStatus.
   */
  public static final BBacnetPropertyIdentifier securedStatus = new BBacnetPropertyIdentifier(SECURED_STATUS);
  /**
   * BBacnetPropertyIdentifier constant for absenteeLimit.
   */
  public static final BBacnetPropertyIdentifier absenteeLimit = new BBacnetPropertyIdentifier(ABSENTEE_LIMIT);
  /**
   * BBacnetPropertyIdentifier constant for accessAlarmEvents.
   */
  public static final BBacnetPropertyIdentifier accessAlarmEvents = new BBacnetPropertyIdentifier(ACCESS_ALARM_EVENTS);
  /**
   * BBacnetPropertyIdentifier constant for accessDoors.
   */
  public static final BBacnetPropertyIdentifier accessDoors = new BBacnetPropertyIdentifier(ACCESS_DOORS);
  /**
   * BBacnetPropertyIdentifier constant for accessEvent.
   */
  public static final BBacnetPropertyIdentifier accessEvent = new BBacnetPropertyIdentifier(ACCESS_EVENT);
  /**
   * BBacnetPropertyIdentifier constant for accessEventAuthenticationFactor.
   */
  public static final BBacnetPropertyIdentifier accessEventAuthenticationFactor = new BBacnetPropertyIdentifier(ACCESS_EVENT_AUTHENTICATION_FACTOR);
  /**
   * BBacnetPropertyIdentifier constant for accessEventCredential.
   */
  public static final BBacnetPropertyIdentifier accessEventCredential = new BBacnetPropertyIdentifier(ACCESS_EVENT_CREDENTIAL);
  /**
   * BBacnetPropertyIdentifier constant for accessEventTime.
   */
  public static final BBacnetPropertyIdentifier accessEventTime = new BBacnetPropertyIdentifier(ACCESS_EVENT_TIME);
  /**
   * BBacnetPropertyIdentifier constant for accessTransactionEvents.
   */
  public static final BBacnetPropertyIdentifier accessTransactionEvents = new BBacnetPropertyIdentifier(ACCESS_TRANSACTION_EVENTS);
  /**
   * BBacnetPropertyIdentifier constant for accompaniment.
   */
  public static final BBacnetPropertyIdentifier accompaniment = new BBacnetPropertyIdentifier(ACCOMPANIMENT);
  /**
   * BBacnetPropertyIdentifier constant for accompanimentTime.
   */
  public static final BBacnetPropertyIdentifier accompanimentTime = new BBacnetPropertyIdentifier(ACCOMPANIMENT_TIME);
  /**
   * BBacnetPropertyIdentifier constant for activationTime.
   */
  public static final BBacnetPropertyIdentifier activationTime = new BBacnetPropertyIdentifier(ACTIVATION_TIME);
  /**
   * BBacnetPropertyIdentifier constant for activeAuthenticationPolicy.
   */
  public static final BBacnetPropertyIdentifier activeAuthenticationPolicy = new BBacnetPropertyIdentifier(ACTIVE_AUTHENTICATION_POLICY);
  /**
   * BBacnetPropertyIdentifier constant for assignedAccessRights.
   */
  public static final BBacnetPropertyIdentifier assignedAccessRights = new BBacnetPropertyIdentifier(ASSIGNED_ACCESS_RIGHTS);
  /**
   * BBacnetPropertyIdentifier constant for authenticationFactors.
   */
  public static final BBacnetPropertyIdentifier authenticationFactors = new BBacnetPropertyIdentifier(AUTHENTICATION_FACTORS);
  /**
   * BBacnetPropertyIdentifier constant for authenticationPolicyList.
   */
  public static final BBacnetPropertyIdentifier authenticationPolicyList = new BBacnetPropertyIdentifier(AUTHENTICATION_POLICY_LIST);
  /**
   * BBacnetPropertyIdentifier constant for authenticationPolicyNames.
   */
  public static final BBacnetPropertyIdentifier authenticationPolicyNames = new BBacnetPropertyIdentifier(AUTHENTICATION_POLICY_NAMES);
  /**
   * BBacnetPropertyIdentifier constant for authenticationStatus.
   */
  public static final BBacnetPropertyIdentifier authenticationStatus = new BBacnetPropertyIdentifier(AUTHENTICATION_STATUS);
  /**
   * BBacnetPropertyIdentifier constant for authorizationMode.
   */
  public static final BBacnetPropertyIdentifier authorizationMode = new BBacnetPropertyIdentifier(AUTHORIZATION_MODE);
  /**
   * BBacnetPropertyIdentifier constant for belongsTo.
   */
  public static final BBacnetPropertyIdentifier belongsTo = new BBacnetPropertyIdentifier(BELONGS_TO);
  /**
   * BBacnetPropertyIdentifier constant for credentialDisable.
   */
  public static final BBacnetPropertyIdentifier credentialDisable = new BBacnetPropertyIdentifier(CREDENTIAL_DISABLE);
  /**
   * BBacnetPropertyIdentifier constant for credentialStatus.
   */
  public static final BBacnetPropertyIdentifier credentialStatus = new BBacnetPropertyIdentifier(CREDENTIAL_STATUS);
  /**
   * BBacnetPropertyIdentifier constant for credentials.
   */
  public static final BBacnetPropertyIdentifier credentials = new BBacnetPropertyIdentifier(CREDENTIALS);
  /**
   * BBacnetPropertyIdentifier constant for credentialsInZone.
   */
  public static final BBacnetPropertyIdentifier credentialsInZone = new BBacnetPropertyIdentifier(CREDENTIALS_IN_ZONE);
  /**
   * BBacnetPropertyIdentifier constant for daysRemaining.
   */
  public static final BBacnetPropertyIdentifier daysRemaining = new BBacnetPropertyIdentifier(DAYS_REMAINING);
  /**
   * BBacnetPropertyIdentifier constant for entryPoints.
   */
  public static final BBacnetPropertyIdentifier entryPoints = new BBacnetPropertyIdentifier(ENTRY_POINTS);
  /**
   * BBacnetPropertyIdentifier constant for exitPoints.
   */
  public static final BBacnetPropertyIdentifier exitPoints = new BBacnetPropertyIdentifier(EXIT_POINTS);
  /**
   * BBacnetPropertyIdentifier constant for expiryTime.
   */
  public static final BBacnetPropertyIdentifier expiryTime = new BBacnetPropertyIdentifier(EXPIRY_TIME);
  /**
   * BBacnetPropertyIdentifier constant for extendedTimeEnable.
   */
  public static final BBacnetPropertyIdentifier extendedTimeEnable = new BBacnetPropertyIdentifier(EXTENDED_TIME_ENABLE);
  /**
   * BBacnetPropertyIdentifier constant for failedAttemptEvents.
   */
  public static final BBacnetPropertyIdentifier failedAttemptEvents = new BBacnetPropertyIdentifier(FAILED_ATTEMPT_EVENTS);
  /**
   * BBacnetPropertyIdentifier constant for failedAttempts.
   */
  public static final BBacnetPropertyIdentifier failedAttempts = new BBacnetPropertyIdentifier(FAILED_ATTEMPTS);
  /**
   * BBacnetPropertyIdentifier constant for failedAttemptsTime.
   */
  public static final BBacnetPropertyIdentifier failedAttemptsTime = new BBacnetPropertyIdentifier(FAILED_ATTEMPTS_TIME);
  /**
   * BBacnetPropertyIdentifier constant for lastAccessEvent.
   */
  public static final BBacnetPropertyIdentifier lastAccessEvent = new BBacnetPropertyIdentifier(LAST_ACCESS_EVENT);
  /**
   * BBacnetPropertyIdentifier constant for lastAccessPoint.
   */
  public static final BBacnetPropertyIdentifier lastAccessPoint = new BBacnetPropertyIdentifier(LAST_ACCESS_POINT);
  /**
   * BBacnetPropertyIdentifier constant for lastCredentialAdded.
   */
  public static final BBacnetPropertyIdentifier lastCredentialAdded = new BBacnetPropertyIdentifier(LAST_CREDENTIAL_ADDED);
  /**
   * BBacnetPropertyIdentifier constant for lastCredentialAddedTime.
   */
  public static final BBacnetPropertyIdentifier lastCredentialAddedTime = new BBacnetPropertyIdentifier(LAST_CREDENTIAL_ADDED_TIME);
  /**
   * BBacnetPropertyIdentifier constant for lastCredentialRemoved.
   */
  public static final BBacnetPropertyIdentifier lastCredentialRemoved = new BBacnetPropertyIdentifier(LAST_CREDENTIAL_REMOVED);
  /**
   * BBacnetPropertyIdentifier constant for lastCredentialRemovedTime.
   */
  public static final BBacnetPropertyIdentifier lastCredentialRemovedTime = new BBacnetPropertyIdentifier(LAST_CREDENTIAL_REMOVED_TIME);
  /**
   * BBacnetPropertyIdentifier constant for lastUseTime.
   */
  public static final BBacnetPropertyIdentifier lastUseTime = new BBacnetPropertyIdentifier(LAST_USE_TIME);
  /**
   * BBacnetPropertyIdentifier constant for lockout.
   */
  public static final BBacnetPropertyIdentifier lockout = new BBacnetPropertyIdentifier(LOCKOUT);
  /**
   * BBacnetPropertyIdentifier constant for lockoutRelinquishTime.
   */
  public static final BBacnetPropertyIdentifier lockoutRelinquishTime = new BBacnetPropertyIdentifier(LOCKOUT_RELINQUISH_TIME);
  /**
   * BBacnetPropertyIdentifier constant for masterExemption.
   */
  public static final BBacnetPropertyIdentifier masterExemption = new BBacnetPropertyIdentifier(MASTER_EXEMPTION);
  /**
   * BBacnetPropertyIdentifier constant for maxFailedAttempts.
   */
  public static final BBacnetPropertyIdentifier maxFailedAttempts = new BBacnetPropertyIdentifier(MAX_FAILED_ATTEMPTS);
  /**
   * BBacnetPropertyIdentifier constant for members.
   */
  public static final BBacnetPropertyIdentifier members = new BBacnetPropertyIdentifier(MEMBERS);
  /**
   * BBacnetPropertyIdentifier constant for musterPoint.
   */
  public static final BBacnetPropertyIdentifier musterPoint = new BBacnetPropertyIdentifier(MUSTER_POINT);
  /**
   * BBacnetPropertyIdentifier constant for negativeAccessRules.
   */
  public static final BBacnetPropertyIdentifier negativeAccessRules = new BBacnetPropertyIdentifier(NEGATIVE_ACCESS_RULES);
  /**
   * BBacnetPropertyIdentifier constant for numberOfAuthenticationPolicies.
   */
  public static final BBacnetPropertyIdentifier numberOfAuthenticationPolicies = new BBacnetPropertyIdentifier(NUMBER_OF_AUTHENTICATION_POLICIES);
  /**
   * BBacnetPropertyIdentifier constant for occupancyCount.
   */
  public static final BBacnetPropertyIdentifier occupancyCount = new BBacnetPropertyIdentifier(OCCUPANCY_COUNT);
  /**
   * BBacnetPropertyIdentifier constant for occupancyCountAdjust.
   */
  public static final BBacnetPropertyIdentifier occupancyCountAdjust = new BBacnetPropertyIdentifier(OCCUPANCY_COUNT_ADJUST);
  /**
   * BBacnetPropertyIdentifier constant for occupancyCountEnable.
   */
  public static final BBacnetPropertyIdentifier occupancyCountEnable = new BBacnetPropertyIdentifier(OCCUPANCY_COUNT_ENABLE);
  /**
   * BBacnetPropertyIdentifier constant for occupancyExemption.
   */
  public static final BBacnetPropertyIdentifier occupancyExemption = new BBacnetPropertyIdentifier(OCCUPANCY_EXEMPTION);
  /**
   * BBacnetPropertyIdentifier constant for occupancyLowerLimit.
   */
  public static final BBacnetPropertyIdentifier occupancyLowerLimit = new BBacnetPropertyIdentifier(OCCUPANCY_LOWER_LIMIT);
  /**
   * BBacnetPropertyIdentifier constant for occupancyLowerLimitEnforced.
   */
  public static final BBacnetPropertyIdentifier occupancyLowerLimitEnforced = new BBacnetPropertyIdentifier(OCCUPANCY_LOWER_LIMIT_ENFORCED);
  /**
   * BBacnetPropertyIdentifier constant for occupancyState.
   */
  public static final BBacnetPropertyIdentifier occupancyState = new BBacnetPropertyIdentifier(OCCUPANCY_STATE);
  /**
   * BBacnetPropertyIdentifier constant for occupancyUpperLimit.
   */
  public static final BBacnetPropertyIdentifier occupancyUpperLimit = new BBacnetPropertyIdentifier(OCCUPANCY_UPPER_LIMIT);
  /**
   * BBacnetPropertyIdentifier constant for occupancyUpperLimitEnforced.
   */
  public static final BBacnetPropertyIdentifier occupancyUpperLimitEnforced = new BBacnetPropertyIdentifier(OCCUPANCY_UPPER_LIMIT_ENFORCED);
  /**
   * BBacnetPropertyIdentifier constant for passbackExemption.
   */
  public static final BBacnetPropertyIdentifier passbackExemption = new BBacnetPropertyIdentifier(PASSBACK_EXEMPTION);
  /**
   * BBacnetPropertyIdentifier constant for passbackMode.
   */
  public static final BBacnetPropertyIdentifier passbackMode = new BBacnetPropertyIdentifier(PASSBACK_MODE);
  /**
   * BBacnetPropertyIdentifier constant for passbackTimeout.
   */
  public static final BBacnetPropertyIdentifier passbackTimeout = new BBacnetPropertyIdentifier(PASSBACK_TIMEOUT);
  /**
   * BBacnetPropertyIdentifier constant for positiveAccessRules.
   */
  public static final BBacnetPropertyIdentifier positiveAccessRules = new BBacnetPropertyIdentifier(POSITIVE_ACCESS_RULES);
  /**
   * BBacnetPropertyIdentifier constant for reasonForDisable.
   */
  public static final BBacnetPropertyIdentifier reasonForDisable = new BBacnetPropertyIdentifier(REASON_FOR_DISABLE);
  /**
   * BBacnetPropertyIdentifier constant for supportedFormats.
   */
  public static final BBacnetPropertyIdentifier supportedFormats = new BBacnetPropertyIdentifier(SUPPORTED_FORMATS);
  /**
   * BBacnetPropertyIdentifier constant for supportedFormatClasses.
   */
  public static final BBacnetPropertyIdentifier supportedFormatClasses = new BBacnetPropertyIdentifier(SUPPORTED_FORMAT_CLASSES);
  /**
   * BBacnetPropertyIdentifier constant for threatAuthority.
   */
  public static final BBacnetPropertyIdentifier threatAuthority = new BBacnetPropertyIdentifier(THREAT_AUTHORITY);
  /**
   * BBacnetPropertyIdentifier constant for threatLevel.
   */
  public static final BBacnetPropertyIdentifier threatLevel = new BBacnetPropertyIdentifier(THREAT_LEVEL);
  /**
   * BBacnetPropertyIdentifier constant for traceFlag.
   */
  public static final BBacnetPropertyIdentifier traceFlag = new BBacnetPropertyIdentifier(TRACE_FLAG);
  /**
   * BBacnetPropertyIdentifier constant for transactionNotificationClass.
   */
  public static final BBacnetPropertyIdentifier transactionNotificationClass = new BBacnetPropertyIdentifier(TRANSACTION_NOTIFICATION_CLASS);
  /**
   * BBacnetPropertyIdentifier constant for userExternalIdentifier.
   */
  public static final BBacnetPropertyIdentifier userExternalIdentifier = new BBacnetPropertyIdentifier(USER_EXTERNAL_IDENTIFIER);
  /**
   * BBacnetPropertyIdentifier constant for userInformationReference.
   */
  public static final BBacnetPropertyIdentifier userInformationReference = new BBacnetPropertyIdentifier(USER_INFORMATION_REFERENCE);
  /**
   * BBacnetPropertyIdentifier constant for userName.
   */
  public static final BBacnetPropertyIdentifier userName = new BBacnetPropertyIdentifier(USER_NAME);
  /**
   * BBacnetPropertyIdentifier constant for userType.
   */
  public static final BBacnetPropertyIdentifier userType = new BBacnetPropertyIdentifier(USER_TYPE);
  /**
   * BBacnetPropertyIdentifier constant for usesRemaining.
   */
  public static final BBacnetPropertyIdentifier usesRemaining = new BBacnetPropertyIdentifier(USES_REMAINING);
  /**
   * BBacnetPropertyIdentifier constant for zoneFrom.
   */
  public static final BBacnetPropertyIdentifier zoneFrom = new BBacnetPropertyIdentifier(ZONE_FROM);
  /**
   * BBacnetPropertyIdentifier constant for zoneTo.
   */
  public static final BBacnetPropertyIdentifier zoneTo = new BBacnetPropertyIdentifier(ZONE_TO);
  /**
   * BBacnetPropertyIdentifier constant for accessEventTag.
   */
  public static final BBacnetPropertyIdentifier accessEventTag = new BBacnetPropertyIdentifier(ACCESS_EVENT_TAG);
  /**
   * BBacnetPropertyIdentifier constant for globalIdentifier.
   */
  public static final BBacnetPropertyIdentifier globalIdentifier = new BBacnetPropertyIdentifier(GLOBAL_IDENTIFIER);
  /**
   * BBacnetPropertyIdentifier constant for verificationTime.
   */
  public static final BBacnetPropertyIdentifier verificationTime = new BBacnetPropertyIdentifier(VERIFICATION_TIME);
  /**
   * BBacnetPropertyIdentifier constant for backupAndRestoreState.
   */
  public static final BBacnetPropertyIdentifier backupAndRestoreState = new BBacnetPropertyIdentifier(BACKUP_AND_RESTORE_STATE);
  /**
   * BBacnetPropertyIdentifier constant for backupPreparationTime.
   */
  public static final BBacnetPropertyIdentifier backupPreparationTime = new BBacnetPropertyIdentifier(BACKUP_PREPARATION_TIME);
  /**
   * BBacnetPropertyIdentifier constant for restoreCompletionTime.
   */
  public static final BBacnetPropertyIdentifier restoreCompletionTime = new BBacnetPropertyIdentifier(RESTORE_COMPLETION_TIME);
  /**
   * BBacnetPropertyIdentifier constant for restorePreparationTime.
   */
  public static final BBacnetPropertyIdentifier restorePreparationTime = new BBacnetPropertyIdentifier(RESTORE_PREPARATION_TIME);
  /**
  public static final BBacnetPropertyIdentifier bitMask = new BBacnetPropertyIdentifier(BIT_MASK);
  public static final BBacnetPropertyIdentifier bitText = new BBacnetPropertyIdentifier(BIT_TEXT);
  public static final BBacnetPropertyIdentifier isUtc = new BBacnetPropertyIdentifier(IS_UTC);
   * BBacnetPropertyIdentifier constant for groupMembers.
   */
  public static final BBacnetPropertyIdentifier groupMembers = new BBacnetPropertyIdentifier(GROUP_MEMBERS);
  /**
   * BBacnetPropertyIdentifier constant for groupMemberNames.
   */
  public static final BBacnetPropertyIdentifier groupMemberNames = new BBacnetPropertyIdentifier(GROUP_MEMBER_NAMES);
  /**
   * BBacnetPropertyIdentifier constant for memberStatusDlags.
   */
  public static final BBacnetPropertyIdentifier memberStatusDlags = new BBacnetPropertyIdentifier(MEMBER_STATUS_DLAGS);
  /**
   * BBacnetPropertyIdentifier constant for requestedUpdateInterval.
   */
  public static final BBacnetPropertyIdentifier requestedUpdateInterval = new BBacnetPropertyIdentifier(REQUESTED_UPDATE_INTERVAL);
  /**
   * BBacnetPropertyIdentifier constant for covuPeriod.
   */
  public static final BBacnetPropertyIdentifier covuPeriod = new BBacnetPropertyIdentifier(COVU_PERIOD);
  /**
   * BBacnetPropertyIdentifier constant for covuRecipients.
   */
  public static final BBacnetPropertyIdentifier covuRecipients = new BBacnetPropertyIdentifier(COVU_RECIPIENTS);
  /**
   * BBacnetPropertyIdentifier constant for eventMessageTexts.
   */
  public static final BBacnetPropertyIdentifier eventMessageTexts = new BBacnetPropertyIdentifier(EVENT_MESSAGE_TEXTS);
  /**
   * BBacnetPropertyIdentifier constant for eventMessageTextsConfig.
   */
  public static final BBacnetPropertyIdentifier eventMessageTextsConfig = new BBacnetPropertyIdentifier(EVENT_MESSAGE_TEXTS_CONFIG);
  /**
   * BBacnetPropertyIdentifier constant for eventDetectionEnable.
   */
  public static final BBacnetPropertyIdentifier eventDetectionEnable = new BBacnetPropertyIdentifier(EVENT_DETECTION_ENABLE);
  /**
   * BBacnetPropertyIdentifier constant for eventAlgorithmInhibit.
   */
  public static final BBacnetPropertyIdentifier eventAlgorithmInhibit = new BBacnetPropertyIdentifier(EVENT_ALGORITHM_INHIBIT);
  /**
   * BBacnetPropertyIdentifier constant for eventAlgorithmInhibitRef.
   */
  public static final BBacnetPropertyIdentifier eventAlgorithmInhibitRef = new BBacnetPropertyIdentifier(EVENT_ALGORITHM_INHIBIT_REF);
  /**
   * BBacnetPropertyIdentifier constant for timeDelayNormal.
   */
  public static final BBacnetPropertyIdentifier timeDelayNormal = new BBacnetPropertyIdentifier(TIME_DELAY_NORMAL);
  /**
   * BBacnetPropertyIdentifier constant for reliabilityEvaluationInhibit.
   */
  public static final BBacnetPropertyIdentifier reliabilityEvaluationInhibit = new BBacnetPropertyIdentifier(RELIABILITY_EVALUATION_INHIBIT);
  /**
   * BBacnetPropertyIdentifier constant for faultParameters.
   */
  public static final BBacnetPropertyIdentifier faultParameters = new BBacnetPropertyIdentifier(FAULT_PARAMETERS);
  /**
   * BBacnetPropertyIdentifier constant for faultType.
   */
  public static final BBacnetPropertyIdentifier faultType = new BBacnetPropertyIdentifier(FAULT_TYPE);
  /**
   * BBacnetPropertyIdentifier constant for localForwardingOnly.
   */
  public static final BBacnetPropertyIdentifier localForwardingOnly = new BBacnetPropertyIdentifier(LOCAL_FORWARDING_ONLY);
  /**
   * BBacnetPropertyIdentifier constant for processIdentifierFilter.
   */
  public static final BBacnetPropertyIdentifier processIdentifierFilter = new BBacnetPropertyIdentifier(PROCESS_IDENTIFIER_FILTER);
  /**
   * BBacnetPropertyIdentifier constant for subscribedRecipients.
   */
  public static final BBacnetPropertyIdentifier subscribedRecipients = new BBacnetPropertyIdentifier(SUBSCRIBED_RECIPIENTS);
  /**
   * BBacnetPropertyIdentifier constant for authorizationExemptions.
   */
  public static final BBacnetPropertyIdentifier authorizationExemptions = new BBacnetPropertyIdentifier(AUTHORIZATION_EXEMPTIONS);
  /**
   * BBacnetPropertyIdentifier constant for allowGroupDelayInhibit.
   */
  public static final BBacnetPropertyIdentifier allowGroupDelayInhibit = new BBacnetPropertyIdentifier(ALLOW_GROUP_DELAY_INHIBIT);
  /**
   * BBacnetPropertyIdentifier constant for channelNumber.
   */
  public static final BBacnetPropertyIdentifier channelNumber = new BBacnetPropertyIdentifier(CHANNEL_NUMBER);
  /**
   * BBacnetPropertyIdentifier constant for controlGroups.
   */
  public static final BBacnetPropertyIdentifier controlGroups = new BBacnetPropertyIdentifier(CONTROL_GROUPS);
  /**
   * BBacnetPropertyIdentifier constant for executionDelay.
   */
  public static final BBacnetPropertyIdentifier executionDelay = new BBacnetPropertyIdentifier(EXECUTION_DELAY);
  /**
   * BBacnetPropertyIdentifier constant for lastPriority.
   */
  public static final BBacnetPropertyIdentifier lastPriority = new BBacnetPropertyIdentifier(LAST_PRIORITY);
  /**
   * BBacnetPropertyIdentifier constant for writeStatus.
   */
  public static final BBacnetPropertyIdentifier writeStatus = new BBacnetPropertyIdentifier(WRITE_STATUS);
  /**
   * BBacnetPropertyIdentifier constant for propertyList.
   */
  public static final BBacnetPropertyIdentifier propertyList = new BBacnetPropertyIdentifier(PROPERTY_LIST);
  /**
   * BBacnetPropertyIdentifier constant for serialNumber.
   */
  public static final BBacnetPropertyIdentifier serialNumber = new BBacnetPropertyIdentifier(SERIAL_NUMBER);
  /**
   * BBacnetPropertyIdentifier constant for blinkWarnEnable.
   */
  public static final BBacnetPropertyIdentifier blinkWarnEnable = new BBacnetPropertyIdentifier(BLINK_WARN_ENABLE);
  /**
   * BBacnetPropertyIdentifier constant for defaultFadetime.
   */
  public static final BBacnetPropertyIdentifier defaultFadetime = new BBacnetPropertyIdentifier(DEFAULT_FADETIME);
  /**
   * BBacnetPropertyIdentifier constant for defaultRamprate.
   */
  public static final BBacnetPropertyIdentifier defaultRamprate = new BBacnetPropertyIdentifier(DEFAULT_RAMPRATE);
  /**
   * BBacnetPropertyIdentifier constant for defaultStepIncrement.
   */
  public static final BBacnetPropertyIdentifier defaultStepIncrement = new BBacnetPropertyIdentifier(DEFAULT_STEP_INCREMENT);
  /**
   * BBacnetPropertyIdentifier constant for egressTimer.
   */
  public static final BBacnetPropertyIdentifier egressTime = new BBacnetPropertyIdentifier(EGRESS_TIME);
  /**
   * BBacnetPropertyIdentifier constant for inProgress.
   */
  public static final BBacnetPropertyIdentifier inProgress = new BBacnetPropertyIdentifier(IN_PROGRESS);
  /**
   * BBacnetPropertyIdentifier constant for instantaneousPower.
   */
  public static final BBacnetPropertyIdentifier instantaneousPower = new BBacnetPropertyIdentifier(INSTANTANEOUS_POWER);
  /**
   * BBacnetPropertyIdentifier constant for lightingCommand.
   */
  public static final BBacnetPropertyIdentifier lightingCommand = new BBacnetPropertyIdentifier(LIGHTING_COMMAND);
  /**
   * BBacnetPropertyIdentifier constant for lightingCommandDefaultPriority.
   */
  public static final BBacnetPropertyIdentifier lightingCommandDefaultPriority = new BBacnetPropertyIdentifier(LIGHTING_COMMAND_DEFAULT_PRIORITY);
  /**
   * BBacnetPropertyIdentifier constant for maxActualValue.
   */
  public static final BBacnetPropertyIdentifier maxActualValue = new BBacnetPropertyIdentifier(MAX_ACTUAL_VALUE);
  /**
   * BBacnetPropertyIdentifier constant for minActualValue.
   */
  public static final BBacnetPropertyIdentifier minActualValue = new BBacnetPropertyIdentifier(MIN_ACTUAL_VALUE);
  /**
   * BBacnetPropertyIdentifier constant for power.
   */
  public static final BBacnetPropertyIdentifier power = new BBacnetPropertyIdentifier(POWER);
  /**
   * BBacnetPropertyIdentifier constant for transition.
   */
  public static final BBacnetPropertyIdentifier transition = new BBacnetPropertyIdentifier(TRANSITION);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////


  public static final BBacnetPropertyIdentifier egressActive = new BBacnetPropertyIdentifier(EGRESS_ACTIVE);

  /**
   * Factory method with ordinal.
   */
  public static BBacnetPropertyIdentifier make(int ordinal)
  {
    return (BBacnetPropertyIdentifier)ackedTransitions.getRange().get(ordinal, false);
  }

  /**
   * Factory method with tag.
   */
  public static BBacnetPropertyIdentifier make(String tag)
  {
    return (BBacnetPropertyIdentifier)ackedTransitions.getRange().get(tag);
  }

  /**
   * Private constructor.
   */
  private BBacnetPropertyIdentifier(int ordinal)
  {
    super(ordinal);
  }

  public static final BBacnetPropertyIdentifier DEFAULT = ackedTransitions;

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBacnetPropertyIdentifier.class);
/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Constants
////////////////////////////////////////////////////////////////

  public static final int MAX_ASHRAE_ID = EVENT_MESSAGE_TEXTS;
  public static final int MAX_RESERVED_ID = 511;
  public static final int MAX_ID = 4194303;

  //  public static final BBacnetPropertyIdentifier DEFAULT = presentValue;
  public static final String INVALID_OR_UNSPECIFIED_ID = "Invalid ID";

  /**
   * Ordinal value for logEnable, renamed to enable in 135-2004b-4.
   * This is retained here only for the benefit of dependent projects.
   *
   * @deprecated as of 3.5.
   */
  @Deprecated
  public static final int LOG_ENABLE = 133;


////////////////////////////////////////////////////////////////
// Static methods
////////////////////////////////////////////////////////////////

  /**
   * Create a string tag for the given ordinal.
   *
   * @return the tag for the ordinal, if it is known,
   * or construct one using standard prefixes.
   */
  public static String tag(int id)
  {
    if (DEFAULT.getRange().isOrdinal(id))
      return DEFAULT.getRange().getTag(id);
    if (isAshrae(id))
      return ASHRAE_PREFIX + id;
    if (isProprietary(id))
      return PROPRIETARY_PREFIX + id;
    return INVALID_OR_UNSPECIFIED_ID;
  }

  /**
   * Get the ordinal for the given tag.
   *
   * @return the ordinal for the tag, if it is known,
   * or generate one if the tag uses standard prefixes.
   */
  public static int ordinal(String tag)
  {
    try
    {
      return DEFAULT.getRange().tagToOrdinal(tag);
    }
    catch (InvalidEnumException e)
    {
      if (tag.startsWith(ASHRAE_PREFIX))
        return Integer.parseInt(tag.substring(ASHRAE_PREFIX_LENGTH));
      if (tag.startsWith(PROPRIETARY_PREFIX))
        return Integer.parseInt(tag.substring(PROPRIETARY_PREFIX_LENGTH));
      throw e;
    }
  }

  /**
   * Is this a proprietary extension?
   *
   * @return true if this is a proprietary extension.
   */
  public static boolean isProprietary(int id)
  {
    return (id > MAX_RESERVED_ID) && (id <= MAX_ID);
  }

  /**
   * Is this an ASHRAE extension?
   *
   * @return true if this is an ASHRAE extension.
   */
  public static boolean isAshrae(int id)
  {
    return (id > MAX_ASHRAE_ID) && (id <= MAX_RESERVED_ID);
  }

  /**
   * Is this id valid for this enumeration?
   *
   * @return true if this id is within the allowed range.
   */
  public static boolean isValid(int id)
  {
    return id <= MAX_ID;
  }

  /**
   * Is this id part of the predefined (fixed) range?
   *
   * @return true if this id is in the fixed range.
   */
  public static boolean isFixed(int id)
  {
    return id <= MAX_ASHRAE_ID;
  }
}

