/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.sys.*;

/**
 * BBacnetProgramRequest represents the BACnetProgramRequest
 * enumeration.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 17 Oct 2005
 * @since Niagara 3.1
 */
public final class BBacnetProgramRequest
  extends BFrozenEnum
{
  /*-
  enum BBacnetProgramRequest
  {
    range
    {
      ready,
      load,
      run,
      halt,
      restart,
      unload
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.enums.BBacnetProgramRequest(2446026296)1.0$ @*/
/* Generated Fri Sep 15 09:15:28 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

  /**
   * Ordinal value for ready.
   */
  public static final int READY = 0;
  /**
   * Ordinal value for load.
   */
  public static final int LOAD = 1;
  /**
   * Ordinal value for run.
   */
  public static final int RUN = 2;
  /**
   * Ordinal value for halt.
   */
  public static final int HALT = 3;
  /**
   * Ordinal value for restart.
   */
  public static final int RESTART = 4;
  /**
   * Ordinal value for unload.
   */
  public static final int UNLOAD = 5;

  /**
   * BBacnetProgramRequest constant for ready.
   */
  public static final BBacnetProgramRequest ready = new BBacnetProgramRequest(READY);
  /**
   * BBacnetProgramRequest constant for load.
   */
  public static final BBacnetProgramRequest load = new BBacnetProgramRequest(LOAD);
  /**
   * BBacnetProgramRequest constant for run.
   */
  public static final BBacnetProgramRequest run = new BBacnetProgramRequest(RUN);
  /**
   * BBacnetProgramRequest constant for halt.
   */
  public static final BBacnetProgramRequest halt = new BBacnetProgramRequest(HALT);
  /**
   * BBacnetProgramRequest constant for restart.
   */
  public static final BBacnetProgramRequest restart = new BBacnetProgramRequest(RESTART);
  /**
   * BBacnetProgramRequest constant for unload.
   */
  public static final BBacnetProgramRequest unload = new BBacnetProgramRequest(UNLOAD);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetProgramRequest.class);

  /**
   * Factory method with ordinal.
   */
  public static BBacnetProgramRequest make(int ordinal)
  {
    return (BBacnetProgramRequest)ready.getRange().get(ordinal, false);
  }

  /**
   * Factory method with tag.
   */
  public static BBacnetProgramRequest make(String tag)
  {
    return (BBacnetProgramRequest)ready.getRange().get(tag);
  }

  /**
   * Private constructor.
   */
  private BBacnetProgramRequest(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Static methods
////////////////////////////////////////////////////////////////

  /**
   * Create a string tag for the given ordinal.
   *
   * @return the tag for the ordinal, if it is known,
   * or construct one using standard prefixes.
   */
  public static String tag(int id)
  {
    return DEFAULT.getRange().getTag(id);
  }


////////////////////////////////////////////////////////////////
// Constants
////////////////////////////////////////////////////////////////

  public static final BBacnetProgramRequest DEFAULT = ready;
}
