/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.sys.*;

import javax.baja.bacnet.BacnetConst;

/**
 * BBacnetPolarity represents the Bacnet Polarity
 * enumeration.
 *
 * @author Craig Gemmill
 * @version $Revision: 7$ $Date: 12/19/01 4:35:59 PM$
 * @creation 19 Jun 01
 * @since Niagara 3 Bacnet 1.0
 */
public final class BBacnetPolarity
  extends BFrozenEnum
{
  /*-
  enum BBacnetPolarity
  {
    range
    {
      normal,
      reverse
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.enums.BBacnetPolarity(3089997692)1.0$ @*/
/* Generated Thu Apr 01 15:19:44 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

  /**
   * Ordinal value for normal.
   */
  public static final int NORMAL = 0;
  /**
   * Ordinal value for reverse.
   */
  public static final int REVERSE = 1;

  /**
   * BBacnetPolarity constant for normal.
   */
  public static final BBacnetPolarity normal = new BBacnetPolarity(NORMAL);
  /**
   * BBacnetPolarity constant for reverse.
   */
  public static final BBacnetPolarity reverse = new BBacnetPolarity(REVERSE);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetPolarity.class);

  /**
   * Factory method with ordinal.
   */
  public static BBacnetPolarity make(int ordinal)
  {
    return (BBacnetPolarity)normal.getRange().get(ordinal);
  }

  /**
   * Factory method with tag.
   */
  public static BBacnetPolarity make(String tag)
  {
    return (BBacnetPolarity)normal.getRange().get(tag);
  }

  /**
   * Private constructor.
   */
  private BBacnetPolarity(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Static methods
////////////////////////////////////////////////////////////////

  /**
   * Create a string tag for the given ordinal.
   *
   * @return the tag for the ordinal, if it is known,
   * or construct one using standard prefixes.
   */
  public static String tag(int id)
  {
    return DEFAULT.getRange().getTag(id);
  }

  /**
   * @param value the boolean value to be represented.
   * @returns a BBacnetPolarity object with the given code.
   */
  public static final BBacnetPolarity make(boolean value)
  {
    return (value ? reverse : normal);
  }

  /**
   * @return String representation of this BEnum.
   */
  public String toString(Context context)
  {
    if ((context != null) && context.equals(BacnetConst.facetsContext))
      return getTag();
    return getDisplayTag(context);
  }

////////////////////////////////////////////////////////////////
// Constants
////////////////////////////////////////////////////////////////

  public static final BBacnetPolarity DEFAULT = normal;
}
