/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;

/**
 * BIBacnetDataType is the interface implemented by Bacnet constructed data types.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 22 Mar 02
 * @since Niagara 3 Bacnet 1.0
 */

public interface BIBacnetDataType
  extends BInterface, BacnetConst
{

////////////////////////////////////////////////////////////////
//  Conversion
////////////////////////////////////////////////////////////////

  /**
   * Write the value to the Asn output stream.
   *
   * @param out the AsnOutput stream.
   */
  void writeAsn(AsnOutput out);

  /**
   * Read the value from the Asn input stream.
   *
   * @param in the AsnInput stream.
   */
  void readAsn(AsnInput in)
    throws AsnException;


////////////////////////////////////////////////////////////////
//  Type
////////////////////////////////////////////////////////////////

  Type TYPE = Sys.loadType(BIBacnetDataType.class);
}