/*
 * Copyright 2006 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.sys.*;

import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.io.*;

/**
 * BErrorType represents the Error sequence.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 28 Jul 2006
 * @since Niagara 3.2
 */

public final class BErrorType
  extends BStruct
  implements BIBacnetDataType, ErrorType
{
  /*-
  class BErrorType
  {
    properties
    {
//      errorClass: BEnum
//        default {[ BDynamicEnum.make(-1, BBacnetErrorClass.DEFAULT.getRange()) ]}
//        slotfacets {[ BFacets.makeInt(0, 65535) ]}
//      errorCode: BEnum
//        default {[ BDynamicEnum.make(-1, BBacnetErrorCode.DEFAULT.getRange()) ]}
//        slotfacets {[ BFacets.makeInt(0, 65535) ]}
      errorClass: int
        default {[ -1 ]}
        slotfacets {[ BFacets.makeInt(0, 65535) ]}
      errorCode: int
        default {[ -1 ]}
        slotfacets {[ BFacets.makeInt(0, 65535) ]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.datatypes.BErrorType(19523368)1.0$ @*/
/* Generated Thu Aug 10 07:16:45 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "errorClass"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>errorClass</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BErrorType#getErrorClass
   * @see javax.baja.bacnet.datatypes.BErrorType#setErrorClass
   */
  public static final Property errorClass = newProperty(0, -1, BFacets.makeInt(0, 65535));

  /**
   * Get the <code>errorClass</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BErrorType#errorClass
   */
  public int getErrorClass()
  {
    return getInt(errorClass);
  }

  /**
   * Set the <code>errorClass</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BErrorType#errorClass
   */
  public void setErrorClass(int v)
  {
    setInt(errorClass, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "errorCode"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>errorCode</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BErrorType#getErrorCode
   * @see javax.baja.bacnet.datatypes.BErrorType#setErrorCode
   */
  public static final Property errorCode = newProperty(0, -1, BFacets.makeInt(0, 65535));

  /**
   * Get the <code>errorCode</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BErrorType#errorCode
   */
  public int getErrorCode()
  {
    return getInt(errorCode);
  }

  /**
   * Set the <code>errorCode</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BErrorType#errorCode
   */
  public void setErrorCode(int v)
  {
    setInt(errorCode, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BErrorType.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Constructor
////////////////////////////////////////////////////////////////

  /**
   * Constructor.
   */
  public BErrorType()
  {
  }

  /**
   * Fully specified constructor.
   *
   * @param errClass.
   * @param errCode.
   */
  public BErrorType(int errClass, int errCode)
  {
    setErrorClass(errClass);
    setErrorCode(errCode);
  }


////////////////////////////////////////////////////////////////
//  ErrorType
////////////////////////////////////////////////////////////////

  /**
   * Encode the property value data to Asn.
   *
   * @param AsnOutput the Asn encoder.
   */
  public void writeEncoded(AsnOutput out)
  {
    writeAsn(out);
  }

  /**
   * Decode the property value data from Asn.
   *
   * @param AsnInput the Asn decoder.
   * @throws AsnException if there is an Asn error.
   */
  public void readEncoded(AsnInput in)
    throws AsnException
  {
    readAsn(in);
  }


////////////////////////////////////////////////////////////////
//  BIBacnetDataType
////////////////////////////////////////////////////////////////

  /**
   * Write the value to the Asn output stream.
   *
   * @param out the AsnOutput stream.
   */
  public void writeAsn(AsnOutput out)
  {
    out.writeEnumerated(getErrorClass());
    out.writeEnumerated(getErrorCode());
  }

  /**
   * Read the value from the Asn input stream.
   *
   * @param in the AsnInput stream.
   */
  public void readAsn(AsnInput in)
    throws AsnException
  {
    setInt(errorClass, in.readEnumerated(), noWrite);
    setInt(errorCode, in.readEnumerated(), noWrite);
  }


////////////////////////////////////////////////////////////////
//  Access Methods
////////////////////////////////////////////////////////////////

  public boolean isDefault()
  {
    return (getErrorClass() < 0) && (getErrorCode() < 0);
  }

  public void setToDefault(Context cx)
  {
    setInt(errorClass, -1, cx);
    setInt(errorCode, -1, cx);
  }

  /**
   * To String.
   */
  public String toString(Context cx)
  {
    // If default values return empty string
    if (getErrorClass() == -1 && getErrorCode() == -1) return "";

    try
    {
      return "Error:class=" + BBacnetErrorClass.tag(getErrorClass()) + " code=" + BBacnetErrorCode.tag(getErrorCode());
    }
    catch (Exception e)
    {
      return "Invalid Error " + getErrorClass() + ":" + getErrorCode();
    }
  }

}