/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.sys.*;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;

/**
 * BBacnetSetpointReference represents the BacnetSetpointReference
 * sequence.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 09 Sep 2004
 * @since Niagara 3 Bacnet 1.0
 */

public final class BBacnetSetpointReference
  extends BStruct
  implements BIBacnetDataType
{
  /*-
  class BBacnetSetpointReference
  {
    properties
    {
      referenceUsed: boolean
        flags { hidden }
        default {[ false ]}
      reference: BBacnetObjectPropertyReference
        default {[ new BBacnetObjectPropertyReference() ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.datatypes.BBacnetSetpointReference(3714779499)1.0$ @*/
/* Generated Wed Jul 27 11:13:49 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "referenceUsed"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>referenceUsed</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetSetpointReference#getReferenceUsed
   * @see javax.baja.bacnet.datatypes.BBacnetSetpointReference#setReferenceUsed
   */
  public static final Property referenceUsed = newProperty(Flags.HIDDEN, false, null);

  /**
   * Get the <code>referenceUsed</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetSetpointReference#referenceUsed
   */
  public boolean getReferenceUsed()
  {
    return getBoolean(referenceUsed);
  }

  /**
   * Set the <code>referenceUsed</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetSetpointReference#referenceUsed
   */
  public void setReferenceUsed(boolean v)
  {
    setBoolean(referenceUsed, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "reference"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>reference</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetSetpointReference#getReference
   * @see javax.baja.bacnet.datatypes.BBacnetSetpointReference#setReference
   */
  public static final Property reference = newProperty(0, new BBacnetObjectPropertyReference(), null);

  /**
   * Get the <code>reference</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetSetpointReference#reference
   */
  public BBacnetObjectPropertyReference getReference()
  {
    return (BBacnetObjectPropertyReference)get(reference);
  }

  /**
   * Set the <code>reference</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetSetpointReference#reference
   */
  public void setReference(BBacnetObjectPropertyReference v)
  {
    set(reference, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetSetpointReference.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Constructor
////////////////////////////////////////////////////////////////

  /**
   * Default constructor.
   */
  public BBacnetSetpointReference()
  {
  }

  /**
   * Standard constructor.
   */
  public BBacnetSetpointReference(BBacnetObjectPropertyReference setpointReference)
  {
    setSetpointReference(setpointReference);
  }


////////////////////////////////////////////////////////////////
//  Access Methods
////////////////////////////////////////////////////////////////

  /**
   * To String.
   */
  public String toString(Context context)
  {
    StringBuilder sb = new StringBuilder("setpointReference:");
    if (getReferenceUsed())
      sb.append(getReference().toString(context));
    else
      sb.append("empty");
    return sb.toString();
  }

  public BBacnetObjectPropertyReference getSetpointReference()
  {
    return getReferenceUsed() ? getReference() : null;
  }

  public void setSetpointReference(BBacnetObjectPropertyReference setpointReference)
  {
    setSetpointReference(setpointReference, null);
  }

  public void setSetpointReference(BBacnetObjectPropertyReference setpointReference, Context cx)
  {
    if (setpointReference == null)
      setBoolean(referenceUsed, false, cx);
    else
    {
      setBoolean(referenceUsed, true, cx);
      set(reference, setpointReference, cx);
    }
  }


////////////////////////////////////////////////////////////////
//  BIBacnetDataType
////////////////////////////////////////////////////////////////

  /**
   * Write the value to the Asn output stream.
   *
   * @param out the AsnOutput stream.
   */
  public void writeAsn(AsnOutput out)
  {
    if (getReferenceUsed())
    {
      out.writeOpeningTag(SETPOINT_REFERENCE_TAG);
      getReference().writeAsn(out);
      out.writeClosingTag(SETPOINT_REFERENCE_TAG);
    }
  }

  /**
   * Read the value from the Asn input stream.
   *
   * @param in the AsnInput stream.
   */
  public void readAsn(AsnInput in)
    throws AsnException
  {
    in.peekTag();
    if (in.isOpeningTag(SETPOINT_REFERENCE_TAG))
    {
      in.skipTag();
      in.peekTag();
      if (in.isClosingTag(SETPOINT_REFERENCE_TAG))
      {
        setSetpointReference(null, noWrite);
        setBoolean(referenceUsed, false, noWrite);
      }
      else
      {
        setBoolean(referenceUsed, true, noWrite);
        getReference().readAsn(in);
      }
      in.skipTag();
    }
    else
    {
      setSetpointReference(null, noWrite);
      setBoolean(referenceUsed, false, noWrite);
    }
  }


////////////////////////////////////////////////////////////////
//  Constants
////////////////////////////////////////////////////////////////

  public static final int SETPOINT_REFERENCE_TAG = 0;

}
