/*
 * Copyright 2006 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.sys.*;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;

import com.tridium.bacnet.asn.AsnConst;

/**
 * BBacnetScale represents the BACnetScale data type.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 09 Jan 2006
 * @since Niagara 3 Bacnet 1.0
 */

public final class BBacnetScale
  extends BStruct
  implements BIBacnetDataType
{
  /*-
  class BBacnetScale
  {
    properties
    {
      choice: int
        default {[ 0 ]}
        slotfacets {[ BFacets.makeInt(0, 1) ]}
      scale: double
        default {[ 1 ]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.datatypes.BBacnetScale(2068424101)1.0$ @*/
/* Generated Tue Aug 18 10:22:08 EDT 2009 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "choice"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>choice</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetScale#getChoice
   * @see javax.baja.bacnet.datatypes.BBacnetScale#setChoice
   */
  public static final Property choice = newProperty(0, 0, BFacets.makeInt(0, 1));

  /**
   * Get the <code>choice</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetScale#choice
   */
  public int getChoice()
  {
    return getInt(choice);
  }

  /**
   * Set the <code>choice</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetScale#choice
   */
  public void setChoice(int v)
  {
    setInt(choice, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "scale"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>scale</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetScale#getScale
   * @see javax.baja.bacnet.datatypes.BBacnetScale#setScale
   */
  public static final Property scale = newProperty(0, 1, null);

  /**
   * Get the <code>scale</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetScale#scale
   */
  public double getScale()
  {
    return getDouble(scale);
  }

  /**
   * Set the <code>scale</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetScale#scale
   */
  public void setScale(double v)
  {
    setDouble(scale, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetScale.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Constructor.
   */
  public BBacnetScale()
  {
  }

  public BBacnetScale(double v)
  {
    setChoice(FLOAT_SCALE_TAG);
    setScale(v);
  }

  public BBacnetScale(int v)
  {
    setChoice(INTEGER_SCALE_TAG);
    setScale((double)v);
  }


////////////////////////////////////////////////////////////////
//  Access
////////////////////////////////////////////////////////////////

  /**
   * To String.
   */
  public String toString(Context context)
  {
    double d = getScale();
    return (getChoice() == FLOAT_SCALE_TAG) ? String.valueOf(d) : String.valueOf((int)d);
  }

  /**
   * Set the scale to an integer scale type.
   */
  public void setScale(double v, Context cx)
  {
    setInt(choice, FLOAT_SCALE_TAG, cx);
    setDouble(scale, v, cx);
  }

  /**
   * Set the scale to an integer scale type.
   */
  public void setScale(int v)
  {
    setScale(v, null);
  }

  /**
   * Set the scale to an integer scale type.
   */
  public void setScale(int v, Context cx)
  {
    setInt(choice, INTEGER_SCALE_TAG, cx);
    setDouble(scale, (double)v, cx);
  }


////////////////////////////////////////////////////////////////
//  BIBacnetDataType
////////////////////////////////////////////////////////////////

  /**
   * Write the value to the Asn output stream.
   *
   * @param out the AsnOutput stream.
   */
  public void writeAsn(AsnOutput out)
  {
    if (getChoice() == FLOAT_SCALE_TAG)
      out.writeReal(FLOAT_SCALE_TAG, getScale());
    else
      out.writeSignedInteger(INTEGER_SCALE_TAG, (int)getScale());
  }

  /**
   * Read the value from the Asn input stream.
   *
   * @param in the AsnInput stream.
   */
  public void readAsn(AsnInput in)
    throws AsnException
  {
    int tag = in.peekTag();
    if (in.isValueTag(FLOAT_SCALE_TAG))
      setScale(in.readReal(FLOAT_SCALE_TAG), noWrite);
    else if (in.isValueTag(INTEGER_SCALE_TAG))
      setScale(in.readSignedInteger(INTEGER_SCALE_TAG), noWrite);
    else
      throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + tag);
  }


////////////////////////////////////////////////////////////////
// Constants
////////////////////////////////////////////////////////////////

  public static final int FLOAT_SCALE_TAG = 0;
  public static final int INTEGER_SCALE_TAG = 1;

}