/*
 * Copyright 2006 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.sys.*;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;

/**
 * BBacnetPrescale represents the Bacnet Prescale
 * sequence.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 25 Jul 2006
 * @since Niagara 3.2
 */

public final class BBacnetPrescale
  extends BStruct
  implements BIBacnetDataType
{
  /*-
  class BBacnetPrescale
  {
    properties
    {
      multiplier: BBacnetUnsigned
        default {[ BBacnetUnsigned.make(0) ]}
      moduloDivide: BBacnetUnsigned
        default {[ BBacnetUnsigned.make(0) ]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.datatypes.BBacnetPrescale(1405823125)1.0$ @*/
/* Generated Tue Jul 25 15:09:47 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "multiplier"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>multiplier</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetPrescale#getMultiplier
   * @see javax.baja.bacnet.datatypes.BBacnetPrescale#setMultiplier
   */
  public static final Property multiplier = newProperty(0, BBacnetUnsigned.make(0), null);

  /**
   * Get the <code>multiplier</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetPrescale#multiplier
   */
  public BBacnetUnsigned getMultiplier()
  {
    return (BBacnetUnsigned)get(multiplier);
  }

  /**
   * Set the <code>multiplier</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetPrescale#multiplier
   */
  public void setMultiplier(BBacnetUnsigned v)
  {
    set(multiplier, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "moduloDivide"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>moduloDivide</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetPrescale#getModuloDivide
   * @see javax.baja.bacnet.datatypes.BBacnetPrescale#setModuloDivide
   */
  public static final Property moduloDivide = newProperty(0, BBacnetUnsigned.make(0), null);

  /**
   * Get the <code>moduloDivide</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetPrescale#moduloDivide
   */
  public BBacnetUnsigned getModuloDivide()
  {
    return (BBacnetUnsigned)get(moduloDivide);
  }

  /**
   * Set the <code>moduloDivide</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetPrescale#moduloDivide
   */
  public void setModuloDivide(BBacnetUnsigned v)
  {
    set(moduloDivide, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetPrescale.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Constructor
////////////////////////////////////////////////////////////////

  /**
   * Constructor.
   */
  public BBacnetPrescale()
  {
  }

  /**
   * Fully specified constructor.
   *
   * @param recipient.
   * @param processId.
   */
  public BBacnetPrescale(long mult,
                         long mod)
  {
    setMultiplier(BBacnetUnsigned.make(mult));
    setModuloDivide(BBacnetUnsigned.make(mod));
  }


////////////////////////////////////////////////////////////////
//  BIBacnetDataType
////////////////////////////////////////////////////////////////

  /**
   * Write the value to the Asn output stream.
   *
   * @param out the AsnOutput stream.
   */
  public void writeAsn(AsnOutput out)
  {
    out.writeUnsigned(MULTIPLIER_TAG, getMultiplier());
    out.writeUnsigned(MODULO_DIVIDE_TAG, getModuloDivide());
  }

  /**
   * Read the value from the Asn input stream.
   *
   * @param in the AsnInput stream.
   */
  public void readAsn(AsnInput in)
    throws AsnException
  {
    set(multiplier, in.readUnsigned(MULTIPLIER_TAG), noWrite);
    set(moduloDivide, in.readUnsigned(MODULO_DIVIDE_TAG), noWrite);
  }


////////////////////////////////////////////////////////////////
//  Access Methods
////////////////////////////////////////////////////////////////

  /**
   * To String.
   */
  public String toString(Context cx)
  {
    return "Prescale:mult=" + getMultiplier() + " mod=" + getModuloDivide();
  }


////////////////////////////////////////////////////////////////
//  Constants
////////////////////////////////////////////////////////////////

  public static final int MULTIPLIER_TAG = 0;
  public static final int MODULO_DIVIDE_TAG = 1;

}