/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.sys.*;

import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;

/**
 * BBacnetDateRange represents a BacnetDateRange value in a Bacnet property.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 19 Mar 01
 * @since Niagara 3 Bacnet 1.0
 */

public class BBacnetDateRange
  extends BStruct
  implements BIBacnetDataType
{
  /*-
  class BBacnetDateRange
  {
    properties
    {
      startDate: BBacnetDate
        default {[ BBacnetDate.DEFAULT ]}
      endDate: BBacnetDate
        default {[ BBacnetDate.DEFAULT ]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.datatypes.BBacnetDateRange(3313923166)1.0$ @*/
/* Generated Fri Sep 15 09:15:27 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "startDate"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>startDate</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetDateRange#getStartDate
   * @see javax.baja.bacnet.datatypes.BBacnetDateRange#setStartDate
   */
  public static final Property startDate = newProperty(0, BBacnetDate.DEFAULT, null);

  /**
   * Get the <code>startDate</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetDateRange#startDate
   */
  public BBacnetDate getStartDate()
  {
    return (BBacnetDate)get(startDate);
  }

  /**
   * Set the <code>startDate</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetDateRange#startDate
   */
  public void setStartDate(BBacnetDate v)
  {
    set(startDate, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "endDate"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>endDate</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetDateRange#getEndDate
   * @see javax.baja.bacnet.datatypes.BBacnetDateRange#setEndDate
   */
  public static final Property endDate = newProperty(0, BBacnetDate.DEFAULT, null);

  /**
   * Get the <code>endDate</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetDateRange#endDate
   */
  public BBacnetDate getEndDate()
  {
    return (BBacnetDate)get(endDate);
  }

  /**
   * Set the <code>endDate</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetDateRange#endDate
   */
  public void setEndDate(BBacnetDate v)
  {
    set(endDate, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetDateRange.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Constructor
////////////////////////////////////////////////////////////////

  public BBacnetDateRange()
  {
  }

  public BBacnetDateRange(BBacnetDate startDate, BBacnetDate endDate)
  {
    setStartDate(startDate);
    setEndDate(endDate);
  }


////////////////////////////////////////////////////////////////
//  BIBacnetDataType
////////////////////////////////////////////////////////////////

  /**
   * Write the value to the Asn output stream.
   *
   * @param out the AsnOutput stream.
   */
  public final void writeAsn(AsnOutput out)
  {
    out.writeDate(getStartDate());
    out.writeDate(getEndDate());
  }

  /**
   * Read the value from the Asn input stream.
   *
   * @param in the AsnInput stream.
   */
  public final void readAsn(AsnInput in)
    throws AsnException
  {
    set(startDate, in.readDate(), noWrite);
    set(endDate, in.readDate(), noWrite);
  }


////////////////////////////////////////////////////////////////
//  Access
////////////////////////////////////////////////////////////////

  /**
   * To String.
   */
  public String toString(Context context)
  {
    char sep = ';';
    if ((context != null) && context.equals(BacnetConst.facetsContext))
      sep = '_';
    return getStartDate().toString(context) + sep + getEndDate().toString(context);
  }

  /**
   * Read the startDate and endDate values from the
   * given String and return a new BBacnetDateRange.
   *
   * @param s the input string.
   * @return a BBacnetDateRange read from the string.
   */
  public static BBacnetDateRange fromString(String s)
  {
    BBacnetDate sd = BBacnetDate.fromString(s.substring(0, BBacnetDate.TEXT_LENGTH));
    BBacnetDate ed = BBacnetDate.fromString(s.substring(BBacnetDate.TEXT_LENGTH + 1,
      BBacnetDate.TEXT_LENGTH + 1 + BBacnetDate.TEXT_LENGTH));
    return new BBacnetDateRange(sd, ed);
  }

}