/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.sys.*;

import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;

/**
 * BBacnetAddressBinding represents the BacnetAddressBinding
 * sequence.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 13 Aug 02
 * @since Niagara 3 Bacnet 1.0
 */

public final class BBacnetAddressBinding
  extends BStruct
  implements BIBacnetDataType
{
  /*-
  class BBacnetAddressBinding
  {
    properties
    {
      deviceObjectId: BBacnetObjectIdentifier
        default {[ BBacnetObjectIdentifier.make(BBacnetObjectType.DEVICE) ]}
      deviceAddress: BBacnetAddress
        default {[ new BBacnetAddress() ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.datatypes.BBacnetAddressBinding(802229197)1.0$ @*/
/* Generated Mon Sep 13 14:30:11 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "deviceObjectId"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>deviceObjectId</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetAddressBinding#getDeviceObjectId
   * @see javax.baja.bacnet.datatypes.BBacnetAddressBinding#setDeviceObjectId
   */
  public static final Property deviceObjectId = newProperty(0, BBacnetObjectIdentifier.make(BBacnetObjectType.DEVICE), null);

  /**
   * Get the <code>deviceObjectId</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetAddressBinding#deviceObjectId
   */
  public BBacnetObjectIdentifier getDeviceObjectId()
  {
    return (BBacnetObjectIdentifier)get(deviceObjectId);
  }

  /**
   * Set the <code>deviceObjectId</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetAddressBinding#deviceObjectId
   */
  public void setDeviceObjectId(BBacnetObjectIdentifier v)
  {
    set(deviceObjectId, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "deviceAddress"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>deviceAddress</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetAddressBinding#getDeviceAddress
   * @see javax.baja.bacnet.datatypes.BBacnetAddressBinding#setDeviceAddress
   */
  public static final Property deviceAddress = newProperty(0, new BBacnetAddress(), null);

  /**
   * Get the <code>deviceAddress</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetAddressBinding#deviceAddress
   */
  public BBacnetAddress getDeviceAddress()
  {
    return (BBacnetAddress)get(deviceAddress);
  }

  /**
   * Set the <code>deviceAddress</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetAddressBinding#deviceAddress
   */
  public void setDeviceAddress(BBacnetAddress v)
  {
    set(deviceAddress, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetAddressBinding.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Constructor
////////////////////////////////////////////////////////////////

  /**
   * Default constructor.
   */
  public BBacnetAddressBinding()
  {
  }

  /**
   * Standard constructor.
   */
  public BBacnetAddressBinding(BBacnetObjectIdentifier deviceObjectId,
                               BBacnetAddress deviceAddress)
  {
    setDeviceObjectId(deviceObjectId);
    getDeviceAddress().copyFrom(deviceAddress);
  }


////////////////////////////////////////////////////////////////
//  Access Methods
////////////////////////////////////////////////////////////////

  /**
   * To String.
   */
  public String toString(Context context)
  {
    StringBuilder sb = new StringBuilder();
    sb.append(getDeviceObjectId().toString(context))
      .append("_to_")
      .append(getDeviceAddress().toString(context));
    return sb.toString();
  }


////////////////////////////////////////////////////////////////
//  BIBacnetDataType
////////////////////////////////////////////////////////////////

  /**
   * Write the value to the Asn output stream.
   *
   * @param out the AsnOutput stream.
   */
  public void writeAsn(AsnOutput out)
  {
    out.writeObjectIdentifier(getDeviceObjectId());
    getDeviceAddress().writeAsn(out);
  }

  /**
   * Read the value from the Asn input stream.
   *
   * @param in the AsnInput stream.
   */
  public void readAsn(AsnInput in)
    throws AsnException
  {
    set(deviceObjectId, in.readObjectIdentifier(), noWrite);
    getDeviceAddress().readAsn(in);
  }


/////////////////////////////////////////////////////////////////
//  Constants
/////////////////////////////////////////////////////////////////

  public static final int MAX_ENCODED_SIZE = 16;

}
