/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.sys.*;

import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;

/**
 * BBacnetTrendLogMultiple augments BBacnetTrendLog.
 * <p>
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 09 Sep 2009
 * @since Niagara 3.5
 */
public class BBacnetTrendLogMultiple
  extends BBacnetTrendLog
{
////////////////////////////////////////////////////////////////
//Slot overrides
////////////////////////////////////////////////////////////////

  public static final Property objectId = newProperty(Flags.SUMMARY,
    BBacnetObjectIdentifier.make(BBacnetObjectType.TREND_LOG_MULTIPLE),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER,
      ASN_OBJECT_IDENTIFIER));

  public static final Property objectType = newProperty(Flags.READONLY,
    BDynamicEnum.make(BBacnetObjectType.TREND_LOG_MULTIPLE,
      BEnumRange.make(BBacnetObjectType.TYPE)),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE,
      ASN_ENUMERATED));

 /*-
   class BBacnetTrendLogMultiple
   {
     properties
     {
      logDeviceObjectProperty: BBacnetArray
        flags { readonly }
        default {[ new BBacnetArray(BBacnetDeviceObjectPropertyReference.TYPE) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.LOG_DEVICE_OBJECT_PROPERTY,
                                 ASN_BACNET_ARRAY) ]}
     }
     actions
     {
     }
     topics
     {
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.config.BBacnetTrendLogMultiple(696168945)1.0$ @*/
/* Generated Wed Nov 30 13:06:22 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "logDeviceObjectProperty"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>logDeviceObjectProperty</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetTrendLogMultiple#getLogDeviceObjectProperty
   * @see javax.baja.bacnet.config.BBacnetTrendLogMultiple#setLogDeviceObjectProperty
   */
  public static final Property logDeviceObjectProperty = newProperty(Flags.READONLY, new BBacnetArray(BBacnetDeviceObjectPropertyReference.TYPE), makeFacets(BBacnetPropertyIdentifier.LOG_DEVICE_OBJECT_PROPERTY,
    ASN_BACNET_ARRAY));

  /**
   * Get the <code>logDeviceObjectProperty</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetTrendLogMultiple#logDeviceObjectProperty
   */
  public BBacnetArray getLogDeviceObjectProperty()
  {
    return (BBacnetArray)get(logDeviceObjectProperty);
  }

  /**
   * Set the <code>logDeviceObjectProperty</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetTrendLogMultiple#logDeviceObjectProperty
   */
  public void setLogDeviceObjectProperty(BBacnetArray v)
  {
    set(logDeviceObjectProperty, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetTrendLogMultiple.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


}
