/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.bacnet.io.PropertyValue;
import javax.baja.nre.util.Array;
import javax.baja.sys.*;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.*;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.util.BacnetBitStringUtil;

/**
 * @author Craig Gemmill
 * @version $Revision: 7$ $Date: 12/10/01 9:26:02 AM$
 * @creation 30 Jan 01
 * @since Niagara 3 Bacnet 1.0
 */
public class BBacnetSchedule
  extends BBacnetCreatableObject
{

////////////////////////////////////////////////////////////////
// Slot overrides
////////////////////////////////////////////////////////////////

  public static final Property objectId = newProperty(Flags.SUMMARY,
    BBacnetObjectIdentifier.make(BBacnetObjectType.SCHEDULE),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER,
      ASN_OBJECT_IDENTIFIER));

  public static final Property objectType = newProperty(Flags.READONLY,
    BDynamicEnum.make(BBacnetObjectType.SCHEDULE,
      BEnumRange.make(BBacnetObjectType.TYPE)),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE,
      ASN_ENUMERATED));

  /*-

  class BBacnetSchedule
  {
    properties
    {
      presentValue: BBacnetAny
        default {[ new BBacnetAny() ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.PRESENT_VALUE,
                                 ASN_ANY) ]}
      facets: BFacets
        -- These facets are applied against the presentValue property.
        default {[ BFacets.DEFAULT ]}

      effectivePeriod: BBacnetDateRange
        default {[ new BBacnetDateRange() ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.EFFECTIVE_PERIOD,
                                 ASN_CONSTRUCTED_DATA) ]}
      listOfObjectPropertyReferences: BBacnetListOf
        default {[ new BBacnetListOf(BBacnetDeviceObjectPropertyReference.TYPE) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.LIST_OF_OBJECT_PROPERTY_REFERENCES,
                                 ASN_BACNET_LIST) ]}
      priorityForWriting: BBacnetUnsigned
        default {[ BBacnetUnsigned.make(16) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.PRIORITY_FOR_WRITING,
                                 ASN_UNSIGNED) ]}
    }

    actions
    {
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.config.BBacnetSchedule(1923684516)1.0$ @*/
/* Generated Wed Jul 28 13:10:30 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "presentValue"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>presentValue</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetSchedule#getPresentValue
   * @see javax.baja.bacnet.config.BBacnetSchedule#setPresentValue
   */
  public static final Property presentValue = newProperty(0, new BBacnetAny(), makeFacets(BBacnetPropertyIdentifier.PRESENT_VALUE,
    ASN_ANY));

  /**
   * Get the <code>presentValue</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetSchedule#presentValue
   */
  public BBacnetAny getPresentValue()
  {
    return (BBacnetAny)get(presentValue);
  }

  /**
   * Set the <code>presentValue</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetSchedule#presentValue
   */
  public void setPresentValue(BBacnetAny v)
  {
    set(presentValue, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the presentValue property.
   *
   * @see javax.baja.bacnet.config.BBacnetSchedule#getFacets
   * @see javax.baja.bacnet.config.BBacnetSchedule#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.DEFAULT, null);

  /**
   * Get the <code>facets</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetSchedule#facets
   */
  public BFacets getFacets()
  {
    return (BFacets)get(facets);
  }

  /**
   * Set the <code>facets</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetSchedule#facets
   */
  public void setFacets(BFacets v)
  {
    set(facets, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "effectivePeriod"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>effectivePeriod</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetSchedule#getEffectivePeriod
   * @see javax.baja.bacnet.config.BBacnetSchedule#setEffectivePeriod
   */
  public static final Property effectivePeriod = newProperty(0, new BBacnetDateRange(), makeFacets(BBacnetPropertyIdentifier.EFFECTIVE_PERIOD,
    ASN_CONSTRUCTED_DATA));

  /**
   * Get the <code>effectivePeriod</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetSchedule#effectivePeriod
   */
  public BBacnetDateRange getEffectivePeriod()
  {
    return (BBacnetDateRange)get(effectivePeriod);
  }

  /**
   * Set the <code>effectivePeriod</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetSchedule#effectivePeriod
   */
  public void setEffectivePeriod(BBacnetDateRange v)
  {
    set(effectivePeriod, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "listOfObjectPropertyReferences"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>listOfObjectPropertyReferences</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetSchedule#getListOfObjectPropertyReferences
   * @see javax.baja.bacnet.config.BBacnetSchedule#setListOfObjectPropertyReferences
   */
  public static final Property listOfObjectPropertyReferences = newProperty(0, new BBacnetListOf(BBacnetDeviceObjectPropertyReference.TYPE), makeFacets(BBacnetPropertyIdentifier.LIST_OF_OBJECT_PROPERTY_REFERENCES,
    ASN_BACNET_LIST));

  /**
   * Get the <code>listOfObjectPropertyReferences</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetSchedule#listOfObjectPropertyReferences
   */
  public BBacnetListOf getListOfObjectPropertyReferences()
  {
    return (BBacnetListOf)get(listOfObjectPropertyReferences);
  }

  /**
   * Set the <code>listOfObjectPropertyReferences</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetSchedule#listOfObjectPropertyReferences
   */
  public void setListOfObjectPropertyReferences(BBacnetListOf v)
  {
    set(listOfObjectPropertyReferences, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "priorityForWriting"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>priorityForWriting</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetSchedule#getPriorityForWriting
   * @see javax.baja.bacnet.config.BBacnetSchedule#setPriorityForWriting
   */
  public static final Property priorityForWriting = newProperty(0, BBacnetUnsigned.make(16), makeFacets(BBacnetPropertyIdentifier.PRIORITY_FOR_WRITING,
    ASN_UNSIGNED));

  /**
   * Get the <code>priorityForWriting</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetSchedule#priorityForWriting
   */
  public BBacnetUnsigned getPriorityForWriting()
  {
    return (BBacnetUnsigned)get(priorityForWriting);
  }

  /**
   * Set the <code>priorityForWriting</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetSchedule#priorityForWriting
   */
  public void setPriorityForWriting(BBacnetUnsigned v)
  {
    set(priorityForWriting, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetSchedule.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  public BBacnetSchedule()
  {
  }


////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////

  public String toString(Context context)
  {
    StringBuilder sb = new StringBuilder();
    sb.append(getObjectId().toString(context))
      .append(nameContext.equals(context) ? '_' : ':')
      .append(getPresentValue().toString(context));
    return sb.toString();
  }


////////////////////////////////////////////////////////////////
// Actions
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
//  BComponent
////////////////////////////////////////////////////////////////

  /**
   * Started.
   */
  public void started()
    throws Exception
  {
    super.started();

    if (device().getProtocolRevision() >= 4)
    {
      if (get(BBacnetPropertyIdentifier.scheduleDefault.getTag()) == null)
      {
        add(BBacnetPropertyIdentifier.scheduleDefault.getTag(), new BBacnetAny(), 0,
          makeFacets(BBacnetPropertyIdentifier.SCHEDULE_DEFAULT, ASN_ANY),
          null);
      }

      if (get(BBacnetPropertyIdentifier.statusFlags.getTag()) == null)
      {
        add(BBacnetPropertyIdentifier.statusFlags.getTag(), BBacnetBitString.emptyBitString(
          BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), 0,
          makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS, ASN_BIT_STRING,
            BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP),
          null);
      }

      if (get(BBacnetPropertyIdentifier.reliability.getTag()) == null)
      {
        add(BBacnetPropertyIdentifier.reliability.getTag(), BDynamicEnum.make(0, BEnumRange.make(BBacnetReliability.TYPE)), 0,
          makeFacets(BBacnetPropertyIdentifier.RELIABILITY, ASN_ENUMERATED),
          null);
      }

      if (get(BBacnetPropertyIdentifier.outOfService.getTag()) == null)
      {
        add(BBacnetPropertyIdentifier.outOfService.getTag(), BBoolean.FALSE, 0,
          makeFacets(BBacnetPropertyIdentifier.OUT_OF_SERVICE, ASN_BOOLEAN),
          null);
      }

      // Rebuild the polled properties list to include these ones.
      buildPolledProperties();
    }
  }

  /**
   * Property changed.
   public void changed(Property p, Context cx)
   {
   super.changed(p,cx);
   if (!isRunning()) return;
   if (p == facets) return;
   }
   */

  /**
   * Apply the "facets" property to the "presentValue" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot == presentValue) return getFacets();
    return super.getSlotFacets(slot);
  }

////////////////////////////////////////////////////////////////
//  Overrides
////////////////////////////////////////////////////////////////

  /**
   * Subclasses that have a present value property should
   * override this method and return this property.  The
   * default returns null.
   */
  public Property getPresentValueProperty()
  {
    return presentValue;
  }


////////////////////////////////////////////////////////////////
//  Constants
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
//  Attributes
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
//  Overrides
////////////////////////////////////////////////////////////////

  protected void addObjectInitialValues(Array<PropertyValue> listOfInitialValues)
  {
    addPriorityForWriting(getPriorityForWriting(), listOfInitialValues);
    Property scheduleDefault = getProperty("scheduleDefault");
      if(scheduleDefault != null)
        addScheduleDefault(scheduleDefault, listOfInitialValues);
    addListOfObjectPropertyReferences(listOfObjectPropertyReferences, listOfInitialValues);
  }
}
