/*
 * Copyright 2006 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.bacnet.io.PropertyValue;
import javax.baja.nre.util.Array;
import javax.baja.sys.*;

import javax.baja.bacnet.datatypes.*;
import javax.baja.bacnet.enums.*;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import com.tridium.bacnet.BacUtil;

/**
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 28 Jul 2006
 * @since Niagara 3.2
 */
public class BBacnetEventEnrollment extends BBacnetCreatableObject
{

////////////////////////////////////////////////////////////////
//Slot overrides
////////////////////////////////////////////////////////////////

  public static final Property objectId = newProperty(Flags.SUMMARY,
    BBacnetObjectIdentifier.make(BBacnetObjectType.EVENT_ENROLLMENT),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER,
      ASN_OBJECT_IDENTIFIER));

  public static final Property objectType = newProperty(Flags.READONLY,
    BDynamicEnum.make(BBacnetObjectType.EVENT_ENROLLMENT,
      BEnumRange.make(BBacnetObjectType.TYPE)),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE,
      ASN_ENUMERATED));

  /*-

  class BBacnetEventEnrollment
  {
    properties
    {
      eventType: BEnum
        -- eventState indicates if this object has an active event state.
        default {[ BDynamicEnum.make(BBacnetEventType.CHANGE_OF_STATE,
                                    BEnumRange.make(BBacnetEventType.TYPE)) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.EVENT_TYPE,
                                 ASN_ENUMERATED) ]}
      notifyType: BBacnetNotifyType
        -- eventState indicates if this object has an active event state.
        default {[ BBacnetNotifyType.event ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.NOTIFY_TYPE,
                ASN_ENUMERATED),
                BFacets.make(BacUtil.makeBacnetNotifyTypeFacets()) ]}
      eventParameters: BBacnetEventParameter
        -- determines the algorithm used to monitor the referenced object
        -- and provides the parameter values needed for this algorithm.
        default {[ new BBacnetEventParameter() ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.EVENT_PARAMETERS,
                                 ASN_CONSTRUCTED_DATA) ]}
      objectPropertyReference: BBacnetDeviceObjectPropertyReference
        default {[ new BBacnetDeviceObjectPropertyReference() ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.OBJECT_PROPERTY_REFERENCE,
                                 ASN_CONSTRUCTED_DATA) ]}
      eventState: BEnum
        -- eventState indicates if this object has an active event state.
        flags { readonly }
        default {[ BDynamicEnum.make(BBacnetEventState.NORMAL,
                                    BEnumRange.make(BBacnetEventState.TYPE)) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.EVENT_STATE,
                                 ASN_ENUMERATED) ]}
      eventEnable: BBacnetBitString
        -- conveys flags that whether notifications are enabled for the various
        -- transitions.
        default {[ BBacnetBitString.emptyBitString(
                   BacnetBitStringUtil.getBitStringLength("BacnetEventTransitionBits")) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.EVENT_ENABLE,
                                 ASN_BIT_STRING,
                                 BacnetBitStringUtil.BACNET_EVENT_TRANSITION_BITS_MAP) ]}
      ackedTransitions: BBacnetBitString
        -- indicates whether the last transition of each type has been acknowledged.
        default {[ BBacnetBitString.emptyBitString(
                   BacnetBitStringUtil.getBitStringLength("BacnetEventTransitionBits")) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.ACKED_TRANSITIONS,
                                 ASN_BIT_STRING,
                                 BacnetBitStringUtil.BACNET_EVENT_TRANSITION_BITS_MAP) ]}
      notificationClass: BBacnetUnsigned
        -- references a Notification Class in the same device that specifies the
        -- handling, reporting, and acknowledgment characteristics for this object.
        default {[ BBacnetUnsigned.make(BBacnetObjectIdentifier.UNCONFIGURED_INSTANCE_NUMBER) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.NOTIFICATION_CLASS,
                                 ASN_UNSIGNED,
                                 new String[] { BFacets.MIN, BFacets.MAX },
                                 new BInteger[] { BInteger.make(0), BInteger.make(BBacnetObjectIdentifier.MAX_INSTANCE_NUMBER) } ) ]}
      eventTimeStamps: BBacnetArray
        -- contains the times of the last event notifications for each transition type.
        default {[ new BBacnetArray(BBacnetTimeStamp.TYPE, 3) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.EVENT_TIME_STAMPS,
                                 ASN_BACNET_ARRAY) ]}
    }

    actions
    {
    }
  }

  -*/

/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.config.BBacnetEventEnrollment(4264760738)1.0$ @*/
/* Generated Tue Jun 04 14:51:00 IST 2019 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Property "eventType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code eventType} property.
   * eventState indicates if this object has an active event state.
   * @see #getEventType
   * @see #setEventType
   */
  public static final Property eventType = newProperty(0, BDynamicEnum.make(BBacnetEventType.CHANGE_OF_STATE,
                                    BEnumRange.make(BBacnetEventType.TYPE)), makeFacets(BBacnetPropertyIdentifier.EVENT_TYPE,
                                 ASN_ENUMERATED));
  
  /**
   * Get the {@code eventType} property.
   * eventState indicates if this object has an active event state.
   * @see #eventType
   */
  public BEnum getEventType() { return (BEnum)get(eventType); }
  
  /**
   * Set the {@code eventType} property.
   * eventState indicates if this object has an active event state.
   * @see #eventType
   */
  public void setEventType(BEnum v) { set(eventType, v, null); }

////////////////////////////////////////////////////////////////
// Property "notifyType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code notifyType} property.
   * eventState indicates if this object has an active event state.
   * @see #getNotifyType
   * @see #setNotifyType
   */
  public static final Property notifyType = newProperty(0, BBacnetNotifyType.event, BFacets.make(makeFacets(BBacnetPropertyIdentifier.NOTIFY_TYPE,
                ASN_ENUMERATED), BFacets.make(BacUtil.makeBacnetNotifyTypeFacets())));
  
  /**
   * Get the {@code notifyType} property.
   * eventState indicates if this object has an active event state.
   * @see #notifyType
   */
  public BBacnetNotifyType getNotifyType() { return (BBacnetNotifyType)get(notifyType); }
  
  /**
   * Set the {@code notifyType} property.
   * eventState indicates if this object has an active event state.
   * @see #notifyType
   */
  public void setNotifyType(BBacnetNotifyType v) { set(notifyType, v, null); }

////////////////////////////////////////////////////////////////
// Property "eventParameters"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code eventParameters} property.
   * determines the algorithm used to monitor the referenced object
   * and provides the parameter values needed for this algorithm.
   * @see #getEventParameters
   * @see #setEventParameters
   */
  public static final Property eventParameters = newProperty(0, new BBacnetEventParameter(), makeFacets(BBacnetPropertyIdentifier.EVENT_PARAMETERS,
                                 ASN_CONSTRUCTED_DATA));
  
  /**
   * Get the {@code eventParameters} property.
   * determines the algorithm used to monitor the referenced object
   * and provides the parameter values needed for this algorithm.
   * @see #eventParameters
   */
  public BBacnetEventParameter getEventParameters() { return (BBacnetEventParameter)get(eventParameters); }
  
  /**
   * Set the {@code eventParameters} property.
   * determines the algorithm used to monitor the referenced object
   * and provides the parameter values needed for this algorithm.
   * @see #eventParameters
   */
  public void setEventParameters(BBacnetEventParameter v) { set(eventParameters, v, null); }

////////////////////////////////////////////////////////////////
// Property "objectPropertyReference"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code objectPropertyReference} property.
   * @see #getObjectPropertyReference
   * @see #setObjectPropertyReference
   */
  public static final Property objectPropertyReference = newProperty(0, new BBacnetDeviceObjectPropertyReference(), makeFacets(BBacnetPropertyIdentifier.OBJECT_PROPERTY_REFERENCE,
                                 ASN_CONSTRUCTED_DATA));
  
  /**
   * Get the {@code objectPropertyReference} property.
   * @see #objectPropertyReference
   */
  public BBacnetDeviceObjectPropertyReference getObjectPropertyReference() { return (BBacnetDeviceObjectPropertyReference)get(objectPropertyReference); }
  
  /**
   * Set the {@code objectPropertyReference} property.
   * @see #objectPropertyReference
   */
  public void setObjectPropertyReference(BBacnetDeviceObjectPropertyReference v) { set(objectPropertyReference, v, null); }

////////////////////////////////////////////////////////////////
// Property "eventState"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code eventState} property.
   * eventState indicates if this object has an active event state.
   * @see #getEventState
   * @see #setEventState
   */
  public static final Property eventState = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetEventState.NORMAL,
                                    BEnumRange.make(BBacnetEventState.TYPE)), makeFacets(BBacnetPropertyIdentifier.EVENT_STATE,
                                 ASN_ENUMERATED));
  
  /**
   * Get the {@code eventState} property.
   * eventState indicates if this object has an active event state.
   * @see #eventState
   */
  public BEnum getEventState() { return (BEnum)get(eventState); }
  
  /**
   * Set the {@code eventState} property.
   * eventState indicates if this object has an active event state.
   * @see #eventState
   */
  public void setEventState(BEnum v) { set(eventState, v, null); }

////////////////////////////////////////////////////////////////
// Property "eventEnable"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code eventEnable} property.
   * conveys flags that whether notifications are enabled for the various
   * transitions.
   * @see #getEventEnable
   * @see #setEventEnable
   */
  public static final Property eventEnable = newProperty(0, BBacnetBitString.emptyBitString(
                   BacnetBitStringUtil.getBitStringLength("BacnetEventTransitionBits")), makeFacets(BBacnetPropertyIdentifier.EVENT_ENABLE,
                                 ASN_BIT_STRING,
                                 BacnetBitStringUtil.BACNET_EVENT_TRANSITION_BITS_MAP));
  
  /**
   * Get the {@code eventEnable} property.
   * conveys flags that whether notifications are enabled for the various
   * transitions.
   * @see #eventEnable
   */
  public BBacnetBitString getEventEnable() { return (BBacnetBitString)get(eventEnable); }
  
  /**
   * Set the {@code eventEnable} property.
   * conveys flags that whether notifications are enabled for the various
   * transitions.
   * @see #eventEnable
   */
  public void setEventEnable(BBacnetBitString v) { set(eventEnable, v, null); }

////////////////////////////////////////////////////////////////
// Property "ackedTransitions"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code ackedTransitions} property.
   * indicates whether the last transition of each type has been acknowledged.
   * @see #getAckedTransitions
   * @see #setAckedTransitions
   */
  public static final Property ackedTransitions = newProperty(0, BBacnetBitString.emptyBitString(
                   BacnetBitStringUtil.getBitStringLength("BacnetEventTransitionBits")), makeFacets(BBacnetPropertyIdentifier.ACKED_TRANSITIONS,
                                 ASN_BIT_STRING,
                                 BacnetBitStringUtil.BACNET_EVENT_TRANSITION_BITS_MAP));
  
  /**
   * Get the {@code ackedTransitions} property.
   * indicates whether the last transition of each type has been acknowledged.
   * @see #ackedTransitions
   */
  public BBacnetBitString getAckedTransitions() { return (BBacnetBitString)get(ackedTransitions); }
  
  /**
   * Set the {@code ackedTransitions} property.
   * indicates whether the last transition of each type has been acknowledged.
   * @see #ackedTransitions
   */
  public void setAckedTransitions(BBacnetBitString v) { set(ackedTransitions, v, null); }

////////////////////////////////////////////////////////////////
// Property "notificationClass"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code notificationClass} property.
   * references a Notification Class in the same device that specifies the
   * handling, reporting, and acknowledgment characteristics for this object.
   * @see #getNotificationClass
   * @see #setNotificationClass
   */
  public static final Property notificationClass = newProperty(0, BBacnetUnsigned.make(BBacnetObjectIdentifier.UNCONFIGURED_INSTANCE_NUMBER), makeFacets(BBacnetPropertyIdentifier.NOTIFICATION_CLASS,
                                 ASN_UNSIGNED,
                                 new String[] { BFacets.MIN, BFacets.MAX },
                                 new BInteger[] { BInteger.make(0), BInteger.make(BBacnetObjectIdentifier.MAX_INSTANCE_NUMBER) } ));
  
  /**
   * Get the {@code notificationClass} property.
   * references a Notification Class in the same device that specifies the
   * handling, reporting, and acknowledgment characteristics for this object.
   * @see #notificationClass
   */
  public BBacnetUnsigned getNotificationClass() { return (BBacnetUnsigned)get(notificationClass); }
  
  /**
   * Set the {@code notificationClass} property.
   * references a Notification Class in the same device that specifies the
   * handling, reporting, and acknowledgment characteristics for this object.
   * @see #notificationClass
   */
  public void setNotificationClass(BBacnetUnsigned v) { set(notificationClass, v, null); }

////////////////////////////////////////////////////////////////
// Property "eventTimeStamps"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code eventTimeStamps} property.
   * contains the times of the last event notifications for each transition type.
   * @see #getEventTimeStamps
   * @see #setEventTimeStamps
   */
  public static final Property eventTimeStamps = newProperty(0, new BBacnetArray(BBacnetTimeStamp.TYPE, 3), makeFacets(BBacnetPropertyIdentifier.EVENT_TIME_STAMPS,
                                 ASN_BACNET_ARRAY));
  
  /**
   * Get the {@code eventTimeStamps} property.
   * contains the times of the last event notifications for each transition type.
   * @see #eventTimeStamps
   */
  public BBacnetArray getEventTimeStamps() { return (BBacnetArray)get(eventTimeStamps); }
  
  /**
   * Set the {@code eventTimeStamps} property.
   * contains the times of the last event notifications for each transition type.
   * @see #eventTimeStamps
   */
  public void setEventTimeStamps(BBacnetArray v) { set(eventTimeStamps, v, null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBacnetEventEnrollment.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  public BBacnetEventEnrollment()
  {
  }

////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////

  public String toString(Context context)
  {
    StringBuilder sb = new StringBuilder();
    sb.append(getObjectId().toString(context)).append(' ')
      .append(getEventType())
      .append(" monitoring ")
      .append(getObjectPropertyReference().toString(context));
    return sb.toString();
  }

  @Override
  protected void addObjectInitialValues(Array<PropertyValue> listOfInitialValues)
  {
    addNotifyType(getNotifyType(), listOfInitialValues);
    addObjectPropertyReference(getObjectPropertyReference(), listOfInitialValues);
    addEventEnable(getEventEnable(), listOfInitialValues);
    addEventParameter(getEventParameters(), listOfInitialValues);
    addNotificationClass(getNotificationClass(), listOfInitialValues);
  }

  ////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////
//  Constants
////////////////////////////////////////////////////////////////

}
