/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import java.util.logging.Level;

import javax.baja.nre.util.DefaultFileCopy;
import javax.baja.sys.*;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.naming.BOrd;
import javax.baja.spy.SpyWriter;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.*;
import javax.baja.bacnet.enums.*;
import javax.baja.bacnet.util.BacnetBitStringUtil;

import com.tridium.bacnet.stack.DeviceRegistry;
import com.tridium.bacnet.stack.transport.ConfirmedRequestPdu;

/**
 * @author Craig Gemmill
 * @version $Revision: 11$ $Date: 12/13/01 3:37:28 PM$
 * @creation 29 Jan 01
 * @since Niagara 3 Bacnet 1.0
 */
public class BBacnetDeviceObject
  extends BBacnetObject
{

////////////////////////////////////////////////////////////////
// Slot overrides
////////////////////////////////////////////////////////////////

  public static final Property objectId = newProperty(Flags.SUMMARY,
    BBacnetObjectIdentifier.make(BBacnetObjectType.DEVICE),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER,
      ASN_OBJECT_IDENTIFIER));

  public static final Property objectType = newProperty(Flags.READONLY,
    BDynamicEnum.make(BBacnetObjectType.DEVICE,
      BEnumRange.make(BBacnetObjectType.TYPE)),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE,
      ASN_ENUMERATED));

  /*-
  class  BBacnetDeviceObject
  {
    properties
    {
      systemStatus: BEnum
        -- systemStatus reflects the status of the Bacnet device as
        -- reported by the device.
        flags { readonly }
        default {[ BDynamicEnum.make(BBacnetDeviceStatus.OPERATIONAL,
                                    BEnumRange.make(BBacnetDeviceStatus.TYPE)) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.SYSTEM_STATUS,
                                 ASN_ENUMERATED) ]}
      vendorName: String
        flags { readonly }
        default {[ "" ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.VENDOR_NAME,
                                 ASN_CHARACTER_STRING) ]}
      vendorIdentifier: BBacnetUnsigned
        flags { readonly }
        default {[ new BBacnetUnsigned(-1) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.VENDOR_IDENTIFIER,
                                 ASN_UNSIGNED) ]}
      modelName: String
        flags { readonly }
        default {[ "" ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.MODEL_NAME,
                                 ASN_CHARACTER_STRING) ]}
      firmwareRevision: String
        flags { readonly }
        default {[ "" ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.FIRMWARE_REVISION,
                                 ASN_CHARACTER_STRING) ]}
      applicationSoftwareVersion: String
        flags { readonly }
        default {[ "" ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.APPLICATION_SOFTWARE_VERSION,
                                 ASN_CHARACTER_STRING) ]}
      protocolVersion: BBacnetUnsigned
        flags { readonly }
        -- protocolVersion represents the major revision number of the Bacnet
        -- specification supported by this device, starting at 1.
        default {[ new BBacnetUnsigned(1) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.PROTOCOL_VERSION,
                                 ASN_UNSIGNED) ]}
      protocolRevision: BBacnetUnsigned
        flags { readonly }
        -- protocolRevision represents the minor revision number of the Bacnet
        -- specification supported by this device.  Addendum 135b constitutes
        -- revision 1 to version 1 of the Bacnet specification.
        default {[ new BBacnetUnsigned(0) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.PROTOCOL_REVISION,
                                 ASN_UNSIGNED) ]}
      protocolServicesSupported: BBacnetBitString
        flags { readonly }
        default {[ BBacnetBitString.emptyBitString(
                   BacnetBitStringUtil.getBitStringLength("BacnetServicesSupported")) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.PROTOCOL_SERVICES_SUPPORTED,
                                 ASN_BIT_STRING,
                                 BacnetBitStringUtil.BACNET_SERVICES_SUPPORTED_MAP) ]}
      protocolObjectTypesSupported: BBacnetBitString
        flags { readonly }
        default {[ BBacnetBitString.emptyBitString(
                   BacnetBitStringUtil.getBitStringLength("BacnetObjectTypesSupported")) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.PROTOCOL_OBJECT_TYPES_SUPPORTED,
                                 ASN_BIT_STRING,
                                 BacnetBitStringUtil.BACNET_OBJECT_TYPES_SUPPORTED_MAP) ]}
      objectList: BBacnetArray
        flags { hidden, readonly }
        default {[ new BBacnetArray(BBacnetObjectIdentifier.TYPE) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.OBJECT_LIST,
                                 ASN_BACNET_ARRAY) ]}
      maxAPDULengthAccepted: BBacnetUnsigned
        flags { readonly }
        -- maxAPDULengthAccepted represents the maximum number of octets that
        -- may be contained in a single APDU sent to this device.
        default {[ new BBacnetUnsigned(ConfirmedRequestPdu.MAX_APDU_LENGTH_UP_TO_MIN_MSG_SIZE) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.MAX_APDU_LENGTH_ACCEPTED,
                                 ASN_UNSIGNED) ]}
      segmentationSupported: BBacnetSegmentation
        flags { readonly }
        -- segmentationSupported represents the level of segmentation
        -- supported by this device.
        default {[ BBacnetSegmentation.noSegmentation ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.SEGMENTATION_SUPPORTED,
                                 ASN_ENUMERATED) ]}
      apduTimeout: BBacnetUnsigned
        -- apduTimeout is the time in milliseconds between retransmissions of an APDU.
        -- <p>If the device does not support modification of this parameter,
        -- it shall be set to 60000 milliseconds.
        default {[ new BBacnetUnsigned(3000) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.APDU_TIMEOUT,
                                 ASN_UNSIGNED) ]}
      numberOfAPDURetries: BBacnetUnsigned
        -- numberOfAPDURetries indicates the number of retransmissions of an APDU.
        default {[ new BBacnetUnsigned(3) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.NUMBER_OF_APDU_RETRIES,
                                 ASN_UNSIGNED) ]}
      deviceAddressBinding: BBacnetListOf
        -- list of device ids with the BacnetAddress used to communicate to
        -- each device.
        default {[ new BBacnetListOf(BBacnetAddressBinding.TYPE) ]}
        slotfacets{[ makeFacets(BBacnetPropertyIdentifier.DEVICE_ADDRESS_BINDING,
                                ASN_BACNET_LIST) ]}
      databaseRevision: BBacnetUnsigned
        flags { readonly }
        default {[ new BBacnetUnsigned(-1) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.DATABASE_REVISION,
                                 ASN_UNSIGNED) ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.config.BBacnetDeviceObject(942340109)1.0$ @*/
/* Generated Fri Oct 15 06:36:46 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "systemStatus"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>systemStatus</code> property.
   * systemStatus reflects the status of the Bacnet device
   * as reported by the device.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#getSystemStatus
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#setSystemStatus
   */
  public static final Property systemStatus = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetDeviceStatus.OPERATIONAL,
    BEnumRange.make(BBacnetDeviceStatus.TYPE)), makeFacets(BBacnetPropertyIdentifier.SYSTEM_STATUS,
    ASN_ENUMERATED));

  /**
   * Get the <code>systemStatus</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#systemStatus
   */
  public BEnum getSystemStatus()
  {
    return (BEnum)get(systemStatus);
  }

  /**
   * Set the <code>systemStatus</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#systemStatus
   */
  public void setSystemStatus(BEnum v)
  {
    set(systemStatus, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "vendorName"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>vendorName</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#getVendorName
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#setVendorName
   */
  public static final Property vendorName = newProperty(Flags.READONLY, "", makeFacets(BBacnetPropertyIdentifier.VENDOR_NAME,
    ASN_CHARACTER_STRING));

  /**
   * Get the <code>vendorName</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#vendorName
   */
  public String getVendorName()
  {
    return getString(vendorName);
  }

  /**
   * Set the <code>vendorName</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#vendorName
   */
  public void setVendorName(String v)
  {
    setString(vendorName, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "vendorIdentifier"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>vendorIdentifier</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#getVendorIdentifier
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#setVendorIdentifier
   */
  public static final Property vendorIdentifier = newProperty(Flags.READONLY, new BBacnetUnsigned(-1), makeFacets(BBacnetPropertyIdentifier.VENDOR_IDENTIFIER,
    ASN_UNSIGNED));

  /**
   * Get the <code>vendorIdentifier</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#vendorIdentifier
   */
  public BBacnetUnsigned getVendorIdentifier()
  {
    return (BBacnetUnsigned)get(vendorIdentifier);
  }

  /**
   * Set the <code>vendorIdentifier</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#vendorIdentifier
   */
  public void setVendorIdentifier(BBacnetUnsigned v)
  {
    set(vendorIdentifier, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "modelName"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>modelName</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#getModelName
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#setModelName
   */
  public static final Property modelName = newProperty(Flags.READONLY, "", makeFacets(BBacnetPropertyIdentifier.MODEL_NAME,
    ASN_CHARACTER_STRING));

  /**
   * Get the <code>modelName</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#modelName
   */
  public String getModelName()
  {
    return getString(modelName);
  }

  /**
   * Set the <code>modelName</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#modelName
   */
  public void setModelName(String v)
  {
    setString(modelName, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "firmwareRevision"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>firmwareRevision</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#getFirmwareRevision
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#setFirmwareRevision
   */
  public static final Property firmwareRevision = newProperty(Flags.READONLY, "", makeFacets(BBacnetPropertyIdentifier.FIRMWARE_REVISION,
    ASN_CHARACTER_STRING));

  /**
   * Get the <code>firmwareRevision</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#firmwareRevision
   */
  public String getFirmwareRevision()
  {
    return getString(firmwareRevision);
  }

  /**
   * Set the <code>firmwareRevision</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#firmwareRevision
   */
  public void setFirmwareRevision(String v)
  {
    setString(firmwareRevision, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "applicationSoftwareVersion"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>applicationSoftwareVersion</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#getApplicationSoftwareVersion
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#setApplicationSoftwareVersion
   */
  public static final Property applicationSoftwareVersion = newProperty(Flags.READONLY, "", makeFacets(BBacnetPropertyIdentifier.APPLICATION_SOFTWARE_VERSION,
    ASN_CHARACTER_STRING));

  /**
   * Get the <code>applicationSoftwareVersion</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#applicationSoftwareVersion
   */
  public String getApplicationSoftwareVersion()
  {
    return getString(applicationSoftwareVersion);
  }

  /**
   * Set the <code>applicationSoftwareVersion</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#applicationSoftwareVersion
   */
  public void setApplicationSoftwareVersion(String v)
  {
    setString(applicationSoftwareVersion, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "protocolVersion"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>protocolVersion</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#getProtocolVersion
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#setProtocolVersion
   */
  public static final Property protocolVersion = newProperty(Flags.READONLY, new BBacnetUnsigned(1), makeFacets(BBacnetPropertyIdentifier.PROTOCOL_VERSION,
    ASN_UNSIGNED));

  /**
   * Get the <code>protocolVersion</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#protocolVersion
   */
  public BBacnetUnsigned getProtocolVersion()
  {
    return (BBacnetUnsigned)get(protocolVersion);
  }

  /**
   * Set the <code>protocolVersion</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#protocolVersion
   */
  public void setProtocolVersion(BBacnetUnsigned v)
  {
    set(protocolVersion, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "protocolRevision"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>protocolRevision</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#getProtocolRevision
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#setProtocolRevision
   */
  public static final Property protocolRevision = newProperty(Flags.READONLY, new BBacnetUnsigned(0), makeFacets(BBacnetPropertyIdentifier.PROTOCOL_REVISION,
    ASN_UNSIGNED));

  /**
   * Get the <code>protocolRevision</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#protocolRevision
   */
  public BBacnetUnsigned getProtocolRevision()
  {
    return (BBacnetUnsigned)get(protocolRevision);
  }

  /**
   * Set the <code>protocolRevision</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#protocolRevision
   */
  public void setProtocolRevision(BBacnetUnsigned v)
  {
    set(protocolRevision, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "protocolServicesSupported"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>protocolServicesSupported</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#getProtocolServicesSupported
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#setProtocolServicesSupported
   */
  public static final Property protocolServicesSupported = newProperty(Flags.READONLY, BBacnetBitString.emptyBitString(
    BacnetBitStringUtil.getBitStringLength("BacnetServicesSupported")), makeFacets(BBacnetPropertyIdentifier.PROTOCOL_SERVICES_SUPPORTED,
    ASN_BIT_STRING,
    BacnetBitStringUtil.BACNET_SERVICES_SUPPORTED_MAP));

  /**
   * Get the <code>protocolServicesSupported</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#protocolServicesSupported
   */
  public BBacnetBitString getProtocolServicesSupported()
  {
    return (BBacnetBitString)get(protocolServicesSupported);
  }

  /**
   * Set the <code>protocolServicesSupported</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#protocolServicesSupported
   */
  public void setProtocolServicesSupported(BBacnetBitString v)
  {
    set(protocolServicesSupported, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "protocolObjectTypesSupported"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>protocolObjectTypesSupported</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#getProtocolObjectTypesSupported
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#setProtocolObjectTypesSupported
   */
  public static final Property protocolObjectTypesSupported = newProperty(Flags.READONLY, BBacnetBitString.emptyBitString(
    BacnetBitStringUtil.getBitStringLength("BacnetObjectTypesSupported")), makeFacets(BBacnetPropertyIdentifier.PROTOCOL_OBJECT_TYPES_SUPPORTED,
    ASN_BIT_STRING,
    BacnetBitStringUtil.BACNET_OBJECT_TYPES_SUPPORTED_MAP));

  /**
   * Get the <code>protocolObjectTypesSupported</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#protocolObjectTypesSupported
   */
  public BBacnetBitString getProtocolObjectTypesSupported()
  {
    return (BBacnetBitString)get(protocolObjectTypesSupported);
  }

  /**
   * Set the <code>protocolObjectTypesSupported</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#protocolObjectTypesSupported
   */
  public void setProtocolObjectTypesSupported(BBacnetBitString v)
  {
    set(protocolObjectTypesSupported, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "objectList"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>objectList</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#getObjectList
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#setObjectList
   */
  public static final Property objectList = newProperty(Flags.HIDDEN | Flags.READONLY, new BBacnetArray(BBacnetObjectIdentifier.TYPE), makeFacets(BBacnetPropertyIdentifier.OBJECT_LIST,
    ASN_BACNET_ARRAY));

  /**
   * Get the <code>objectList</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#objectList
   */
  public BBacnetArray getObjectList()
  {
    return (BBacnetArray)get(objectList);
  }

  /**
   * Set the <code>objectList</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#objectList
   */
  public void setObjectList(BBacnetArray v)
  {
    set(objectList, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "maxAPDULengthAccepted"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>maxAPDULengthAccepted</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#getMaxAPDULengthAccepted
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#setMaxAPDULengthAccepted
   */
  public static final Property maxAPDULengthAccepted = newProperty(Flags.READONLY, new BBacnetUnsigned(ConfirmedRequestPdu.MAX_APDU_LENGTH_UP_TO_MIN_MSG_SIZE), makeFacets(BBacnetPropertyIdentifier.MAX_APDU_LENGTH_ACCEPTED,
    ASN_UNSIGNED));

  /**
   * Get the <code>maxAPDULengthAccepted</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#maxAPDULengthAccepted
   */
  public BBacnetUnsigned getMaxAPDULengthAccepted()
  {
    return (BBacnetUnsigned)get(maxAPDULengthAccepted);
  }

  /**
   * Set the <code>maxAPDULengthAccepted</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#maxAPDULengthAccepted
   */
  public void setMaxAPDULengthAccepted(BBacnetUnsigned v)
  {
    set(maxAPDULengthAccepted, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "segmentationSupported"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>segmentationSupported</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#getSegmentationSupported
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#setSegmentationSupported
   */
  public static final Property segmentationSupported = newProperty(Flags.READONLY, BBacnetSegmentation.noSegmentation, makeFacets(BBacnetPropertyIdentifier.SEGMENTATION_SUPPORTED,
    ASN_ENUMERATED));

  /**
   * Get the <code>segmentationSupported</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#segmentationSupported
   */
  public BBacnetSegmentation getSegmentationSupported()
  {
    return (BBacnetSegmentation)get(segmentationSupported);
  }

  /**
   * Set the <code>segmentationSupported</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#segmentationSupported
   */
  public void setSegmentationSupported(BBacnetSegmentation v)
  {
    set(segmentationSupported, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "apduTimeout"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>apduTimeout</code> property.
   * apduTimeout is the time in milliseconds between retransmissions
   * of an APDU. <p>If the device does not support modification
   * of this parameter, it shall be set to 60000 milliseconds.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#getApduTimeout
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#setApduTimeout
   */
  public static final Property apduTimeout = newProperty(0, new BBacnetUnsigned(3000), makeFacets(BBacnetPropertyIdentifier.APDU_TIMEOUT,
    ASN_UNSIGNED));

  /**
   * Get the <code>apduTimeout</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#apduTimeout
   */
  public BBacnetUnsigned getApduTimeout()
  {
    return (BBacnetUnsigned)get(apduTimeout);
  }

  /**
   * Set the <code>apduTimeout</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#apduTimeout
   */
  public void setApduTimeout(BBacnetUnsigned v)
  {
    set(apduTimeout, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "numberOfAPDURetries"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>numberOfAPDURetries</code> property.
   * numberOfAPDURetries indicates the number of retransmissions
   * of an APDU.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#getNumberOfAPDURetries
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#setNumberOfAPDURetries
   */
  public static final Property numberOfAPDURetries = newProperty(0, new BBacnetUnsigned(3), makeFacets(BBacnetPropertyIdentifier.NUMBER_OF_APDU_RETRIES,
    ASN_UNSIGNED));

  /**
   * Get the <code>numberOfAPDURetries</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#numberOfAPDURetries
   */
  public BBacnetUnsigned getNumberOfAPDURetries()
  {
    return (BBacnetUnsigned)get(numberOfAPDURetries);
  }

  /**
   * Set the <code>numberOfAPDURetries</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#numberOfAPDURetries
   */
  public void setNumberOfAPDURetries(BBacnetUnsigned v)
  {
    set(numberOfAPDURetries, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "deviceAddressBinding"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>deviceAddressBinding</code> property.
   * list of device ids with the BacnetAddress used to communicate to each device.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#getDeviceAddressBinding
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#setDeviceAddressBinding
   */
  public static final Property deviceAddressBinding = newProperty(0, new BBacnetListOf(BBacnetAddressBinding.TYPE), makeFacets(BBacnetPropertyIdentifier.DEVICE_ADDRESS_BINDING,
    ASN_BACNET_LIST));

  /**
   * Get the <code>deviceAddressBinding</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#deviceAddressBinding
   */
  public BBacnetListOf getDeviceAddressBinding()
  {
    return (BBacnetListOf)get(deviceAddressBinding);
  }

  /**
   * Set the <code>deviceAddressBinding</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#deviceAddressBinding
   */
  public void setDeviceAddressBinding(BBacnetListOf v)
  {
    set(deviceAddressBinding, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "databaseRevision"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>databaseRevision</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#getDatabaseRevision
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#setDatabaseRevision
   */
  public static final Property databaseRevision = newProperty(Flags.READONLY, new BBacnetUnsigned(-1), makeFacets(BBacnetPropertyIdentifier.DATABASE_REVISION,
    ASN_UNSIGNED));

  /**
   * Get the <code>databaseRevision</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#databaseRevision
   */
  public BBacnetUnsigned getDatabaseRevision()
  {
    return (BBacnetUnsigned)get(databaseRevision);
  }

  /**
   * Set the <code>databaseRevision</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetDeviceObject#databaseRevision
   */
  public void setDatabaseRevision(BBacnetUnsigned v)
  {
    set(databaseRevision, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetDeviceObject.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Constructors
////////////////////////////////////////////////////////////////

  public BBacnetDeviceObject()
  {
  }


////////////////////////////////////////////////////////////////
//  BComponent
////////////////////////////////////////////////////////////////

  /**
   * Started.
   */
  public void started()
    throws Exception
  {
    super.started();
    oldId = getObjectId();
  }

  /**
   * Property Added.
   */
  @Override
  public void added(Property p, Context cx)
  {
    super.added(p, cx);

    if (!isRunning())
    {
      return;
    }

    if (BBacnetPropertyIdentifier.maxSegmentsAccepted.getTag().equals(p.getName()))
    {
      if (log.isLoggable(Level.FINE))
      {
        log.fine(device().getName() + " added slot maxSegmentsAccepted " + device().getMaxSegmentsAccepted());
      }

      DeviceRegistry.update(device());
      if (log.isLoggable(Level.FINEST))
      {
        log.finest(device().getName() + " deviceObject added callback execution finish for property " + p);
      }
    }
  }

  /**
   * Property Changed.
   */
  public void changed(Property p, Context cx)
  {
    super.changed(p, cx);
    if (!isRunning() || (cx == fallback)) return;
    if (p.equals(objectId))
    {
      BBacnetObjectIdentifier newId = getObjectId();
      BBacnetNetwork network = BBacnetNetwork.bacnet();
      if (newId.equals(oldId)) return;
      BBacnetDevice d = network.doLookupDeviceById(newId);
      if ((d != null) && (d != device()))
      {
        log.severe("Duplicate Object ID:" + newId + ", used by " + d.getName()
          + "!\n  Resetting to old id:" + oldId);
        set(objectId, oldId, fallback);
      }
      else
      {
        if (log.isLoggable(Level.FINE))
          log.fine("Object ID changed from " + oldId + " to " + newId);
        device().objectIdChanged();
        network.getLocalDevice().updateAddressBinding(oldId, newId);
        network.updateDevice(device());

        // Must remove the old entry because the new ID should not be present and then the address
        // map to the old ID will not be removed when calling update.
        if (oldId != null)
        {
          DeviceRegistry.remove(oldId);
        }
        DeviceRegistry.update(device());

        oldId = newId;
      }
    }
    else if (p.equals(protocolRevision))
    {
      DeviceRegistry.update(device());
    }
    else if (p.equals(segmentationSupported))
    {
      if (log.isLoggable(Level.FINE))
      {
        log.fine(device().getName() + " segmentationSupported changed to " + device().getSegmentationSupported());
      }

      DeviceRegistry.update(device());
    }
    else if (p.equals(maxAPDULengthAccepted))
    {
      if (log.isLoggable(Level.FINE))
      {
        log.fine(device().getName() + " maxAPDULengthAccepted changed to " + device().getMaxAPDULengthAccepted());
      }

      DeviceRegistry.update(device());
    }
    // maxSegmentsAccepted is an optional, dynamic property
    else if (BBacnetPropertyIdentifier.maxSegmentsAccepted.getTag().equals(p.getName()))
    {
      if (log.isLoggable(Level.FINE))
      {
        log.fine(device().getName() + " maxSegmentsAccepted changed to " + device().getMaxSegmentsAccepted());
      }

      DeviceRegistry.update(device());
    }
    if (p.equals(protocolServicesSupported))
    {
      device().updateServicesSupported();
    }

    if (log.isLoggable(Level.FINEST))
    {
      log.finest(device().getName() + " deviceObject changed callback execution finish for property " + p);
    }
  }

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  /**
   * To String.
   */
  public String toString(Context context)
  {
    return getObjectName() + " [" + getObjectId().toString(context) + "]";
  }

  /**
   * Should this property ID be polled?
   * Override point for objects to filter properties for polling, e.g.,
   * Object_List in Device object, or Log_Buffer in Trend Log.
   */
  protected boolean shouldPoll(int propertyId)
  {
    switch (propertyId)
    {
      case BBacnetPropertyIdentifier.SYSTEM_STATUS:
      case BBacnetPropertyIdentifier.LOCAL_TIME:
      case BBacnetPropertyIdentifier.LOCAL_DATE:
      case BBacnetPropertyIdentifier.DAYLIGHT_SAVINGS_STATUS:
        return true;
      default:
        return false;
    }
  }

  /**
   * Callback for processing upLoad on async thread.
   * Default implementation is to call asyncUpload on all
   * children implementing the  Loadable interface.
   */
  public void doUpload(BUploadParameters p, Context cx)
  {
    // Bail if device is down or disabled, or objectId is bad.
    if (!device().getEnabled() || getStatus().isDown())
    {
      if (log.isLoggable(Level.FINE))
      {
        log.fine(device().getName() + " is either disabled or status is down, deviceObject upload is unsuccessful.");
      }
      return;
    }
    if (!getObjectId().isValid()) return;

    try
    {
      readProperty(maxAPDULengthAccepted);
      readProperty(segmentationSupported);
      readProperty(vendorIdentifier);
      readProperty(modelName);
      readProperty(firmwareRevision);
      readProperty(applicationSoftwareVersion);

      // Determine the vendor-specific objectTypes file if null.
      if (getVendorIdentifier().getInt() == VENDOR_ID_TRIDIUM)
      {
        if (getFirmwareRevision().startsWith("3"))
        {
          try
          {
            BOrd vendorObjectTypesFile = (BOrd)device().get("vendorObjectTypesFile");
            if ((vendorObjectTypesFile != null) && !vendorObjectTypesFile.equals(BOrd.NULL))
            {
              DefaultFileCopy.copyFile("niagaraAxBacnetObjectTypes.xml");
              device().set("vendorObjectTypesFile", BOrd.make("file!defaults/niagaraAxBacnetObjectTypes.xml"));
            }
//          if (device().getVendorObjectTypesFile().equals(BOrd.NULL))
//          {
//            device().setVendorObjectTypesFile(BOrd.make("file:!lib/niagaraAxBacnetObjectTypes.xml"));
//          }
          }
          catch (Exception e)
          {
            if (log.isLoggable(Level.FINE))
            {
              log.log(Level.FINE, "Exception setting vendorObjectTypesFile for BACnet deviceObject " + this + ":" + e, e);
            }
          }
        }
      }
    }
    catch (Exception e)
    {
      if (log.isLoggable(Level.FINE))
      {
        log.log(Level.FINE, "Exception uploading BACnet deviceObject " + this + ":" + e, e);
      }
    }
    super.doUpload(p, cx);
    if (log.isLoggable(Level.FINEST))
    {
      log.finest(device().getName() + "deviceObject upload execution finish.");
    }
  }


////////////////////////////////////////////////////////////////
//  Access methods
////////////////////////////////////////////////////////////////

  public int getMaxSegmentsAccepted()
  {
    BBacnetUnsigned msa = (BBacnetUnsigned)get(BBacnetPropertyIdentifier.maxSegmentsAccepted.getTag());
    if (msa != null) return msa.getInt();
    return ConfirmedRequestPdu.MAX_SEGS_UNSPECIFIED;
  }


////////////////////////////////////////////////////////////////
// Spy
////////////////////////////////////////////////////////////////

  public void spy(SpyWriter out)
    throws Exception
  {
    super.spy(out);
    out.startProps();
    out.trTitle("BacnetDeviceObject", 2);
    out.prop("oldId", oldId);
    out.endProps();
  }


////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  private BBacnetObjectIdentifier oldId;

////////////////////////////////////////////////////////////////
//  Constants
////////////////////////////////////////////////////////////////


}
