/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.sys.*;

import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetPriorityValue;
import javax.baja.bacnet.enums.*;

/**
 * @author Craig Gemmill
 * @version $Revision: 9$ $Date: 12/11/01 2:48:34 PM$
 * @creation 18 Jul 01
 * @since Niagara 3 Bacnet 1.0
 */
public class BBacnetBinaryOutput
  extends BBacnetBinary
{

////////////////////////////////////////////////////////////////
// Slot overrides
////////////////////////////////////////////////////////////////

  public static final Property objectId = newProperty(Flags.SUMMARY,
    BBacnetObjectIdentifier.make(BBacnetObjectType.BINARY_OUTPUT),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER,
      ASN_OBJECT_IDENTIFIER));

  public static final Property objectType = newProperty(Flags.READONLY,
    BDynamicEnum.make(BBacnetObjectType.BINARY_OUTPUT,
      BEnumRange.make(BBacnetObjectType.TYPE)),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE,
      ASN_ENUMERATED));

  /*-

  class  BBacnetBinaryOutput
  {
    properties
    {
      polarity: BBacnetPolarity
        -- polarity describes the relationship between the physical state
        -- of the point and the logical state represented by the presentValue
        -- property.
        default {[ BBacnetPolarity.normal ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.POLARITY,
                                 ASN_ENUMERATED) ]}
      priorityArray: BBacnetArray
        default {[ new BBacnetArray(BBacnetPriorityValue.TYPE, 16) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.PRIORITY_ARRAY,
                                 ASN_BACNET_ARRAY) ]}
      relinquishDefault: BBacnetBinaryPv
        default {[ BBacnetBinaryPv.inactive ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.RELINQUISH_DEFAULT,
                                 ASN_ENUMERATED) ]}
    }

    actions
    {
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.config.BBacnetBinaryOutput(1033728697)1.0$ @*/
/* Generated Fri Sep 15 09:15:27 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "polarity"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>polarity</code> property.
   * polarity describes the relationship between the physical
   * state of the point and the logical state represented
   * by the presentValue property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinaryOutput#getPolarity
   * @see javax.baja.bacnet.config.BBacnetBinaryOutput#setPolarity
   */
  public static final Property polarity = newProperty(0, BBacnetPolarity.normal, makeFacets(BBacnetPropertyIdentifier.POLARITY,
    ASN_ENUMERATED));

  /**
   * Get the <code>polarity</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinaryOutput#polarity
   */
  public BBacnetPolarity getPolarity()
  {
    return (BBacnetPolarity)get(polarity);
  }

  /**
   * Set the <code>polarity</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinaryOutput#polarity
   */
  public void setPolarity(BBacnetPolarity v)
  {
    set(polarity, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "priorityArray"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>priorityArray</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinaryOutput#getPriorityArray
   * @see javax.baja.bacnet.config.BBacnetBinaryOutput#setPriorityArray
   */
  public static final Property priorityArray = newProperty(0, new BBacnetArray(BBacnetPriorityValue.TYPE, 16), makeFacets(BBacnetPropertyIdentifier.PRIORITY_ARRAY,
    ASN_BACNET_ARRAY));

  /**
   * Get the <code>priorityArray</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinaryOutput#priorityArray
   */
  public BBacnetArray getPriorityArray()
  {
    return (BBacnetArray)get(priorityArray);
  }

  /**
   * Set the <code>priorityArray</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinaryOutput#priorityArray
   */
  public void setPriorityArray(BBacnetArray v)
  {
    set(priorityArray, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "relinquishDefault"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>relinquishDefault</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinaryOutput#getRelinquishDefault
   * @see javax.baja.bacnet.config.BBacnetBinaryOutput#setRelinquishDefault
   */
  public static final Property relinquishDefault = newProperty(0, BBacnetBinaryPv.inactive, makeFacets(BBacnetPropertyIdentifier.RELINQUISH_DEFAULT,
    ASN_ENUMERATED));

  /**
   * Get the <code>relinquishDefault</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinaryOutput#relinquishDefault
   */
  public BBacnetBinaryPv getRelinquishDefault()
  {
    return (BBacnetBinaryPv)get(relinquishDefault);
  }

  /**
   * Set the <code>relinquishDefault</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinaryOutput#relinquishDefault
   */
  public void setRelinquishDefault(BBacnetBinaryPv v)
  {
    set(relinquishDefault, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetBinaryOutput.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  /**
   */
  public BBacnetBinaryOutput()
  {
  }


////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  /**
   * Apply the "facets" property to the "presentValue" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot == priorityArray) return getFacets();
    if (slot == relinquishDefault) return getFacets();
//    if (slot.equals(priorityArray)) return getFacets();
    return super.getSlotFacets(slot);
  }


////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
//  Constants
////////////////////////////////////////////////////////////////

}
