/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.sys.*;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.enums.BBacnetBinaryPv;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.util.BacnetBitStringUtil;

/**
 * @author Craig Gemmill
 * @version $Revision: 7$ $Date: 12/10/01 9:26:03 AM$
 * @creation 31 Jan 01
 * @since Niagara 3 Bacnet 1.0
 */
abstract public class BBacnetBinary
  extends BBacnetObject
{
  /*-

  class  BBacnetBinary
  {
    properties
    {
      presentValue: BBacnetBinaryPv
        -- presentValue represents the object's current value.
        default {[ BBacnetBinaryPv.inactive ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.PRESENT_VALUE,
                                 ASN_ENUMERATED) ]}
      facets: BFacets
        -- These facets are applied against the presentValue property.
        -- They are determined from the Active_Text and Inactive_Text
        -- properties (if present).
        flags { hidden, readonly }
        default {[ BFacets.DEFAULT ]}

      statusFlags: BBacnetBitString
        -- statusFlags represents flags indicating the alarm and fault status of
        -- the Bacnet object.
        flags { readonly }
        default {[ BBacnetBitString.emptyBitString(
                   BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS,
                                 ASN_BIT_STRING,
                                 BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP) ]}
      eventState: BEnum
        -- eventState indicates if this object has an active event state.
        flags { readonly }
        default {[ BDynamicEnum.make(BBacnetEventState.NORMAL,
                                    BEnumRange.make(BBacnetEventState.TYPE)) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.EVENT_STATE,
                                 ASN_ENUMERATED) ]}
      outOfService: boolean
        -- is the physical point represented by this object out of service?
        -- if TRUE, then this point's Present_Value does NOT reflect the actual state
        -- of the point.
        default {[ false ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.OUT_OF_SERVICE,
                                 ASN_BOOLEAN) ]}
    }

    actions
    {
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.config.BBacnetBinary(2563432352)1.0$ @*/
/* Generated Thu Aug 10 14:02:36 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "presentValue"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>presentValue</code> property.
   * presentValue represents the object's current value.
   *
   * @see javax.baja.bacnet.config.BBacnetBinary#getPresentValue
   * @see javax.baja.bacnet.config.BBacnetBinary#setPresentValue
   */
  public static final Property presentValue = newProperty(0, BBacnetBinaryPv.inactive, makeFacets(BBacnetPropertyIdentifier.PRESENT_VALUE,
    ASN_ENUMERATED));

  /**
   * Get the <code>presentValue</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinary#presentValue
   */
  public BBacnetBinaryPv getPresentValue()
  {
    return (BBacnetBinaryPv)get(presentValue);
  }

  /**
   * Set the <code>presentValue</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinary#presentValue
   */
  public void setPresentValue(BBacnetBinaryPv v)
  {
    set(presentValue, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the presentValue property. They are determined from the Active_Text and Inactive_Text properties (if present).
   *
   * @see javax.baja.bacnet.config.BBacnetBinary#getFacets
   * @see javax.baja.bacnet.config.BBacnetBinary#setFacets
   */
  public static final Property facets = newProperty(Flags.HIDDEN | Flags.READONLY, BFacets.DEFAULT, null);

  /**
   * Get the <code>facets</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinary#facets
   */
  public BFacets getFacets()
  {
    return (BFacets)get(facets);
  }

  /**
   * Set the <code>facets</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinary#facets
   */
  public void setFacets(BFacets v)
  {
    set(facets, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "statusFlags"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>statusFlags</code> property.
   * statusFlags represents flags indicating the alarm and fault status of the Bacnet object.
   *
   * @see javax.baja.bacnet.config.BBacnetBinary#getStatusFlags
   * @see javax.baja.bacnet.config.BBacnetBinary#setStatusFlags
   */
  public static final Property statusFlags = newProperty(Flags.READONLY, BBacnetBitString.emptyBitString(
    BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS,
    ASN_BIT_STRING,
    BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP));

  /**
   * Get the <code>statusFlags</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinary#statusFlags
   */
  public BBacnetBitString getStatusFlags()
  {
    return (BBacnetBitString)get(statusFlags);
  }

  /**
   * Set the <code>statusFlags</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinary#statusFlags
   */
  public void setStatusFlags(BBacnetBitString v)
  {
    set(statusFlags, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "eventState"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>eventState</code> property.
   * eventState indicates if this object has an active event state.
   *
   * @see javax.baja.bacnet.config.BBacnetBinary#getEventState
   * @see javax.baja.bacnet.config.BBacnetBinary#setEventState
   */
  public static final Property eventState = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetEventState.NORMAL,
    BEnumRange.make(BBacnetEventState.TYPE)), makeFacets(BBacnetPropertyIdentifier.EVENT_STATE,
    ASN_ENUMERATED));

  /**
   * Get the <code>eventState</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinary#eventState
   */
  public BEnum getEventState()
  {
    return (BEnum)get(eventState);
  }

  /**
   * Set the <code>eventState</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinary#eventState
   */
  public void setEventState(BEnum v)
  {
    set(eventState, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "outOfService"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>outOfService</code> property.
   * is the physical point represented by this object out
   * of service? if TRUE, then this point's Present_Value
   * does NOT reflect the actual state of the point.
   *
   * @see javax.baja.bacnet.config.BBacnetBinary#getOutOfService
   * @see javax.baja.bacnet.config.BBacnetBinary#setOutOfService
   */
  public static final Property outOfService = newProperty(0, false, makeFacets(BBacnetPropertyIdentifier.OUT_OF_SERVICE,
    ASN_BOOLEAN));

  /**
   * Get the <code>outOfService</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinary#outOfService
   */
  public boolean getOutOfService()
  {
    return getBoolean(outOfService);
  }

  /**
   * Set the <code>outOfService</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinary#outOfService
   */
  public void setOutOfService(boolean v)
  {
    setBoolean(outOfService, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetBinary.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  public BBacnetBinary()
  {
  }


////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////

  public String toString(Context context)
  {
    StringBuilder sb = new StringBuilder();
    sb.append(getObjectId().toString(context)).append(" = " + getPresentValue().toString(context));
    return sb.toString();
  }


////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  /**
   * Property changed.
   public void changed(Property p, Context cx)
   {
   super.changed(p,cx);
   if (!isRunning()) return;
   if (p == facets) return;
   }
   */

  /**
   * Apply the "facets" property to the "presentValue" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot == presentValue) return getFacets();
    if (slot.getName().equals("alarmValue")) return getFacets();
    if (slot.getName().equals("feedbackValue")) return getFacets();
    if (slot.getName().equals("relinquishDefault")) return getFacets();
    return super.getSlotFacets(slot);
  }

  public void setOutputFacets()
  {
    BString activeText = (BString)get("activeText");
    BString inactiveText = (BString)get("inactiveText");
    BFacets f = BFacets.makeBoolean(
      ((activeText != null) ? activeText : (BString.make("true"))),
      ((inactiveText != null) ? inactiveText : (BString.make("false"))));
    setFacets(f);
  }

  /**
   * Subclasses that have a present value property should
   * override this method and return this property.  The
   * default returns null.
   */
  public Property getPresentValueProperty()
  {
    return presentValue;
  }

////////////////////////////////////////////////////////////////
//  Test Code
////////////////////////////////////////////////////////////////

}
