/*
 * Copyright 2006 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.sys.*;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;

/**
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 25 Jul 2006
 * @since Niagara 3.2
 */
public class BBacnetAveraging
  extends BBacnetObject
{

////////////////////////////////////////////////////////////////
// Slot overrides
////////////////////////////////////////////////////////////////

  public static final Property objectId = newProperty(Flags.SUMMARY,
    BBacnetObjectIdentifier.make(BBacnetObjectType.AVERAGING),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER,
      ASN_OBJECT_IDENTIFIER));

  public static final Property objectType = newProperty(Flags.READONLY,
    BDynamicEnum.make(BBacnetObjectType.AVERAGING,
      BEnumRange.make(BBacnetObjectType.TYPE)),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE,
      ASN_ENUMERATED));

  /*-

  class BBacnetAveraging
  {
    properties
    {
      facets: BFacets
        -- These facets are applied against the minimumValue, averageValue,
        -- and maximumValue properties.
        flags { readonly }
        default {[ BFacets.DEFAULT ]}

      minimumValue: float
        default {[ 0 ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.MINIMUM_VALUE,
                                 ASN_REAL) ]}
      averageValue: float
        default {[ 0 ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.AVERAGE_VALUE,
                                 ASN_REAL) ]}
      maximumValue: float
        default {[ 0 ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.MAXIMUM_VALUE,
                                 ASN_REAL) ]}
      attemptedSamples: BBacnetUnsigned
        default {[ BBacnetUnsigned.make(0) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.ATTEMPTED_SAMPLES,
                                 ASN_UNSIGNED) ]}
      validSamples: BBacnetUnsigned
        default {[ BBacnetUnsigned.make(0) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.VALID_SAMPLES,
                                 ASN_UNSIGNED) ]}
      objectPropertyReference: BBacnetDeviceObjectPropertyReference
        default {[ new BBacnetDeviceObjectPropertyReference() ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.OBJECT_PROPERTY_REFERENCE,
                                 ASN_CONSTRUCTED_DATA) ]}
      windowInterval: BBacnetUnsigned
        default {[ BBacnetUnsigned.make(0) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.WINDOW_INTERVAL,
                                 ASN_UNSIGNED) ]}
      windowSamples: BBacnetUnsigned
        default {[ BBacnetUnsigned.make(0) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.WINDOW_SAMPLES,
                                 ASN_UNSIGNED) ]}
    }

    actions
    {
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.config.BBacnetAveraging(4156834679)1.0$ @*/
/* Generated Tue Jul 25 15:53:24 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the minimumValue,
   * averageValue, and maximumValue properties.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#getFacets
   * @see javax.baja.bacnet.config.BBacnetAveraging#setFacets
   */
  public static final Property facets = newProperty(Flags.READONLY, BFacets.DEFAULT, null);

  /**
   * Get the <code>facets</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#facets
   */
  public BFacets getFacets()
  {
    return (BFacets)get(facets);
  }

  /**
   * Set the <code>facets</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#facets
   */
  public void setFacets(BFacets v)
  {
    set(facets, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "minimumValue"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>minimumValue</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#getMinimumValue
   * @see javax.baja.bacnet.config.BBacnetAveraging#setMinimumValue
   */
  public static final Property minimumValue = newProperty(0, 0, makeFacets(BBacnetPropertyIdentifier.MINIMUM_VALUE,
    ASN_REAL));

  /**
   * Get the <code>minimumValue</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#minimumValue
   */
  public float getMinimumValue()
  {
    return getFloat(minimumValue);
  }

  /**
   * Set the <code>minimumValue</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#minimumValue
   */
  public void setMinimumValue(float v)
  {
    setFloat(minimumValue, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "averageValue"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>averageValue</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#getAverageValue
   * @see javax.baja.bacnet.config.BBacnetAveraging#setAverageValue
   */
  public static final Property averageValue = newProperty(0, 0, makeFacets(BBacnetPropertyIdentifier.AVERAGE_VALUE,
    ASN_REAL));

  /**
   * Get the <code>averageValue</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#averageValue
   */
  public float getAverageValue()
  {
    return getFloat(averageValue);
  }

  /**
   * Set the <code>averageValue</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#averageValue
   */
  public void setAverageValue(float v)
  {
    setFloat(averageValue, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "maximumValue"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>maximumValue</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#getMaximumValue
   * @see javax.baja.bacnet.config.BBacnetAveraging#setMaximumValue
   */
  public static final Property maximumValue = newProperty(0, 0, makeFacets(BBacnetPropertyIdentifier.MAXIMUM_VALUE,
    ASN_REAL));

  /**
   * Get the <code>maximumValue</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#maximumValue
   */
  public float getMaximumValue()
  {
    return getFloat(maximumValue);
  }

  /**
   * Set the <code>maximumValue</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#maximumValue
   */
  public void setMaximumValue(float v)
  {
    setFloat(maximumValue, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "attemptedSamples"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>attemptedSamples</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#getAttemptedSamples
   * @see javax.baja.bacnet.config.BBacnetAveraging#setAttemptedSamples
   */
  public static final Property attemptedSamples = newProperty(0, BBacnetUnsigned.make(0), makeFacets(BBacnetPropertyIdentifier.ATTEMPTED_SAMPLES,
    ASN_UNSIGNED));

  /**
   * Get the <code>attemptedSamples</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#attemptedSamples
   */
  public BBacnetUnsigned getAttemptedSamples()
  {
    return (BBacnetUnsigned)get(attemptedSamples);
  }

  /**
   * Set the <code>attemptedSamples</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#attemptedSamples
   */
  public void setAttemptedSamples(BBacnetUnsigned v)
  {
    set(attemptedSamples, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "validSamples"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>validSamples</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#getValidSamples
   * @see javax.baja.bacnet.config.BBacnetAveraging#setValidSamples
   */
  public static final Property validSamples = newProperty(0, BBacnetUnsigned.make(0), makeFacets(BBacnetPropertyIdentifier.VALID_SAMPLES,
    ASN_UNSIGNED));

  /**
   * Get the <code>validSamples</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#validSamples
   */
  public BBacnetUnsigned getValidSamples()
  {
    return (BBacnetUnsigned)get(validSamples);
  }

  /**
   * Set the <code>validSamples</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#validSamples
   */
  public void setValidSamples(BBacnetUnsigned v)
  {
    set(validSamples, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "objectPropertyReference"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>objectPropertyReference</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#getObjectPropertyReference
   * @see javax.baja.bacnet.config.BBacnetAveraging#setObjectPropertyReference
   */
  public static final Property objectPropertyReference = newProperty(0, new BBacnetDeviceObjectPropertyReference(), makeFacets(BBacnetPropertyIdentifier.OBJECT_PROPERTY_REFERENCE,
    ASN_CONSTRUCTED_DATA));

  /**
   * Get the <code>objectPropertyReference</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#objectPropertyReference
   */
  public BBacnetDeviceObjectPropertyReference getObjectPropertyReference()
  {
    return (BBacnetDeviceObjectPropertyReference)get(objectPropertyReference);
  }

  /**
   * Set the <code>objectPropertyReference</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#objectPropertyReference
   */
  public void setObjectPropertyReference(BBacnetDeviceObjectPropertyReference v)
  {
    set(objectPropertyReference, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "windowInterval"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>windowInterval</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#getWindowInterval
   * @see javax.baja.bacnet.config.BBacnetAveraging#setWindowInterval
   */
  public static final Property windowInterval = newProperty(0, BBacnetUnsigned.make(0), makeFacets(BBacnetPropertyIdentifier.WINDOW_INTERVAL,
    ASN_UNSIGNED));

  /**
   * Get the <code>windowInterval</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#windowInterval
   */
  public BBacnetUnsigned getWindowInterval()
  {
    return (BBacnetUnsigned)get(windowInterval);
  }

  /**
   * Set the <code>windowInterval</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#windowInterval
   */
  public void setWindowInterval(BBacnetUnsigned v)
  {
    set(windowInterval, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "windowSamples"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>windowSamples</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#getWindowSamples
   * @see javax.baja.bacnet.config.BBacnetAveraging#setWindowSamples
   */
  public static final Property windowSamples = newProperty(0, BBacnetUnsigned.make(0), makeFacets(BBacnetPropertyIdentifier.WINDOW_SAMPLES,
    ASN_UNSIGNED));

  /**
   * Get the <code>windowSamples</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#windowSamples
   */
  public BBacnetUnsigned getWindowSamples()
  {
    return (BBacnetUnsigned)get(windowSamples);
  }

  /**
   * Set the <code>windowSamples</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAveraging#windowSamples
   */
  public void setWindowSamples(BBacnetUnsigned v)
  {
    set(windowSamples, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetAveraging.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  public BBacnetAveraging()
  {
  }

////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////

  public String toString(Context context)
  {
    StringBuilder sb = new StringBuilder();
    sb.append(getObjectId().toString(context));
    return sb.toString();
  }


////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  /**
   * Property changed.
   public void changed(Property p, Context cx)
   {
   super.changed(p,cx);
   if (!isRunning()) return;
   if (p == facets) return;
   }
   */

  /**
   * Apply the "facets" property to the "presentValue" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot.equals(minimumValue)) return getFacets();
    if (slot.equals(averageValue)) return getFacets();
    if (slot.equals(maximumValue)) return getFacets();
    if (slot.getName().equals("varianceValue")) return getFacets();
    return super.getSlotFacets(slot);
  }


////////////////////////////////////////////////////////////////
//  Constants
////////////////////////////////////////////////////////////////

}
