/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.sys.*;

import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetPriorityValue;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;

/**
 * @author Craig Gemmill
 * @version $Revision: 8$ $Date: 12/11/01 2:48:33 PM$
 * @creation 18 Jul 01
 * @since Niagara 3 Bacnet 1.0
 */
public class BBacnetAnalogOutput
  extends BBacnetAnalog
{

////////////////////////////////////////////////////////////////
// Slot overrides
////////////////////////////////////////////////////////////////

  public static final Property objectId = newProperty(Flags.SUMMARY,
    BBacnetObjectIdentifier.make(BBacnetObjectType.ANALOG_OUTPUT),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER,
      ASN_OBJECT_IDENTIFIER));

  public static final Property objectType = newProperty(Flags.READONLY,
    BDynamicEnum.make(BBacnetObjectType.ANALOG_OUTPUT,
      BEnumRange.make(BBacnetObjectType.TYPE)),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE,
      ASN_ENUMERATED));

  /*-

  class  BBacnetAnalogOutput
  {
    properties
    {
      priorityArray: BBacnetArray
        default {[ new BBacnetArray(BBacnetPriorityValue.TYPE, 16) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.PRIORITY_ARRAY,
                                 ASN_BACNET_ARRAY) ]}
      relinquishDefault: float
        default {[ 0 ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.RELINQUISH_DEFAULT,
                                 ASN_REAL) ]}
    }

    actions
    {
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.config.BBacnetAnalogOutput(1674501183)1.0$ @*/
/* Generated Fri Sep 15 09:15:27 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "priorityArray"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>priorityArray</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAnalogOutput#getPriorityArray
   * @see javax.baja.bacnet.config.BBacnetAnalogOutput#setPriorityArray
   */
  public static final Property priorityArray = newProperty(0, new BBacnetArray(BBacnetPriorityValue.TYPE, 16), makeFacets(BBacnetPropertyIdentifier.PRIORITY_ARRAY,
    ASN_BACNET_ARRAY));

  /**
   * Get the <code>priorityArray</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAnalogOutput#priorityArray
   */
  public BBacnetArray getPriorityArray()
  {
    return (BBacnetArray)get(priorityArray);
  }

  /**
   * Set the <code>priorityArray</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAnalogOutput#priorityArray
   */
  public void setPriorityArray(BBacnetArray v)
  {
    set(priorityArray, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "relinquishDefault"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>relinquishDefault</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAnalogOutput#getRelinquishDefault
   * @see javax.baja.bacnet.config.BBacnetAnalogOutput#setRelinquishDefault
   */
  public static final Property relinquishDefault = newProperty(0, 0, makeFacets(BBacnetPropertyIdentifier.RELINQUISH_DEFAULT,
    ASN_REAL));

  /**
   * Get the <code>relinquishDefault</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAnalogOutput#relinquishDefault
   */
  public float getRelinquishDefault()
  {
    return getFloat(relinquishDefault);
  }

  /**
   * Set the <code>relinquishDefault</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetAnalogOutput#relinquishDefault
   */
  public void setRelinquishDefault(float v)
  {
    setFloat(relinquishDefault, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetAnalogOutput.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  /**
   */
  public BBacnetAnalogOutput()
  {
  }


////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  /**
   * Apply the "facets" property to the "priorityArray" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot == priorityArray) return getFacets();
    if (slot == relinquishDefault) return getFacets();
//    if (slot.getDeclaringType() == BBacnetArray.TYPE) return getFacets();
//    if (slot.equals(priorityArray)) return getFacets();
    return super.getSlotFacets(slot);
  }


////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
//  Constants
////////////////////////////////////////////////////////////////

}
