/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
/**
 *
 */
package javax.baja.bacnet.alarm;

import java.util.logging.Logger;

import javax.baja.sys.*;

import javax.baja.alarm.BAlarmRecord;

/**
 * @author cgemmill
 */
public class BBacnetEventProcessor
  extends BStruct
{
  /*-
  class BBacnetEventProcessor
  {
    properties
    {
      processId:long
        default {[ 1 ]}
        slotfacets {[ BFacets.make(BFacets.MIN, BLong.make(0), BFacets.MAX, BLong.make(0x7FFFFFFF)) ]}
    }
  } 
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.alarm.BBacnetEventProcessor(1886405222)1.0$ @*/
/* Generated Fri Dec 29 10:39:34 EST 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "processId"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>processId</code> property.
   *
   * @see javax.baja.bacnet.alarm.BBacnetEventProcessor#getProcessId
   * @see javax.baja.bacnet.alarm.BBacnetEventProcessor#setProcessId
   */
  public static final Property processId = newProperty(0, 1, BFacets.make(BFacets.MIN, BLong.make(0), BFacets.MAX, BLong.make(0x7FFFFFFF)));

  /**
   * Get the <code>processId</code> property.
   *
   * @see javax.baja.bacnet.alarm.BBacnetEventProcessor#processId
   */
  public long getProcessId()
  {
    return getLong(processId);
  }

  /**
   * Set the <code>processId</code> property.
   *
   * @see javax.baja.bacnet.alarm.BBacnetEventProcessor#processId
   */
  public void setProcessId(long v)
  {
    setLong(processId, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetEventProcessor.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Route the alarm.
   * This is the override point for event processors.
   * Here a subclass may either process the alarm itself, or route it
   * to another class for processing.  Note that the Niagara alarm system
   * will already have processed the alarm IF its processId matches the
   * niagaraProcessId in the AlarmDeviceExt.
   */
  public void routeAlarm(BAlarmRecord record)
  {
    logger.info("BacnetEventProcessor(" + getProcessId() + "):routeAlarm::\n" + record);
  }

  private static final Logger logger = Logger.getLogger("bacnet.alarm");
}
