/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet;

import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.sys.*;

/**
 * BIBacnetObjectContainer resolves a triplet of object identifier,
 * property identifier, and property array index to a Bacnet point.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 02 Sep 03
 * @since Niagara 3 Bacnet 1.0
 */

public interface BIBacnetObjectContainer
  extends BInterface
{
  /**
   * Look up and return the Bacnet object with the given reference.
   *
   * @param objectId
   * @param propertyId
   * @param propertyArrayIndex
   * @param domain             the realm in which to look up the object: point, schedule, history
   * @returns a BObject with the given reference parameters, or null if
   * this container does not contain any objects with the given parameters.
   */
  BObject lookupBacnetObject(BBacnetObjectIdentifier objectId,
                             int propertyId,
                             int propertyArrayIndex,
                             String domain);


  String POINT = "point";
  String SCHEDULE = "schedule";
  String HISTORY = "history";
  String CONFIG = "config";


////////////////////////////////////////////////////////////////
//  Type
////////////////////////////////////////////////////////////////

  Type TYPE = Sys.loadType(BIBacnetObjectContainer.class);
}
