/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.alarmOrion;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.baja.naming.BOrd;
import javax.baja.sys.BFacets;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridium.alarmOrion.OrionObjectCache;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.PropertyValue;

public class BOrionAlarmSource
  extends BOrionObject
{
  public final static int OLD_SOURCE_LENGTH  = 256; //This number is too big for MySql 5.6
  public final static int SOURCE_LENGTH      = AccessController.doPrivileged((PrivilegedAction<Integer>)
    () -> Integer.getInteger("niagara.alarmOrion.maxSourceLength", 255).intValue());
  
  /*-
  @Mode(Orion)
  class BOrionAlarmSource
  {
    properties
    {
      id: int
        flags { readonly, summary }
        default {[ -1 ]}
        slotfacets {[ ID_KEY ]}

      source: BOrd
        -- The path to the source of the alarm.
        flags {summary}
        default {[BOrd.NULL]}
        slotfacets {[ UNIQUE = true, WIDTH = SOURCE_LENGTH]}
    }
  }
-*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.alarmOrion.BOrionAlarmSource(3846222378)1.0$ @*/
/* Generated Mon Aug 26 15:08:10 EDT 2013 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "id"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>id</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmSource#getId
   * @see javax.baja.alarmOrion.BOrionAlarmSource#setId
   */
  public static final Property id = newProperty(Flags.READONLY|Flags.SUMMARY, -1,ID_KEY);
  
  /**
   * Get the <code>id</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmSource#id
   */
  public int getId() { return getInt(id); }
  
  /**
   * Set the <code>id</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmSource#id
   */
  public void setId(int v) { setInt(id,v,null); }

////////////////////////////////////////////////////////////////
// Property "source"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>source</code> property.
   * The path to the source of the alarm.
   * @see javax.baja.alarmOrion.BOrionAlarmSource#getSource
   * @see javax.baja.alarmOrion.BOrionAlarmSource#setSource
   */
  public static final Property source = newProperty(Flags.SUMMARY, BOrd.NULL,BFacets.make(BFacets.make(UNIQUE,true),BFacets.make(WIDTH,SOURCE_LENGTH)));
  
  /**
   * Get the <code>source</code> property.
   * The path to the source of the alarm.
   * @see javax.baja.alarmOrion.BOrionAlarmSource#source
   */
  public BOrd getSource() { return (BOrd)get(source); }
  
  /**
   * Set the <code>source</code> property.
   * The path to the source of the alarm.
   * @see javax.baja.alarmOrion.BOrionAlarmSource#source
   */
  public void setSource(BOrd v) { set(source,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return getTypeFromSpace(TYPE); }
  public static final Type TYPE = Sys.loadType(BOrionAlarmSource.class);
  public static final OrionType ORION_TYPE = (OrionType)TYPE;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public static BOrionAlarmSource get(BOrd ord, OrionSession session)
  {
    if(cache.contains(ord))
      return (BOrionAlarmSource)cache.get(ord);
    
    OrionCursor cursor = session.select(BOrionAlarmSource.ORION_TYPE, new PropertyValue(BOrionAlarmSource.source, ord));
    BOrionAlarmSource alarmSource;
    if(cursor.next())
    {
      alarmSource = (BOrionAlarmSource)cursor.get();
      cursor.close();
    } else {
      alarmSource = new BOrionAlarmSource();
      alarmSource.setSource(ord);
      session.insert(alarmSource);
    }
    cache.put(ord, alarmSource);
    return alarmSource;
  }
  
  public void afterDelete(OrionSession session)
  {
    cache.remove(getSource());
  }

  public void afterInsert(OrionSession session)
  {
    cache.put(getSource(), this);
  }

  public void afterUpdate(OrionSession session)
  {
    cache.update(getSource(), this);
  }  
  
  private static OrionObjectCache cache = new OrionObjectCache(100);  
}
