/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.alarmOrion;

import java.io.IOException;

import javax.baja.data.DataUtil;
import com.tridium.orion.*;
import javax.baja.rdb.ddl.*;
import javax.baja.sys.*;

/**
 * The representation of an alarm data facet value within the orion database.
 *
 * @author Lee Adcock
 * @creation March 18, 2009
 */
public class BOrionAlarmFacetValue
  extends BOrionObject
{
  /*-
  @Mode(Orion)
  class BOrionAlarmFacetValue
  {
    properties
    {
      id: int
        flags { readonly, summary }
        default {[ -1 ]}
        slotfacets {[ ID_KEY, CLUSTERED = false ]}
    
      @Ref(BOrionAlarmRecord)
      alarm: BRef
        flags { summary }
        default {[ BRef.make("alarmOrion:OrionAlarmRecord") ]}
        slotfacets {[ INDEXED = true, CLUSTERED = true, DESCENDING = true,  ON_DELETE = BOnDelete.CASCADE ]}
      
      @Ref(BOrionAlarmFacetName)
      facetName: BRef
        flags { summary }
        default {[ BRef.make("alarmOrion:OrionAlarmFacetName") ]}
        slotfacets {[ ON_DELETE = BOnDelete.CASCADE ]}

      value: String
        flags {summary}
        default {[""]}
        slotfacets {[ BFacets.make("width", BInteger.make(512)) ]}
    }
  }
-*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.alarmOrion.BOrionAlarmFacetValue(2892231259)1.0$ @*/
/* Generated Wed Mar 17 11:09:34 EDT 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "id"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>id</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmFacetValue#getId
   * @see javax.baja.alarmOrion.BOrionAlarmFacetValue#setId
   */
  public static final Property id = newProperty(Flags.READONLY|Flags.SUMMARY, -1,BFacets.make(ID_KEY,BFacets.make(CLUSTERED,false)));
  
  /**
   * Get the <code>id</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmFacetValue#id
   */
  public int getId() { return getInt(id); }
  
  /**
   * Set the <code>id</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmFacetValue#id
   */
  public void setId(int v) { setInt(id,v,null); }

////////////////////////////////////////////////////////////////
// Property "alarm"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>alarm</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmFacetValue#getAlarm
   * @see javax.baja.alarmOrion.BOrionAlarmFacetValue#setAlarm
   */
  public static final Property alarm = newProperty(Flags.SUMMARY, BRef.make("alarmOrion:OrionAlarmRecord"),BFacets.make(BFacets.make(BFacets.make(BFacets.make(INDEXED,true),BFacets.make(CLUSTERED,true)),BFacets.make(DESCENDING,true)),BFacets.make(ON_DELETE,BOnDelete.CASCADE)));
  
  /**
   * Get the <code>alarm</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmFacetValue#alarm
   */
  public BRef getAlarm() { return (BRef)get(alarm); }
  
  /**
   * Set the <code>alarm</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmFacetValue#alarm
   */
  public void setAlarm(BRef v) { set(alarm,v,null); }
  
  /**
   * Resolve the <code>alarm</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmFacetValue#alarm
   */
  public BOrionAlarmRecord resolveAlarm(OrionSession session)
  {
    return (BOrionAlarmRecord)getAlarm().getTarget(session);
  }

////////////////////////////////////////////////////////////////
// Property "facetName"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facetName</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmFacetValue#getFacetName
   * @see javax.baja.alarmOrion.BOrionAlarmFacetValue#setFacetName
   */
  public static final Property facetName = newProperty(Flags.SUMMARY, BRef.make("alarmOrion:OrionAlarmFacetName"),BFacets.make(ON_DELETE,BOnDelete.CASCADE));
  
  /**
   * Get the <code>facetName</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmFacetValue#facetName
   */
  public BRef getFacetName() { return (BRef)get(facetName); }
  
  /**
   * Set the <code>facetName</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmFacetValue#facetName
   */
  public void setFacetName(BRef v) { set(facetName,v,null); }
  
////////////////////////////////////////////////////////////////
// Property "value"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>value</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmFacetValue#getValue
   * @see javax.baja.alarmOrion.BOrionAlarmFacetValue#setValue
   */
  public static final Property value = newProperty(Flags.SUMMARY, "",BFacets.make("width", BInteger.make(512)));
  
  /**
   * Get the <code>value</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmFacetValue#value
   */
  public String getValue() { return getString(value); }
  
  /**
   * Set the <code>value</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmFacetValue#value
   */
  public void setValue(String v) { setString(value,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return getTypeFromSpace(TYPE); }
  public static final Type TYPE = Sys.loadType(BOrionAlarmFacetValue.class);
  public static final OrionType ORION_TYPE = (OrionType)TYPE;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BOrionAlarmFacetName resolveFacetName(OrionSession session)
  {
    BRef ref = getFacetName();
    
    if (!ref.isBound()) return null;

    if (!ref.isResolved())
    {
      BOrionAlarmFacetName facetName = BOrionAlarmFacetName.get(((BInteger)ref.getId()).getInt(), session);
      ref.resolve(facetName);      
      return facetName;
    } else
      return (BOrionAlarmFacetName)ref.getTarget();
  }  
  
  /**
   * Create a BOrionAlarmData object from the provided parameters.
   */
  public static BOrionAlarmFacetValue make(String key, BObject value, BOrionAlarmRecord alarm, OrionSession session)
  {
    try
    {
      return make(key, DataUtil.marshal(value), alarm, session);
    } catch (IOException ioe) {
      throw new BajaRuntimeException("Unable to marshal facet data.", ioe);
    }
  }
  
  /**
   * Create a BOrionAlarmData object from the provided parameters.
   * @param value Must be encoded BObject as returned by DataUtil.marshal
   */
  public static BOrionAlarmFacetValue make(String key, String value, BOrionAlarmRecord alarm, OrionSession session)
  {
    BOrionAlarmFacetName dataName = BOrionAlarmFacetName.get(key, session);

    BOrionAlarmFacetValue data = new BOrionAlarmFacetValue();
    data.setAlarm(BRef.make(alarm));

    data.setFacetName(BRef.make(dataName));
    data.setValue(value);
    return data;
  }  
}
